package io.ciera.tool.sql.architecture.statement.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.expression.ExpressionSet;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionSetImpl;
import io.ciera.tool.sql.architecture.relationship.ClassRelationshipSet;
import io.ciera.tool.sql.architecture.relationship.impl.ClassRelationshipSetImpl;
import io.ciera.tool.sql.architecture.statement.StatementSet;
import io.ciera.tool.sql.architecture.statement.UnrelateSmt;
import io.ciera.tool.sql.architecture.statement.UnrelateSmtSet;
import io.ciera.tool.sql.architecture.statement.impl.StatementSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class UnrelateSmtSetImpl extends InstanceSet<UnrelateSmtSet,UnrelateSmt> implements UnrelateSmtSet {

    public UnrelateSmtSetImpl() {
    }

    public UnrelateSmtSetImpl(Comparator<? super UnrelateSmt> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setPart_expression_number( String ref_part_expression_number ) throws XtumlException {
        for ( UnrelateSmt unrelatesmt : this ) unrelatesmt.setPart_expression_number( ref_part_expression_number );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( UnrelateSmt unrelatesmt : this ) unrelatesmt.setParent_name( ref_parent_name );
    }
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        for ( UnrelateSmt unrelatesmt : this ) unrelatesmt.setStatement_number( ref_statement_number );
    }
    @Override
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        for ( UnrelateSmt unrelatesmt : this ) unrelatesmt.setComp_name( ref_comp_name );
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( UnrelateSmt unrelatesmt : this ) unrelatesmt.setParent_package( ref_parent_package );
    }
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        for ( UnrelateSmt unrelatesmt : this ) unrelatesmt.setBody_name( ref_body_name );
    }
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        for ( UnrelateSmt unrelatesmt : this ) unrelatesmt.setBlock_number( ref_block_number );
    }
    @Override
    public void setRel_name( String ref_rel_name ) throws XtumlException {
        for ( UnrelateSmt unrelatesmt : this ) unrelatesmt.setRel_name( ref_rel_name );
    }
    @Override
    public void setForm_expression_number( String ref_form_expression_number ) throws XtumlException {
        for ( UnrelateSmt unrelatesmt : this ) unrelatesmt.setForm_expression_number( ref_form_expression_number );
    }
    @Override
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        for ( UnrelateSmt unrelatesmt : this ) unrelatesmt.setComp_package( ref_comp_package );
    }


    // selections
    @Override
    public StatementSet R451_is_a_Statement() throws XtumlException {
        StatementSet statementset = new StatementSetImpl();
        for ( UnrelateSmt unrelatesmt : this ) statementset.add( unrelatesmt.R451_is_a_Statement() );
        return statementset;
    }
    @Override
    public ExpressionSet R482_unrelates_participating_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( UnrelateSmt unrelatesmt : this ) expressionset.add( unrelatesmt.R482_unrelates_participating_Expression() );
        return expressionset;
    }
    @Override
    public ExpressionSet R483_unrelates_formalizing_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( UnrelateSmt unrelatesmt : this ) expressionset.add( unrelatesmt.R483_unrelates_formalizing_Expression() );
        return expressionset;
    }
    @Override
    public ClassRelationshipSet R484_deletes_instances_of_ClassRelationship() throws XtumlException {
        ClassRelationshipSet classrelationshipset = new ClassRelationshipSetImpl();
        for ( UnrelateSmt unrelatesmt : this ) classrelationshipset.add( unrelatesmt.R484_deletes_instances_of_ClassRelationship() );
        return classrelationshipset;
    }


    @Override
    public UnrelateSmt nullElement() {
        return UnrelateSmtImpl.EMPTY_UNRELATESMT;
    }

    @Override
    public UnrelateSmtSet emptySet() {
      return new UnrelateSmtSetImpl();
    }

    @Override
    public UnrelateSmtSet emptySet(Comparator<? super UnrelateSmt> comp) {
      return new UnrelateSmtSetImpl(comp);
    }

    @Override
    public List<UnrelateSmt> elements() {
        return Arrays.asList(toArray(new UnrelateSmt[0]));
    }

}
