package io.ciera.tool.sql.architecture.statement.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.expression.Expression;
import io.ciera.tool.sql.architecture.expression.VariableReference;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionImpl;
import io.ciera.tool.sql.architecture.invocable.CodeBlock;
import io.ciera.tool.sql.architecture.statement.ReturnSmt;
import io.ciera.tool.sql.architecture.statement.Statement;
import io.ciera.tool.sql.architecture.statement.impl.StatementImpl;


public class ReturnSmtImpl extends ModelInstance<ReturnSmt,Sql> implements ReturnSmt {

    public static final String KEY_LETTERS = "ReturnSmt";
    public static final ReturnSmt EMPTY_RETURNSMT = new EmptyReturnSmt();

    private Sql context;

    // constructors
    private ReturnSmtImpl( Sql context ) {
        this.context = context;
        ref_parent_name = "";
        ref_parent_package = "";
        ref_body_name = "";
        ref_block_number = "";
        ref_statement_number = "";
        ref_ret_expression_number = "";
        R451_is_a_Statement_inst = StatementImpl.EMPTY_STATEMENT;
        R473_returns_value_specified_by_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
    }

    private ReturnSmtImpl( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_ret_expression_number ) {
        super(instanceId);
        this.context = context;
        this.ref_parent_name = ref_parent_name;
        this.ref_parent_package = ref_parent_package;
        this.ref_body_name = ref_body_name;
        this.ref_block_number = ref_block_number;
        this.ref_statement_number = ref_statement_number;
        this.ref_ret_expression_number = ref_ret_expression_number;
        R451_is_a_Statement_inst = StatementImpl.EMPTY_STATEMENT;
        R473_returns_value_specified_by_Expression_inst = ExpressionImpl.EMPTY_EXPRESSION;
    }

    public static ReturnSmt create( Sql context ) throws XtumlException {
        ReturnSmt newReturnSmt = new ReturnSmtImpl( context );
        if ( context.addInstance( newReturnSmt ) ) {
            newReturnSmt.getRunContext().addChange(new InstanceCreatedDelta(newReturnSmt, KEY_LETTERS));
            return newReturnSmt;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ReturnSmt create( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_body_name, String ref_block_number, String ref_statement_number, String ref_ret_expression_number ) throws XtumlException {
        ReturnSmt newReturnSmt = new ReturnSmtImpl( context, instanceId, ref_parent_name, ref_parent_package, ref_body_name, ref_block_number, ref_statement_number, ref_ret_expression_number );
        if ( context.addInstance( newReturnSmt ) ) {
            return newReturnSmt;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_parent_name;
    @Override
    public void setParent_name(String ref_parent_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_name, this.ref_parent_name)) {
            final String oldValue = this.ref_parent_name;
            this.ref_parent_name = ref_parent_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_name", oldValue, this.ref_parent_name));
        }
    }
    @Override
    public String getParent_name() throws XtumlException {
        checkLiving();
        return ref_parent_name;
    }
    private String ref_parent_package;
    @Override
    public void setParent_package(String ref_parent_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_package, this.ref_parent_package)) {
            final String oldValue = this.ref_parent_package;
            this.ref_parent_package = ref_parent_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_package", oldValue, this.ref_parent_package));
        }
    }
    @Override
    public String getParent_package() throws XtumlException {
        checkLiving();
        return ref_parent_package;
    }
    private String ref_body_name;
    @Override
    public String getBody_name() throws XtumlException {
        checkLiving();
        return ref_body_name;
    }
    @Override
    public void setBody_name(String ref_body_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_body_name, this.ref_body_name)) {
            final String oldValue = this.ref_body_name;
            this.ref_body_name = ref_body_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_body_name", oldValue, this.ref_body_name));
        }
    }
    private String ref_block_number;
    @Override
    public String getBlock_number() throws XtumlException {
        checkLiving();
        return ref_block_number;
    }
    @Override
    public void setBlock_number(String ref_block_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_block_number, this.ref_block_number)) {
            final String oldValue = this.ref_block_number;
            this.ref_block_number = ref_block_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_block_number", oldValue, this.ref_block_number));
        }
    }
    private String ref_statement_number;
    @Override
    public void setStatement_number(String ref_statement_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_statement_number, this.ref_statement_number)) {
            final String oldValue = this.ref_statement_number;
            this.ref_statement_number = ref_statement_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_statement_number", oldValue, this.ref_statement_number));
        }
    }
    @Override
    public String getStatement_number() throws XtumlException {
        checkLiving();
        return ref_statement_number;
    }
    private String ref_ret_expression_number;
    @Override
    public void setRet_expression_number(String ref_ret_expression_number) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_ret_expression_number, this.ref_ret_expression_number)) {
            final String oldValue = this.ref_ret_expression_number;
            this.ref_ret_expression_number = ref_ret_expression_number;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_ret_expression_number", oldValue, this.ref_ret_expression_number));
        }
    }
    @Override
    public String getRet_expression_number() throws XtumlException {
        checkLiving();
        return ref_ret_expression_number;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getParent_name(), getParent_package(), getBody_name(), getBlock_number(), getStatement_number());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        context().T().push_buffer();
        Statement smt = self().R451_is_a_Statement();
        String oal = smt.getOal();
        String prefix = smt.getPrefix();
        CodeBlock block = smt.R450_is_contained_by_CodeBlock();
        String indent = context().getIndent( block.getTab_depth() + 1 );
        Expression expression = self().R473_returns_value_specified_by_Expression();
        String ret_expression_body = "";
        if ( !expression.isEmpty() ) {
            expression.render();
            ret_expression_body = context().T().body();
        }
        context().T().pop_buffer();
        VariableReference return_var_ref = self().R451_is_a_Statement().R775_may_contain_Expression().R776_is_a_VariableReference().any();
        String block_suffix = block.getSuffix();
        context().T().include( "statement/t.return.java", block_suffix, indent, oal, prefix, ret_expression_body );
    }



    // static operations


    // events


    // selections
    private Statement R451_is_a_Statement_inst;
    @Override
    public void setR451_is_a_Statement( Statement inst ) {
        R451_is_a_Statement_inst = inst;
    }
    @Override
    public Statement R451_is_a_Statement() throws XtumlException {
        return R451_is_a_Statement_inst;
    }
    private Expression R473_returns_value_specified_by_Expression_inst;
    @Override
    public void setR473_returns_value_specified_by_Expression( Expression inst ) {
        R473_returns_value_specified_by_Expression_inst = inst;
    }
    @Override
    public Expression R473_returns_value_specified_by_Expression() throws XtumlException {
        return R473_returns_value_specified_by_Expression_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ReturnSmt self() {
        return this;
    }

    @Override
    public ReturnSmt oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_RETURNSMT;
    }

}

class EmptyReturnSmt extends ModelInstance<ReturnSmt,Sql> implements ReturnSmt {

    // attributes
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getBody_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBody_name( String ref_body_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getBlock_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getStatement_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRet_expression_number( String ref_ret_expression_number ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getRet_expression_number() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public Statement R451_is_a_Statement() {
        return StatementImpl.EMPTY_STATEMENT;
    }
    @Override
    public Expression R473_returns_value_specified_by_Expression() {
        return ExpressionImpl.EMPTY_EXPRESSION;
    }


    @Override
    public String getKeyLetters() {
        return ReturnSmtImpl.KEY_LETTERS;
    }

    @Override
    public ReturnSmt self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ReturnSmt oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ReturnSmtImpl.EMPTY_RETURNSMT;
    }

}
