package io.ciera.tool.sql.architecture.statement.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.statement.BreakSmt;
import io.ciera.tool.sql.architecture.statement.BreakSmtSet;
import io.ciera.tool.sql.architecture.statement.StatementSet;
import io.ciera.tool.sql.architecture.statement.impl.StatementSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class BreakSmtSetImpl extends InstanceSet<BreakSmtSet,BreakSmt> implements BreakSmtSet {

    public BreakSmtSetImpl() {
    }

    public BreakSmtSetImpl(Comparator<? super BreakSmt> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        for ( BreakSmt breaksmt : this ) breaksmt.setBody_name( ref_body_name );
    }
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        for ( BreakSmt breaksmt : this ) breaksmt.setBlock_number( ref_block_number );
    }
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        for ( BreakSmt breaksmt : this ) breaksmt.setStatement_number( ref_statement_number );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( BreakSmt breaksmt : this ) breaksmt.setParent_name( ref_parent_name );
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( BreakSmt breaksmt : this ) breaksmt.setParent_package( ref_parent_package );
    }


    // selections
    @Override
    public StatementSet R451_is_a_Statement() throws XtumlException {
        StatementSet statementset = new StatementSetImpl();
        for ( BreakSmt breaksmt : this ) statementset.add( breaksmt.R451_is_a_Statement() );
        return statementset;
    }


    @Override
    public BreakSmt nullElement() {
        return BreakSmtImpl.EMPTY_BREAKSMT;
    }

    @Override
    public BreakSmtSet emptySet() {
      return new BreakSmtSetImpl();
    }

    @Override
    public BreakSmtSet emptySet(Comparator<? super BreakSmt> comp) {
      return new BreakSmtSetImpl(comp);
    }

    @Override
    public List<BreakSmt> elements() {
        return Arrays.asList(toArray(new BreakSmt[0]));
    }

}
