package io.ciera.tool.sql.architecture.invocable.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.expression.ActualParameter;
import io.ciera.tool.sql.architecture.expression.ActualParameterSet;
import io.ciera.tool.sql.architecture.expression.ParameterReference;
import io.ciera.tool.sql.architecture.expression.ParameterReferenceSet;
import io.ciera.tool.sql.architecture.expression.impl.ActualParameterSetImpl;
import io.ciera.tool.sql.architecture.expression.impl.ParameterReferenceSetImpl;
import io.ciera.tool.sql.architecture.invocable.FormalParameter;
import io.ciera.tool.sql.architecture.invocable.InvocableObject;
import io.ciera.tool.sql.architecture.invocable.impl.FormalParameterImpl;
import io.ciera.tool.sql.architecture.invocable.impl.InvocableObjectImpl;
import io.ciera.tool.sql.architecture.type.TypeReference;
import io.ciera.tool.sql.architecture.type.impl.TypeReferenceImpl;


public class FormalParameterImpl extends ModelInstance<FormalParameter,Sql> implements FormalParameter {

    public static final String KEY_LETTERS = "FormalParameter";
    public static final FormalParameter EMPTY_FORMALPARAMETER = new EmptyFormalParameter();

    private Sql context;

    // constructors
    private FormalParameterImpl( Sql context ) {
        this.context = context;
        ref_parent_name = "";
        ref_parent_package = "";
        ref_invocable_name = "";
        m_name = "";
        ref_next_name = "";
        m_by_ref = false;
        ref_type_name = "";
        ref_type_package = "";
        ref_type_reference_name = "";
        R3904_ActualParameter_set = new ActualParameterSetImpl();
        R404_follows_FormalParameter_inst = FormalParameterImpl.EMPTY_FORMALPARAMETER;
        R404_precedes_FormalParameter_inst = FormalParameterImpl.EMPTY_FORMALPARAMETER;
        R429_shapes_data_for_InvocableObject_inst = InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
        R431_is_typed_by_TypeReference_inst = TypeReferenceImpl.EMPTY_TYPEREFERENCE;
        R781_referenced_by_ParameterReference_set = new ParameterReferenceSetImpl();
    }

    private FormalParameterImpl( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_invocable_name, String m_name, String ref_next_name, boolean m_by_ref, String ref_type_name, String ref_type_package, String ref_type_reference_name ) {
        super(instanceId);
        this.context = context;
        this.ref_parent_name = ref_parent_name;
        this.ref_parent_package = ref_parent_package;
        this.ref_invocable_name = ref_invocable_name;
        this.m_name = m_name;
        this.ref_next_name = ref_next_name;
        this.m_by_ref = m_by_ref;
        this.ref_type_name = ref_type_name;
        this.ref_type_package = ref_type_package;
        this.ref_type_reference_name = ref_type_reference_name;
        R3904_ActualParameter_set = new ActualParameterSetImpl();
        R404_follows_FormalParameter_inst = FormalParameterImpl.EMPTY_FORMALPARAMETER;
        R404_precedes_FormalParameter_inst = FormalParameterImpl.EMPTY_FORMALPARAMETER;
        R429_shapes_data_for_InvocableObject_inst = InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
        R431_is_typed_by_TypeReference_inst = TypeReferenceImpl.EMPTY_TYPEREFERENCE;
        R781_referenced_by_ParameterReference_set = new ParameterReferenceSetImpl();
    }

    public static FormalParameter create( Sql context ) throws XtumlException {
        FormalParameter newFormalParameter = new FormalParameterImpl( context );
        if ( context.addInstance( newFormalParameter ) ) {
            newFormalParameter.getRunContext().addChange(new InstanceCreatedDelta(newFormalParameter, KEY_LETTERS));
            return newFormalParameter;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static FormalParameter create( Sql context, UniqueId instanceId, String ref_parent_name, String ref_parent_package, String ref_invocable_name, String m_name, String ref_next_name, boolean m_by_ref, String ref_type_name, String ref_type_package, String ref_type_reference_name ) throws XtumlException {
        FormalParameter newFormalParameter = new FormalParameterImpl( context, instanceId, ref_parent_name, ref_parent_package, ref_invocable_name, m_name, ref_next_name, m_by_ref, ref_type_name, ref_type_package, ref_type_reference_name );
        if ( context.addInstance( newFormalParameter ) ) {
            return newFormalParameter;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_parent_name;
    @Override
    public String getParent_name() throws XtumlException {
        checkLiving();
        return ref_parent_name;
    }
    @Override
    public void setParent_name(String ref_parent_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_name, this.ref_parent_name)) {
            final String oldValue = this.ref_parent_name;
            this.ref_parent_name = ref_parent_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_name", oldValue, this.ref_parent_name));
            if ( !R781_referenced_by_ParameterReference().isEmpty() ) R781_referenced_by_ParameterReference().setParam_parent_name( ref_parent_name );
            if ( !R3904_ActualParameter().isEmpty() ) R3904_ActualParameter().setInvoked_parent_name( ref_parent_name );
            if ( !R404_follows_FormalParameter().isEmpty() ) R404_follows_FormalParameter().setParent_name( ref_parent_name );
        }
    }
    private String ref_parent_package;
    @Override
    public void setParent_package(String ref_parent_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_parent_package, this.ref_parent_package)) {
            final String oldValue = this.ref_parent_package;
            this.ref_parent_package = ref_parent_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_parent_package", oldValue, this.ref_parent_package));
            if ( !R3904_ActualParameter().isEmpty() ) R3904_ActualParameter().setInvoked_parent_package( ref_parent_package );
            if ( !R404_follows_FormalParameter().isEmpty() ) R404_follows_FormalParameter().setParent_package( ref_parent_package );
            if ( !R781_referenced_by_ParameterReference().isEmpty() ) R781_referenced_by_ParameterReference().setParam_parent_package( ref_parent_package );
        }
    }
    @Override
    public String getParent_package() throws XtumlException {
        checkLiving();
        return ref_parent_package;
    }
    private String ref_invocable_name;
    @Override
    public void setInvocable_name(String ref_invocable_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_invocable_name, this.ref_invocable_name)) {
            final String oldValue = this.ref_invocable_name;
            this.ref_invocable_name = ref_invocable_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_invocable_name", oldValue, this.ref_invocable_name));
            if ( !R404_follows_FormalParameter().isEmpty() ) R404_follows_FormalParameter().setInvocable_name( ref_invocable_name );
            if ( !R3904_ActualParameter().isEmpty() ) R3904_ActualParameter().setInvoked_name( ref_invocable_name );
            if ( !R781_referenced_by_ParameterReference().isEmpty() ) R781_referenced_by_ParameterReference().setParam_body_name( ref_invocable_name );
        }
    }
    @Override
    public String getInvocable_name() throws XtumlException {
        checkLiving();
        return ref_invocable_name;
    }
    private String m_name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_name;
    }
    @Override
    public void setName(String m_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_name, this.m_name)) {
            final String oldValue = this.m_name;
            this.m_name = m_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_name", oldValue, this.m_name));
            if ( !R404_follows_FormalParameter().isEmpty() ) R404_follows_FormalParameter().setNext_name( m_name );
            if ( !R781_referenced_by_ParameterReference().isEmpty() ) R781_referenced_by_ParameterReference().setParam_name( m_name );
            if ( !R3904_ActualParameter().isEmpty() ) R3904_ActualParameter().setParam_name( m_name );
        }
    }
    private String ref_next_name;
    @Override
    public String getNext_name() throws XtumlException {
        checkLiving();
        return ref_next_name;
    }
    @Override
    public void setNext_name(String ref_next_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_next_name, this.ref_next_name)) {
            final String oldValue = this.ref_next_name;
            this.ref_next_name = ref_next_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_next_name", oldValue, this.ref_next_name));
        }
    }
    private boolean m_by_ref;
    @Override
    public void setBy_ref(boolean m_by_ref) throws XtumlException {
        checkLiving();
        if (m_by_ref != this.m_by_ref) {
            final boolean oldValue = this.m_by_ref;
            this.m_by_ref = m_by_ref;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_by_ref", oldValue, this.m_by_ref));
        }
    }
    @Override
    public boolean getBy_ref() throws XtumlException {
        checkLiving();
        return m_by_ref;
    }
    private String ref_type_name;
    @Override
    public void setType_name(String ref_type_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_type_name, this.ref_type_name)) {
            final String oldValue = this.ref_type_name;
            this.ref_type_name = ref_type_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_type_name", oldValue, this.ref_type_name));
        }
    }
    @Override
    public String getType_name() throws XtumlException {
        checkLiving();
        return ref_type_name;
    }
    private String ref_type_package;
    @Override
    public void setType_package(String ref_type_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_type_package, this.ref_type_package)) {
            final String oldValue = this.ref_type_package;
            this.ref_type_package = ref_type_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_type_package", oldValue, this.ref_type_package));
        }
    }
    @Override
    public String getType_package() throws XtumlException {
        checkLiving();
        return ref_type_package;
    }
    private String ref_type_reference_name;
    @Override
    public void setType_reference_name(String ref_type_reference_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_type_reference_name, this.ref_type_reference_name)) {
            final String oldValue = this.ref_type_reference_name;
            this.ref_type_reference_name = ref_type_reference_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_type_reference_name", oldValue, this.ref_type_reference_name));
        }
    }
    @Override
    public String getType_reference_name() throws XtumlException {
        checkLiving();
        return ref_type_reference_name;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getParent_name(), getParent_package(), getInvocable_name(), getName());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ActualParameterSet R3904_ActualParameter_set;
    @Override
    public void addR3904_ActualParameter( ActualParameter inst ) {
        R3904_ActualParameter_set.add(inst);
    }
    @Override
    public void removeR3904_ActualParameter( ActualParameter inst ) {
        R3904_ActualParameter_set.remove(inst);
    }
    @Override
    public ActualParameterSet R3904_ActualParameter() throws XtumlException {
        return R3904_ActualParameter_set;
    }
    private FormalParameter R404_follows_FormalParameter_inst;
    @Override
    public void setR404_follows_FormalParameter( FormalParameter inst ) {
        R404_follows_FormalParameter_inst = inst;
    }
    @Override
    public FormalParameter R404_follows_FormalParameter() throws XtumlException {
        return R404_follows_FormalParameter_inst;
    }
    private FormalParameter R404_precedes_FormalParameter_inst;
    @Override
    public void setR404_precedes_FormalParameter( FormalParameter inst ) {
        R404_precedes_FormalParameter_inst = inst;
    }
    @Override
    public FormalParameter R404_precedes_FormalParameter() throws XtumlException {
        return R404_precedes_FormalParameter_inst;
    }
    private InvocableObject R429_shapes_data_for_InvocableObject_inst;
    @Override
    public void setR429_shapes_data_for_InvocableObject( InvocableObject inst ) {
        R429_shapes_data_for_InvocableObject_inst = inst;
    }
    @Override
    public InvocableObject R429_shapes_data_for_InvocableObject() throws XtumlException {
        return R429_shapes_data_for_InvocableObject_inst;
    }
    private TypeReference R431_is_typed_by_TypeReference_inst;
    @Override
    public void setR431_is_typed_by_TypeReference( TypeReference inst ) {
        R431_is_typed_by_TypeReference_inst = inst;
    }
    @Override
    public TypeReference R431_is_typed_by_TypeReference() throws XtumlException {
        return R431_is_typed_by_TypeReference_inst;
    }
    private ParameterReferenceSet R781_referenced_by_ParameterReference_set;
    @Override
    public void addR781_referenced_by_ParameterReference( ParameterReference inst ) {
        R781_referenced_by_ParameterReference_set.add(inst);
    }
    @Override
    public void removeR781_referenced_by_ParameterReference( ParameterReference inst ) {
        R781_referenced_by_ParameterReference_set.remove(inst);
    }
    @Override
    public ParameterReferenceSet R781_referenced_by_ParameterReference() throws XtumlException {
        return R781_referenced_by_ParameterReference_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public FormalParameter self() {
        return this;
    }

    @Override
    public FormalParameter oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_FORMALPARAMETER;
    }

}

class EmptyFormalParameter extends ModelInstance<FormalParameter,Sql> implements FormalParameter {

    // attributes
    public String getParent_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getParent_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setInvocable_name( String ref_invocable_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getInvocable_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getNext_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setNext_name( String ref_next_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setBy_ref( boolean m_by_ref ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getBy_ref() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setType_name( String ref_type_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getType_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setType_package( String ref_type_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getType_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setType_reference_name( String ref_type_reference_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getType_reference_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ActualParameterSet R3904_ActualParameter() {
        return (new ActualParameterSetImpl());
    }
    @Override
    public FormalParameter R404_follows_FormalParameter() {
        return FormalParameterImpl.EMPTY_FORMALPARAMETER;
    }
    @Override
    public FormalParameter R404_precedes_FormalParameter() {
        return FormalParameterImpl.EMPTY_FORMALPARAMETER;
    }
    @Override
    public InvocableObject R429_shapes_data_for_InvocableObject() {
        return InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
    }
    @Override
    public TypeReference R431_is_typed_by_TypeReference() {
        return TypeReferenceImpl.EMPTY_TYPEREFERENCE;
    }
    @Override
    public ParameterReferenceSet R781_referenced_by_ParameterReference() {
        return (new ParameterReferenceSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return FormalParameterImpl.KEY_LETTERS;
    }

    @Override
    public FormalParameter self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public FormalParameter oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return FormalParameterImpl.EMPTY_FORMALPARAMETER;
    }

}
