package io.ciera.tool.sql.architecture.file.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.file.File;
import io.ciera.tool.sql.architecture.file.TypeImport;
import io.ciera.tool.sql.architecture.file.TypeImportReference;
import io.ciera.tool.sql.architecture.file.impl.FileImpl;
import io.ciera.tool.sql.architecture.file.impl.TypeImportImpl;

import types.ImportType;


public class TypeImportReferenceImpl extends ModelInstance<TypeImportReference,Sql> implements TypeImportReference {

    public static final String KEY_LETTERS = "TypeImportReference";
    public static final TypeImportReference EMPTY_TYPEIMPORTREFERENCE = new EmptyTypeImportReference();

    private Sql context;

    // constructors
    private TypeImportReferenceImpl( Sql context ) {
        this.context = context;
        ref_fully_qualified_name = "";
        ref_file_name = "";
        ref_file_package = "";
        m_type = ImportType.UNINITIALIZED_ENUM;
        R402_imports_type_into_context_of_File_inst = FileImpl.EMPTY_FILE;
        R402_imports_type_via_TypeImport_inst = TypeImportImpl.EMPTY_TYPEIMPORT;
    }

    private TypeImportReferenceImpl( Sql context, UniqueId instanceId, String ref_fully_qualified_name, String ref_file_name, String ref_file_package, ImportType m_type ) {
        super(instanceId);
        this.context = context;
        this.ref_fully_qualified_name = ref_fully_qualified_name;
        this.ref_file_name = ref_file_name;
        this.ref_file_package = ref_file_package;
        this.m_type = m_type;
        R402_imports_type_into_context_of_File_inst = FileImpl.EMPTY_FILE;
        R402_imports_type_via_TypeImport_inst = TypeImportImpl.EMPTY_TYPEIMPORT;
    }

    public static TypeImportReference create( Sql context ) throws XtumlException {
        TypeImportReference newTypeImportReference = new TypeImportReferenceImpl( context );
        if ( context.addInstance( newTypeImportReference ) ) {
            newTypeImportReference.getRunContext().addChange(new InstanceCreatedDelta(newTypeImportReference, KEY_LETTERS));
            return newTypeImportReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static TypeImportReference create( Sql context, UniqueId instanceId, String ref_fully_qualified_name, String ref_file_name, String ref_file_package, ImportType m_type ) throws XtumlException {
        TypeImportReference newTypeImportReference = new TypeImportReferenceImpl( context, instanceId, ref_fully_qualified_name, ref_file_name, ref_file_package, m_type );
        if ( context.addInstance( newTypeImportReference ) ) {
            return newTypeImportReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_fully_qualified_name;
    @Override
    public String getFully_qualified_name() throws XtumlException {
        checkLiving();
        return ref_fully_qualified_name;
    }
    @Override
    public void setFully_qualified_name(String ref_fully_qualified_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_fully_qualified_name, this.ref_fully_qualified_name)) {
            final String oldValue = this.ref_fully_qualified_name;
            this.ref_fully_qualified_name = ref_fully_qualified_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_fully_qualified_name", oldValue, this.ref_fully_qualified_name));
        }
    }
    private String ref_file_name;
    @Override
    public void setFile_name(String ref_file_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_file_name, this.ref_file_name)) {
            final String oldValue = this.ref_file_name;
            this.ref_file_name = ref_file_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_file_name", oldValue, this.ref_file_name));
        }
    }
    @Override
    public String getFile_name() throws XtumlException {
        checkLiving();
        return ref_file_name;
    }
    private String ref_file_package;
    @Override
    public String getFile_package() throws XtumlException {
        checkLiving();
        return ref_file_package;
    }
    @Override
    public void setFile_package(String ref_file_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_file_package, this.ref_file_package)) {
            final String oldValue = this.ref_file_package;
            this.ref_file_package = ref_file_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_file_package", oldValue, this.ref_file_package));
        }
    }
    private ImportType m_type;
    @Override
    public ImportType getType() throws XtumlException {
        checkLiving();
        return m_type;
    }
    @Override
    public void setType(ImportType m_type) throws XtumlException {
        checkLiving();
        if (m_type.inequality( this.m_type)) {
            final ImportType oldValue = this.m_type;
            this.m_type = m_type;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_type", oldValue, this.m_type));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getFully_qualified_name(), getFile_name(), getFile_package(), getType());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private File R402_imports_type_into_context_of_File_inst;
    @Override
    public void setR402_imports_type_into_context_of_File( File inst ) {
        R402_imports_type_into_context_of_File_inst = inst;
    }
    @Override
    public File R402_imports_type_into_context_of_File() throws XtumlException {
        return R402_imports_type_into_context_of_File_inst;
    }
    private TypeImport R402_imports_type_via_TypeImport_inst;
    @Override
    public void setR402_imports_type_via_TypeImport( TypeImport inst ) {
        R402_imports_type_via_TypeImport_inst = inst;
    }
    @Override
    public TypeImport R402_imports_type_via_TypeImport() throws XtumlException {
        return R402_imports_type_via_TypeImport_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public TypeImportReference self() {
        return this;
    }

    @Override
    public TypeImportReference oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_TYPEIMPORTREFERENCE;
    }

}

class EmptyTypeImportReference extends ModelInstance<TypeImportReference,Sql> implements TypeImportReference {

    // attributes
    public String getFully_qualified_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setFully_qualified_name( String ref_fully_qualified_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setFile_name( String ref_file_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getFile_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getFile_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setFile_package( String ref_file_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public ImportType getType() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setType( ImportType m_type ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public File R402_imports_type_into_context_of_File() {
        return FileImpl.EMPTY_FILE;
    }
    @Override
    public TypeImport R402_imports_type_via_TypeImport() {
        return TypeImportImpl.EMPTY_TYPEIMPORT;
    }


    @Override
    public String getKeyLetters() {
        return TypeImportReferenceImpl.KEY_LETTERS;
    }

    @Override
    public TypeImportReference self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public TypeImportReference oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return TypeImportReferenceImpl.EMPTY_TYPEIMPORTREFERENCE;
    }

}
