package io.ciera.tool.sql.architecture.file.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.ActionHome;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.file.TypeImport;
import io.ciera.tool.sql.architecture.file.TypeImportReference;
import io.ciera.tool.sql.architecture.file.TypeImportReferenceSet;
import io.ciera.tool.sql.architecture.file.impl.TypeImportImpl;
import io.ciera.tool.sql.architecture.file.impl.TypeImportReferenceSetImpl;


public class TypeImportImpl extends ModelInstance<TypeImport,Sql> implements TypeImport {

    public static final String KEY_LETTERS = "TypeImport";
    public static final TypeImport EMPTY_TYPEIMPORT = new EmptyTypeImport();

    private Sql context;

    // constructors
    private TypeImportImpl( Sql context ) {
        this.context = context;
        m_fully_qualified_name = "";
        R402_imports_type_into_context_of_TypeImportReference_set = new TypeImportReferenceSetImpl();
    }

    private TypeImportImpl( Sql context, UniqueId instanceId, String m_fully_qualified_name ) {
        super(instanceId);
        this.context = context;
        this.m_fully_qualified_name = m_fully_qualified_name;
        R402_imports_type_into_context_of_TypeImportReference_set = new TypeImportReferenceSetImpl();
    }

    public static TypeImport create( Sql context ) throws XtumlException {
        TypeImport newTypeImport = new TypeImportImpl( context );
        if ( context.addInstance( newTypeImport ) ) {
            newTypeImport.getRunContext().addChange(new InstanceCreatedDelta(newTypeImport, KEY_LETTERS));
            return newTypeImport;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static TypeImport create( Sql context, UniqueId instanceId, String m_fully_qualified_name ) throws XtumlException {
        TypeImport newTypeImport = new TypeImportImpl( context, instanceId, m_fully_qualified_name );
        if ( context.addInstance( newTypeImport ) ) {
            return newTypeImport;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String m_fully_qualified_name;
    @Override
    public String getFully_qualified_name() throws XtumlException {
        checkLiving();
        return m_fully_qualified_name;
    }
    @Override
    public void setFully_qualified_name(String m_fully_qualified_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_fully_qualified_name, this.m_fully_qualified_name)) {
            final String oldValue = this.m_fully_qualified_name;
            this.m_fully_qualified_name = m_fully_qualified_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_fully_qualified_name", oldValue, this.m_fully_qualified_name));
            if ( !R402_imports_type_into_context_of_TypeImportReference().isEmpty() ) R402_imports_type_into_context_of_TypeImportReference().setFully_qualified_name( m_fully_qualified_name );
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getFully_qualified_name());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        context().T().include( "file/t.typeimport.java", self() );
    }



    // static operations
    public static class CLASS extends ActionHome<Sql> {

        public CLASS( Sql context ) {
            super( context );
        }

        public TypeImport get_import( final String p_import ) throws XtumlException {
            TypeImport type_import = context().TypeImport_instances().anyWhere(selected -> StringUtil.equality(((TypeImport)selected).getFully_qualified_name(), p_import));
            if ( type_import.isEmpty() ) {
                type_import = TypeImportImpl.create( context() );
                type_import.setFully_qualified_name(p_import);
            }
            return type_import;
        }



    }


    // events


    // selections
    private TypeImportReferenceSet R402_imports_type_into_context_of_TypeImportReference_set;
    @Override
    public void addR402_imports_type_into_context_of_TypeImportReference( TypeImportReference inst ) {
        R402_imports_type_into_context_of_TypeImportReference_set.add(inst);
    }
    @Override
    public void removeR402_imports_type_into_context_of_TypeImportReference( TypeImportReference inst ) {
        R402_imports_type_into_context_of_TypeImportReference_set.remove(inst);
    }
    @Override
    public TypeImportReferenceSet R402_imports_type_into_context_of_TypeImportReference() throws XtumlException {
        return R402_imports_type_into_context_of_TypeImportReference_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public TypeImport self() {
        return this;
    }

    @Override
    public TypeImport oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_TYPEIMPORT;
    }

}

class EmptyTypeImport extends ModelInstance<TypeImport,Sql> implements TypeImport {

    // attributes
    public String getFully_qualified_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setFully_qualified_name( String m_fully_qualified_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public TypeImportReferenceSet R402_imports_type_into_context_of_TypeImportReference() {
        return (new TypeImportReferenceSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return TypeImportImpl.KEY_LETTERS;
    }

    @Override
    public TypeImport self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public TypeImport oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return TypeImportImpl.EMPTY_TYPEIMPORT;
    }

}
