package io.ciera.tool.sql.architecture.component.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.component.ComponentDefinitionSet;
import io.ciera.tool.sql.architecture.component.UtilityReference;
import io.ciera.tool.sql.architecture.component.UtilityReferenceSet;
import io.ciera.tool.sql.architecture.component.UtilitySet;
import io.ciera.tool.sql.architecture.component.impl.ComponentDefinitionSetImpl;
import io.ciera.tool.sql.architecture.component.impl.UtilitySetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class UtilityReferenceSetImpl extends InstanceSet<UtilityReferenceSet,UtilityReference> implements UtilityReferenceSet {

    public UtilityReferenceSetImpl() {
    }

    public UtilityReferenceSetImpl(Comparator<? super UtilityReference> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setComp_package( String ref_comp_package ) throws XtumlException {
        for ( UtilityReference utilityreference : this ) utilityreference.setComp_package( ref_comp_package );
    }
    @Override
    public void setUtility_package( String ref_utility_package ) throws XtumlException {
        for ( UtilityReference utilityreference : this ) utilityreference.setUtility_package( ref_utility_package );
    }
    @Override
    public void setComp_name( String ref_comp_name ) throws XtumlException {
        for ( UtilityReference utilityreference : this ) utilityreference.setComp_name( ref_comp_name );
    }
    @Override
    public void setUtility_name( String ref_utility_name ) throws XtumlException {
        for ( UtilityReference utilityreference : this ) utilityreference.setUtility_name( ref_utility_name );
    }


    // selections
    @Override
    public UtilitySet R4558_contains_Utility() throws XtumlException {
        UtilitySet utilityset = new UtilitySetImpl();
        for ( UtilityReference utilityreference : this ) utilityset.add( utilityreference.R4558_contains_Utility() );
        return utilityset;
    }
    @Override
    public ComponentDefinitionSet R4558_used_within_context_of_ComponentDefinition() throws XtumlException {
        ComponentDefinitionSet componentdefinitionset = new ComponentDefinitionSetImpl();
        for ( UtilityReference utilityreference : this ) componentdefinitionset.add( utilityreference.R4558_used_within_context_of_ComponentDefinition() );
        return componentdefinitionset;
    }


    @Override
    public UtilityReference nullElement() {
        return UtilityReferenceImpl.EMPTY_UTILITYREFERENCE;
    }

    @Override
    public UtilityReferenceSet emptySet() {
      return new UtilityReferenceSetImpl();
    }

    @Override
    public UtilityReferenceSet emptySet(Comparator<? super UtilityReference> comp) {
      return new UtilityReferenceSetImpl(comp);
    }

    @Override
    public List<UtilityReference> elements() {
        return Arrays.asList(toArray(new UtilityReference[0]));
    }

}
