package io.ciera.tool.sql.architecture.component.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.architecture.component.UtilityFunction;
import io.ciera.tool.sql.architecture.component.UtilityFunctionSet;
import io.ciera.tool.sql.architecture.component.UtilitySet;
import io.ciera.tool.sql.architecture.component.impl.UtilitySetImpl;
import io.ciera.tool.sql.architecture.invocable.InvocableObjectSet;
import io.ciera.tool.sql.architecture.invocable.impl.InvocableObjectSetImpl;
import io.ciera.tool.sql.ooaofooa.domain.BridgeSet;
import io.ciera.tool.sql.ooaofooa.domain.impl.BridgeSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class UtilityFunctionSetImpl extends InstanceSet<UtilityFunctionSet,UtilityFunction> implements UtilityFunctionSet {

    public UtilityFunctionSetImpl() {
    }

    public UtilityFunctionSetImpl(Comparator<? super UtilityFunction> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setUtility_package( String ref_utility_package ) throws XtumlException {
        for ( UtilityFunction utilityfunction : this ) utilityfunction.setUtility_package( ref_utility_package );
    }
    @Override
    public void setUtility_name( String ref_utility_name ) throws XtumlException {
        for ( UtilityFunction utilityfunction : this ) utilityfunction.setUtility_name( ref_utility_name );
    }
    @Override
    public void setName( String ref_name ) throws XtumlException {
        for ( UtilityFunction utilityfunction : this ) utilityfunction.setName( ref_name );
    }
    @Override
    public void setBrg_ID( UniqueId ref_Brg_ID ) throws XtumlException {
        for ( UtilityFunction utilityfunction : this ) utilityfunction.setBrg_ID( ref_Brg_ID );
    }


    // selections
    @Override
    public InvocableObjectSet R427_is_a_InvocableObject() throws XtumlException {
        InvocableObjectSet invocableobjectset = new InvocableObjectSetImpl();
        for ( UtilityFunction utilityfunction : this ) invocableobjectset.add( utilityfunction.R427_is_a_InvocableObject() );
        return invocableobjectset;
    }
    @Override
    public UtilitySet R4559_provided_by_Utility() throws XtumlException {
        UtilitySet utilityset = new UtilitySetImpl();
        for ( UtilityFunction utilityfunction : this ) utilityset.add( utilityfunction.R4559_provided_by_Utility() );
        return utilityset;
    }
    @Override
    public BridgeSet R4570_is_basis_for_Bridge() throws XtumlException {
        BridgeSet bridgeset = new BridgeSetImpl();
        for ( UtilityFunction utilityfunction : this ) bridgeset.add( utilityfunction.R4570_is_basis_for_Bridge() );
        return bridgeset;
    }


    @Override
    public UtilityFunction nullElement() {
        return UtilityFunctionImpl.EMPTY_UTILITYFUNCTION;
    }

    @Override
    public UtilityFunctionSet emptySet() {
      return new UtilityFunctionSetImpl();
    }

    @Override
    public UtilityFunctionSet emptySet(Comparator<? super UtilityFunction> comp) {
      return new UtilityFunctionSetImpl(comp);
    }

    @Override
    public List<UtilityFunction> elements() {
        UtilityFunction[] elements = toArray(new UtilityFunction[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
