package io.ciera.tool.sql.architecture.component.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.architecture.application.ComponentInstantiationSet;
import io.ciera.tool.sql.architecture.application.impl.ComponentInstantiationSetImpl;
import io.ciera.tool.sql.architecture.classes.ModelInstSet;
import io.ciera.tool.sql.architecture.classes.impl.ModelInstSetImpl;
import io.ciera.tool.sql.architecture.component.ComponentDefinition;
import io.ciera.tool.sql.architecture.component.ComponentDefinitionSet;
import io.ciera.tool.sql.architecture.component.FunctionSet;
import io.ciera.tool.sql.architecture.component.InstancePopulationSelectorSet;
import io.ciera.tool.sql.architecture.component.RelationshipPopulationSelectorSet;
import io.ciera.tool.sql.architecture.component.UtilityReferenceSet;
import io.ciera.tool.sql.architecture.component.impl.FunctionSetImpl;
import io.ciera.tool.sql.architecture.component.impl.InstancePopulationSelectorSetImpl;
import io.ciera.tool.sql.architecture.component.impl.RelationshipPopulationSelectorSetImpl;
import io.ciera.tool.sql.architecture.component.impl.UtilityReferenceSetImpl;
import io.ciera.tool.sql.architecture.file.FileSet;
import io.ciera.tool.sql.architecture.file.impl.FileSetImpl;
import io.ciera.tool.sql.architecture.interfaces.PortSet;
import io.ciera.tool.sql.architecture.interfaces.impl.PortSetImpl;
import io.ciera.tool.sql.architecture.relationship.ClassRelationshipSet;
import io.ciera.tool.sql.architecture.relationship.impl.ClassRelationshipSetImpl;
import io.ciera.tool.sql.ooaofooa.component.C_CSet;
import io.ciera.tool.sql.ooaofooa.component.impl.C_CSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class ComponentDefinitionSetImpl extends InstanceSet<ComponentDefinitionSet,ComponentDefinition> implements ComponentDefinitionSet {

    public ComponentDefinitionSetImpl() {
    }

    public ComponentDefinitionSetImpl(Comparator<? super ComponentDefinition> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setPackage( String ref_package ) throws XtumlException {
        for ( ComponentDefinition componentdefinition : this ) componentdefinition.setPackage( ref_package );
    }
    @Override
    public void setC_c_Id( UniqueId ref_c_c_Id ) throws XtumlException {
        for ( ComponentDefinition componentdefinition : this ) componentdefinition.setC_c_Id( ref_c_c_Id );
    }
    @Override
    public void setVersion( String m_version ) throws XtumlException {
        for ( ComponentDefinition componentdefinition : this ) componentdefinition.setVersion( m_version );
    }
    @Override
    public void setInit_function_name( String ref_init_function_name ) throws XtumlException {
        for ( ComponentDefinition componentdefinition : this ) componentdefinition.setInit_function_name( ref_init_function_name );
    }
    @Override
    public void setName( String ref_name ) throws XtumlException {
        for ( ComponentDefinition componentdefinition : this ) componentdefinition.setName( ref_name );
    }
    @Override
    public void setExtends( String m_extends ) throws XtumlException {
        for ( ComponentDefinition componentdefinition : this ) componentdefinition.setExtends( m_extends );
    }
    @Override
    public void setVersion_date( String m_version_date ) throws XtumlException {
        for ( ComponentDefinition componentdefinition : this ) componentdefinition.setVersion_date( m_version_date );
    }


    // selections
    @Override
    public FileSet R401_is_a_File() throws XtumlException {
        FileSet fileset = new FileSetImpl();
        for ( ComponentDefinition componentdefinition : this ) fileset.add( componentdefinition.R401_is_a_File() );
        return fileset;
    }
    @Override
    public FunctionSet R405_provides_synchronous_Function() throws XtumlException {
        FunctionSet functionset = new FunctionSetImpl();
        for ( ComponentDefinition componentdefinition : this ) functionset.addAll( componentdefinition.R405_provides_synchronous_Function() );
        return functionset;
    }
    @Override
    public ModelInstSet R408_maintains_instances_of_ModelInst() throws XtumlException {
        ModelInstSet modelinstset = new ModelInstSetImpl();
        for ( ComponentDefinition componentdefinition : this ) modelinstset.addAll( componentdefinition.R408_maintains_instances_of_ModelInst() );
        return modelinstset;
    }
    @Override
    public PortSet R417_communicates_through_Port() throws XtumlException {
        PortSet portset = new PortSetImpl();
        for ( ComponentDefinition componentdefinition : this ) portset.addAll( componentdefinition.R417_communicates_through_Port() );
        return portset;
    }
    @Override
    public ComponentInstantiationSet R426_is_instantiated_by_ComponentInstantiation() throws XtumlException {
        ComponentInstantiationSet componentinstantiationset = new ComponentInstantiationSetImpl();
        for ( ComponentDefinition componentdefinition : this ) componentinstantiationset.addAll( componentdefinition.R426_is_instantiated_by_ComponentInstantiation() );
        return componentinstantiationset;
    }
    @Override
    public InstancePopulationSelectorSet R447_selects_instances_through_InstancePopulationSelector() throws XtumlException {
        InstancePopulationSelectorSet instancepopulationselectorset = new InstancePopulationSelectorSetImpl();
        for ( ComponentDefinition componentdefinition : this ) instancepopulationselectorset.addAll( componentdefinition.R447_selects_instances_through_InstancePopulationSelector() );
        return instancepopulationselectorset;
    }
    @Override
    public ClassRelationshipSet R448_maintains_instances_of_ClassRelationship() throws XtumlException {
        ClassRelationshipSet classrelationshipset = new ClassRelationshipSetImpl();
        for ( ComponentDefinition componentdefinition : this ) classrelationshipset.addAll( componentdefinition.R448_maintains_instances_of_ClassRelationship() );
        return classrelationshipset;
    }
    @Override
    public UtilityReferenceSet R4558_contains_UtilityReference() throws XtumlException {
        UtilityReferenceSet utilityreferenceset = new UtilityReferenceSetImpl();
        for ( ComponentDefinition componentdefinition : this ) utilityreferenceset.addAll( componentdefinition.R4558_contains_UtilityReference() );
        return utilityreferenceset;
    }
    @Override
    public FunctionSet R4561_initialized_by_Function() throws XtumlException {
        FunctionSet functionset = new FunctionSetImpl();
        for ( ComponentDefinition componentdefinition : this ) functionset.add( componentdefinition.R4561_initialized_by_Function() );
        return functionset;
    }
    @Override
    public RelationshipPopulationSelectorSet R4571_selects_relationships_through_RelationshipPopulationSelector() throws XtumlException {
        RelationshipPopulationSelectorSet relationshippopulationselectorset = new RelationshipPopulationSelectorSetImpl();
        for ( ComponentDefinition componentdefinition : this ) relationshippopulationselectorset.addAll( componentdefinition.R4571_selects_relationships_through_RelationshipPopulationSelector() );
        return relationshippopulationselectorset;
    }
    @Override
    public C_CSet R4573_is_transformed_from_C_C() throws XtumlException {
        C_CSet c_cset = new C_CSetImpl();
        for ( ComponentDefinition componentdefinition : this ) c_cset.add( componentdefinition.R4573_is_transformed_from_C_C() );
        return c_cset;
    }


    @Override
    public ComponentDefinition nullElement() {
        return ComponentDefinitionImpl.EMPTY_COMPONENTDEFINITION;
    }

    @Override
    public ComponentDefinitionSet emptySet() {
      return new ComponentDefinitionSetImpl();
    }

    @Override
    public ComponentDefinitionSet emptySet(Comparator<? super ComponentDefinition> comp) {
      return new ComponentDefinitionSetImpl(comp);
    }

    @Override
    public List<ComponentDefinition> elements() {
        ComponentDefinition[] elements = toArray(new ComponentDefinition[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
