package io.ciera.tool.sql.architecture.classes.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.classes.AttributeAccessor;
import io.ciera.tool.sql.architecture.classes.AttributeAccessorSet;
import io.ciera.tool.sql.architecture.classes.AttributeDerivationSet;
import io.ciera.tool.sql.architecture.classes.AttributeSet;
import io.ciera.tool.sql.architecture.classes.impl.AttributeDerivationSetImpl;
import io.ciera.tool.sql.architecture.classes.impl.AttributeSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

import types.AttributeAccessorType;


public class AttributeAccessorSetImpl extends InstanceSet<AttributeAccessorSet,AttributeAccessor> implements AttributeAccessorSet {

    public AttributeAccessorSetImpl() {
    }

    public AttributeAccessorSetImpl(Comparator<? super AttributeAccessor> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setAccessor_type( AttributeAccessorType m_accessor_type ) throws XtumlException {
        for ( AttributeAccessor attributeaccessor : this ) attributeaccessor.setAccessor_type( m_accessor_type );
    }
    @Override
    public void setClass_name( String ref_class_name ) throws XtumlException {
        for ( AttributeAccessor attributeaccessor : this ) attributeaccessor.setClass_name( ref_class_name );
    }
    @Override
    public void setAttribute_name( String ref_attribute_name ) throws XtumlException {
        for ( AttributeAccessor attributeaccessor : this ) attributeaccessor.setAttribute_name( ref_attribute_name );
    }
    @Override
    public void setClass_package( String ref_class_package ) throws XtumlException {
        for ( AttributeAccessor attributeaccessor : this ) attributeaccessor.setClass_package( ref_class_package );
    }


    // selections
    @Override
    public AttributeDerivationSet R441_value_derived_by_AttributeDerivation() throws XtumlException {
        AttributeDerivationSet attributederivationset = new AttributeDerivationSetImpl();
        for ( AttributeAccessor attributeaccessor : this ) attributederivationset.add( attributeaccessor.R441_value_derived_by_AttributeDerivation() );
        return attributederivationset;
    }
    @Override
    public AttributeSet R4510_gets_and_sets_Attribute() throws XtumlException {
        AttributeSet attributeset = new AttributeSetImpl();
        for ( AttributeAccessor attributeaccessor : this ) attributeset.add( attributeaccessor.R4510_gets_and_sets_Attribute() );
        return attributeset;
    }


    @Override
    public AttributeAccessor nullElement() {
        return AttributeAccessorImpl.EMPTY_ATTRIBUTEACCESSOR;
    }

    @Override
    public AttributeAccessorSet emptySet() {
      return new AttributeAccessorSetImpl();
    }

    @Override
    public AttributeAccessorSet emptySet(Comparator<? super AttributeAccessor> comp) {
      return new AttributeAccessorSetImpl(comp);
    }

    @Override
    public List<AttributeAccessor> elements() {
        return Arrays.asList(toArray(new AttributeAccessor[0]));
    }

}
