package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;

import java.util.regex.Matcher;
import java.util.regex.Pattern;


public enum Justification implements IXtumlType {

    UNINITIALIZED_ENUM( -1 ),
    BOTTOM( 0 ),
    CENTER( 1 ),
    CENTER_IN_X( 2 ),
    FLOATING( 3 ),
    LEFT( 4 ),
    RIGHT( 5 );

    private final int value;

    Justification() {
        value = -1;
    }

    Justification( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( IXtumlType value ) throws XtumlException {
        if (value instanceof Justification) {
            return null != value && this.value == ((Justification)value).getValue();
        }
        else return false;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static Justification deserialize(Object o) throws XtumlException {
        if (o instanceof Justification) {
            return (Justification)o;
        }
        else if (o instanceof Integer) {
            return valueOf((int)o);
        }
        else if (o instanceof String) {
            try {
                return valueOf(Integer.parseInt((String)o));
            }
            catch (NumberFormatException e1) {
                Matcher m = Pattern.compile("([A-Za-z_]+)::([A-Za-z_]+)").matcher((String)o);
                if (m.matches() && "justification".equals(m.group(1).toLowerCase())) {
                    try {
                        return Enum.valueOf(Justification.class, m.group(2).toUpperCase());
                    } catch (IllegalArgumentException e2) {/* do nothing */}
                }
            }
        }
        throw new XtumlException("Cannot deserialize value");
    }

    public static Justification valueOf(int value) {
        switch( value ) {
        case 0:
            return BOTTOM;
        case 1:
            return CENTER;
        case 2:
            return CENTER_IN_X;
        case 3:
            return FLOATING;
        case 4:
            return LEFT;
        case 5:
            return RIGHT;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
