package ooaofooa.datatypes;


import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IXtumlType;

import java.util.regex.Matcher;
import java.util.regex.Pattern;


public enum EventProcessType implements IXtumlType {

    UNINITIALIZED_ENUM( -1 ),
    CANTHAPPEN( 0 ),
    DEQUEUED( 1 ),
    ENQUEUED( 2 ),
    IGNORED( 3 );

    private final int value;

    EventProcessType() {
        value = -1;
    }

    EventProcessType( int value ) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public boolean equality( IXtumlType value ) throws XtumlException {
        if (value instanceof EventProcessType) {
            return null != value && this.value == ((EventProcessType)value).getValue();
        }
        else return false;
    }

    @Override
    public String serialize() {
        return Integer.toString(value);
    }

    public static EventProcessType deserialize(Object o) throws XtumlException {
        if (o instanceof EventProcessType) {
            return (EventProcessType)o;
        }
        else if (o instanceof Integer) {
            return valueOf((int)o);
        }
        else if (o instanceof String) {
            try {
                return valueOf(Integer.parseInt((String)o));
            }
            catch (NumberFormatException e1) {
                Matcher m = Pattern.compile("([A-Za-z_]+)::([A-Za-z_]+)").matcher((String)o);
                if (m.matches() && "eventprocesstype".equals(m.group(1).toLowerCase())) {
                    try {
                        return Enum.valueOf(EventProcessType.class, m.group(2).toUpperCase());
                    } catch (IllegalArgumentException e2) {/* do nothing */}
                }
            }
        }
        throw new XtumlException("Cannot deserialize value");
    }

    public static EventProcessType valueOf(int value) {
        switch( value ) {
        case 0:
            return CANTHAPPEN;
        case 1:
            return DEQUEUED;
        case 2:
            return ENQUEUED;
        case 3:
            return IGNORED;
        default:
            return UNINITIALIZED_ENUM;
        }
    }

}
