package io.ciera.tool.sql.ooaofooa.value.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.subsystem.ModelClass;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.ModelClassImpl;
import io.ciera.tool.sql.ooaofooa.value.V_INS;
import io.ciera.tool.sql.ooaofooa.value.V_VAR;
import io.ciera.tool.sql.ooaofooa.value.impl.V_VARImpl;


public class V_INSImpl extends ModelInstance<V_INS,Sql> implements V_INS {

    public static final String KEY_LETTERS = "V_INS";
    public static final V_INS EMPTY_V_INS = new EmptyV_INS();

    private Sql context;

    // constructors
    private V_INSImpl( Sql context ) {
        this.context = context;
        ref_Var_ID = UniqueId.random();
        ref_Obj_ID = UniqueId.random();
        R814_is_a_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
        R819_refers_to_ModelClass_inst = ModelClassImpl.EMPTY_MODELCLASS;
    }

    private V_INSImpl( Sql context, UniqueId instanceId, UniqueId ref_Var_ID, UniqueId ref_Obj_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Var_ID = ref_Var_ID;
        this.ref_Obj_ID = ref_Obj_ID;
        R814_is_a_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
        R819_refers_to_ModelClass_inst = ModelClassImpl.EMPTY_MODELCLASS;
    }

    public static V_INS create( Sql context ) throws XtumlException {
        V_INS newV_INS = new V_INSImpl( context );
        if ( context.addInstance( newV_INS ) ) {
            newV_INS.getRunContext().addChange(new InstanceCreatedDelta(newV_INS, KEY_LETTERS));
            return newV_INS;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static V_INS create( Sql context, UniqueId instanceId, UniqueId ref_Var_ID, UniqueId ref_Obj_ID ) throws XtumlException {
        V_INS newV_INS = new V_INSImpl( context, instanceId, ref_Var_ID, ref_Obj_ID );
        if ( context.addInstance( newV_INS ) ) {
            return newV_INS;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Var_ID;
    @Override
    public UniqueId getVar_ID() throws XtumlException {
        checkLiving();
        return ref_Var_ID;
    }
    @Override
    public void setVar_ID(UniqueId ref_Var_ID) throws XtumlException {
        checkLiving();
        if (ref_Var_ID.inequality( this.ref_Var_ID)) {
            final UniqueId oldValue = this.ref_Var_ID;
            this.ref_Var_ID = ref_Var_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Var_ID", oldValue, this.ref_Var_ID));
        }
    }
    private UniqueId ref_Obj_ID;
    @Override
    public void setObj_ID(UniqueId ref_Obj_ID) throws XtumlException {
        checkLiving();
        if (ref_Obj_ID.inequality( this.ref_Obj_ID)) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
        }
    }
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
        return ref_Obj_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getVar_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private V_VAR R814_is_a_V_VAR_inst;
    @Override
    public void setR814_is_a_V_VAR( V_VAR inst ) {
        R814_is_a_V_VAR_inst = inst;
    }
    @Override
    public V_VAR R814_is_a_V_VAR() throws XtumlException {
        return R814_is_a_V_VAR_inst;
    }
    private ModelClass R819_refers_to_ModelClass_inst;
    @Override
    public void setR819_refers_to_ModelClass( ModelClass inst ) {
        R819_refers_to_ModelClass_inst = inst;
    }
    @Override
    public ModelClass R819_refers_to_ModelClass() throws XtumlException {
        return R819_refers_to_ModelClass_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public V_INS self() {
        return this;
    }

    @Override
    public V_INS oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_V_INS;
    }

}

class EmptyV_INS extends ModelInstance<V_INS,Sql> implements V_INS {

    // attributes
    public UniqueId getVar_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setVar_ID( UniqueId ref_Var_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public V_VAR R814_is_a_V_VAR() {
        return V_VARImpl.EMPTY_V_VAR;
    }
    @Override
    public ModelClass R819_refers_to_ModelClass() {
        return ModelClassImpl.EMPTY_MODELCLASS;
    }


    @Override
    public String getKeyLetters() {
        return V_INSImpl.KEY_LETTERS;
    }

    @Override
    public V_INS self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public V_INS oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return V_INSImpl.EMPTY_V_INS;
    }

}
