package io.ciera.tool.sql.ooaofooa.value.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.PropertyParameter;
import io.ciera.tool.sql.ooaofooa.component.impl.PropertyParameterImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.StateMachineEventDataItem;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.StateMachineEventDataItemImpl;
import io.ciera.tool.sql.ooaofooa.value.EventDatumValue;
import io.ciera.tool.sql.ooaofooa.value.EventParameterReference;
import io.ciera.tool.sql.ooaofooa.value.impl.EventDatumValueImpl;


public class EventParameterReferenceImpl extends ModelInstance<EventParameterReference,Sql> implements EventParameterReference {

    public static final String KEY_LETTERS = "V_EPR";
    public static final EventParameterReference EMPTY_EVENTPARAMETERREFERENCE = new EmptyEventParameterReference();

    private Sql context;

    // constructors
    private EventParameterReferenceImpl( Sql context ) {
        this.context = context;
        ref_Value_ID = UniqueId.random();
        ref_SM_ID = UniqueId.random();
        ref_SMedi_ID = UniqueId.random();
        ref_PP_Id = UniqueId.random();
        R834_EventDatumValue_inst = EventDatumValueImpl.EMPTY_EVENTDATUMVALUE;
        R846_StateMachineEventDataItem_inst = StateMachineEventDataItemImpl.EMPTY_STATEMACHINEEVENTDATAITEM;
        R847_PropertyParameter_inst = PropertyParameterImpl.EMPTY_PROPERTYPARAMETER;
    }

    private EventParameterReferenceImpl( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_SM_ID, UniqueId ref_SMedi_ID, UniqueId ref_PP_Id ) {
        super(instanceId);
        this.context = context;
        this.ref_Value_ID = ref_Value_ID;
        this.ref_SM_ID = ref_SM_ID;
        this.ref_SMedi_ID = ref_SMedi_ID;
        this.ref_PP_Id = ref_PP_Id;
        R834_EventDatumValue_inst = EventDatumValueImpl.EMPTY_EVENTDATUMVALUE;
        R846_StateMachineEventDataItem_inst = StateMachineEventDataItemImpl.EMPTY_STATEMACHINEEVENTDATAITEM;
        R847_PropertyParameter_inst = PropertyParameterImpl.EMPTY_PROPERTYPARAMETER;
    }

    public static EventParameterReference create( Sql context ) throws XtumlException {
        EventParameterReference newEventParameterReference = new EventParameterReferenceImpl( context );
        if ( context.addInstance( newEventParameterReference ) ) {
            newEventParameterReference.getRunContext().addChange(new InstanceCreatedDelta(newEventParameterReference, KEY_LETTERS));
            return newEventParameterReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static EventParameterReference create( Sql context, UniqueId instanceId, UniqueId ref_Value_ID, UniqueId ref_SM_ID, UniqueId ref_SMedi_ID, UniqueId ref_PP_Id ) throws XtumlException {
        EventParameterReference newEventParameterReference = new EventParameterReferenceImpl( context, instanceId, ref_Value_ID, ref_SM_ID, ref_SMedi_ID, ref_PP_Id );
        if ( context.addInstance( newEventParameterReference ) ) {
            return newEventParameterReference;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Value_ID;
    @Override
    public void setValue_ID(UniqueId ref_Value_ID) throws XtumlException {
        checkLiving();
        if (ref_Value_ID.inequality( this.ref_Value_ID)) {
            final UniqueId oldValue = this.ref_Value_ID;
            this.ref_Value_ID = ref_Value_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Value_ID", oldValue, this.ref_Value_ID));
        }
    }
    @Override
    public UniqueId getValue_ID() throws XtumlException {
        checkLiving();
        return ref_Value_ID;
    }
    private UniqueId ref_SM_ID;
    @Override
    public void setSM_ID(UniqueId ref_SM_ID) throws XtumlException {
        checkLiving();
        if (ref_SM_ID.inequality( this.ref_SM_ID)) {
            final UniqueId oldValue = this.ref_SM_ID;
            this.ref_SM_ID = ref_SM_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SM_ID", oldValue, this.ref_SM_ID));
        }
    }
    @Override
    public UniqueId getSM_ID() throws XtumlException {
        checkLiving();
        return ref_SM_ID;
    }
    private UniqueId ref_SMedi_ID;
    @Override
    public UniqueId getSMedi_ID() throws XtumlException {
        checkLiving();
        return ref_SMedi_ID;
    }
    @Override
    public void setSMedi_ID(UniqueId ref_SMedi_ID) throws XtumlException {
        checkLiving();
        if (ref_SMedi_ID.inequality( this.ref_SMedi_ID)) {
            final UniqueId oldValue = this.ref_SMedi_ID;
            this.ref_SMedi_ID = ref_SMedi_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SMedi_ID", oldValue, this.ref_SMedi_ID));
        }
    }
    private UniqueId ref_PP_Id;
    @Override
    public UniqueId getPP_Id() throws XtumlException {
        checkLiving();
        return ref_PP_Id;
    }
    @Override
    public void setPP_Id(UniqueId ref_PP_Id) throws XtumlException {
        checkLiving();
        if (ref_PP_Id.inequality( this.ref_PP_Id)) {
            final UniqueId oldValue = this.ref_PP_Id;
            this.ref_PP_Id = ref_PP_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_PP_Id", oldValue, this.ref_PP_Id));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getValue_ID(), getSM_ID(), getSMedi_ID(), getPP_Id());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private EventDatumValue R834_EventDatumValue_inst;
    @Override
    public void setR834_EventDatumValue( EventDatumValue inst ) {
        R834_EventDatumValue_inst = inst;
    }
    @Override
    public EventDatumValue R834_EventDatumValue() throws XtumlException {
        return R834_EventDatumValue_inst;
    }
    private StateMachineEventDataItem R846_StateMachineEventDataItem_inst;
    @Override
    public void setR846_StateMachineEventDataItem( StateMachineEventDataItem inst ) {
        R846_StateMachineEventDataItem_inst = inst;
    }
    @Override
    public StateMachineEventDataItem R846_StateMachineEventDataItem() throws XtumlException {
        return R846_StateMachineEventDataItem_inst;
    }
    private PropertyParameter R847_PropertyParameter_inst;
    @Override
    public void setR847_PropertyParameter( PropertyParameter inst ) {
        R847_PropertyParameter_inst = inst;
    }
    @Override
    public PropertyParameter R847_PropertyParameter() throws XtumlException {
        return R847_PropertyParameter_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public EventParameterReference self() {
        return this;
    }

    @Override
    public EventParameterReference oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_EVENTPARAMETERREFERENCE;
    }

}

class EmptyEventParameterReference extends ModelInstance<EventParameterReference,Sql> implements EventParameterReference {

    // attributes
    public void setValue_ID( UniqueId ref_Value_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getValue_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSM_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getSMedi_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSMedi_ID( UniqueId ref_SMedi_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getPP_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPP_Id( UniqueId ref_PP_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public EventDatumValue R834_EventDatumValue() {
        return EventDatumValueImpl.EMPTY_EVENTDATUMVALUE;
    }
    @Override
    public StateMachineEventDataItem R846_StateMachineEventDataItem() {
        return StateMachineEventDataItemImpl.EMPTY_STATEMACHINEEVENTDATAITEM;
    }
    @Override
    public PropertyParameter R847_PropertyParameter() {
        return PropertyParameterImpl.EMPTY_PROPERTYPARAMETER;
    }


    @Override
    public String getKeyLetters() {
        return EventParameterReferenceImpl.KEY_LETTERS;
    }

    @Override
    public EventParameterReference self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public EventParameterReference oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return EventParameterReferenceImpl.EMPTY_EVENTPARAMETERREFERENCE;
    }

}
