package io.ciera.tool.sql.ooaofooa.usecase.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.interaction.InteractionParticipant;
import io.ciera.tool.sql.ooaofooa.interaction.impl.InteractionParticipantImpl;
import io.ciera.tool.sql.ooaofooa.packageableelement.PackageableElement;
import io.ciera.tool.sql.ooaofooa.packageableelement.impl.PackageableElementImpl;
import io.ciera.tool.sql.ooaofooa.usecase.BinaryAssociation;
import io.ciera.tool.sql.ooaofooa.usecase.Extend;
import io.ciera.tool.sql.ooaofooa.usecase.Generalization;
import io.ciera.tool.sql.ooaofooa.usecase.Include;
import io.ciera.tool.sql.ooaofooa.usecase.UseCaseAssociation;
import io.ciera.tool.sql.ooaofooa.usecase.impl.BinaryAssociationImpl;
import io.ciera.tool.sql.ooaofooa.usecase.impl.ExtendImpl;
import io.ciera.tool.sql.ooaofooa.usecase.impl.GeneralizationImpl;
import io.ciera.tool.sql.ooaofooa.usecase.impl.IncludeImpl;


public class UseCaseAssociationImpl extends ModelInstance<UseCaseAssociation,Sql> implements UseCaseAssociation {

    public static final String KEY_LETTERS = "UC_UCA";
    public static final UseCaseAssociation EMPTY_USECASEASSOCIATION = new EmptyUseCaseAssociation();

    private Sql context;

    // constructors
    private UseCaseAssociationImpl( Sql context ) {
        this.context = context;
        ref_Assoc_ID = UniqueId.random();
        ref_Source_Part_ID = UniqueId.random();
        ref_Destination_Part_ID = UniqueId.random();
        R1206_starts_at_InteractionParticipant_inst = InteractionParticipantImpl.EMPTY_INTERACTIONPARTICIPANT;
        R1207_ends_at_InteractionParticipant_inst = InteractionParticipantImpl.EMPTY_INTERACTIONPARTICIPANT;
        R1210_is_a_BinaryAssociation_inst = BinaryAssociationImpl.EMPTY_BINARYASSOCIATION;
        R1210_is_a_Extend_inst = ExtendImpl.EMPTY_EXTEND;
        R1210_is_a_Generalization_inst = GeneralizationImpl.EMPTY_GENERALIZATION;
        R1210_is_a_Include_inst = IncludeImpl.EMPTY_INCLUDE;
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }

    private UseCaseAssociationImpl( Sql context, UniqueId instanceId, UniqueId ref_Assoc_ID, UniqueId ref_Source_Part_ID, UniqueId ref_Destination_Part_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Assoc_ID = ref_Assoc_ID;
        this.ref_Source_Part_ID = ref_Source_Part_ID;
        this.ref_Destination_Part_ID = ref_Destination_Part_ID;
        R1206_starts_at_InteractionParticipant_inst = InteractionParticipantImpl.EMPTY_INTERACTIONPARTICIPANT;
        R1207_ends_at_InteractionParticipant_inst = InteractionParticipantImpl.EMPTY_INTERACTIONPARTICIPANT;
        R1210_is_a_BinaryAssociation_inst = BinaryAssociationImpl.EMPTY_BINARYASSOCIATION;
        R1210_is_a_Extend_inst = ExtendImpl.EMPTY_EXTEND;
        R1210_is_a_Generalization_inst = GeneralizationImpl.EMPTY_GENERALIZATION;
        R1210_is_a_Include_inst = IncludeImpl.EMPTY_INCLUDE;
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }

    public static UseCaseAssociation create( Sql context ) throws XtumlException {
        UseCaseAssociation newUseCaseAssociation = new UseCaseAssociationImpl( context );
        if ( context.addInstance( newUseCaseAssociation ) ) {
            newUseCaseAssociation.getRunContext().addChange(new InstanceCreatedDelta(newUseCaseAssociation, KEY_LETTERS));
            return newUseCaseAssociation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static UseCaseAssociation create( Sql context, UniqueId instanceId, UniqueId ref_Assoc_ID, UniqueId ref_Source_Part_ID, UniqueId ref_Destination_Part_ID ) throws XtumlException {
        UseCaseAssociation newUseCaseAssociation = new UseCaseAssociationImpl( context, instanceId, ref_Assoc_ID, ref_Source_Part_ID, ref_Destination_Part_ID );
        if ( context.addInstance( newUseCaseAssociation ) ) {
            return newUseCaseAssociation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Assoc_ID;
    @Override
    public UniqueId getAssoc_ID() throws XtumlException {
        checkLiving();
        return ref_Assoc_ID;
    }
    @Override
    public void setAssoc_ID(UniqueId ref_Assoc_ID) throws XtumlException {
        checkLiving();
        if (ref_Assoc_ID.inequality( this.ref_Assoc_ID)) {
            final UniqueId oldValue = this.ref_Assoc_ID;
            this.ref_Assoc_ID = ref_Assoc_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Assoc_ID", oldValue, this.ref_Assoc_ID));
            if ( !R1210_is_a_BinaryAssociation().isEmpty() ) R1210_is_a_BinaryAssociation().setAssoc_ID( ref_Assoc_ID );
            if ( !R1210_is_a_Include().isEmpty() ) R1210_is_a_Include().setAssoc_ID( ref_Assoc_ID );
            if ( !R1210_is_a_Generalization().isEmpty() ) R1210_is_a_Generalization().setAssoc_ID( ref_Assoc_ID );
            if ( !R1210_is_a_Extend().isEmpty() ) R1210_is_a_Extend().setAssoc_ID( ref_Assoc_ID );
        }
    }
    private UniqueId ref_Source_Part_ID;
    @Override
    public UniqueId getSource_Part_ID() throws XtumlException {
        checkLiving();
        return ref_Source_Part_ID;
    }
    @Override
    public void setSource_Part_ID(UniqueId ref_Source_Part_ID) throws XtumlException {
        checkLiving();
        if (ref_Source_Part_ID.inequality( this.ref_Source_Part_ID)) {
            final UniqueId oldValue = this.ref_Source_Part_ID;
            this.ref_Source_Part_ID = ref_Source_Part_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Source_Part_ID", oldValue, this.ref_Source_Part_ID));
        }
    }
    private UniqueId ref_Destination_Part_ID;
    @Override
    public void setDestination_Part_ID(UniqueId ref_Destination_Part_ID) throws XtumlException {
        checkLiving();
        if (ref_Destination_Part_ID.inequality( this.ref_Destination_Part_ID)) {
            final UniqueId oldValue = this.ref_Destination_Part_ID;
            this.ref_Destination_Part_ID = ref_Destination_Part_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Destination_Part_ID", oldValue, this.ref_Destination_Part_ID));
        }
    }
    @Override
    public UniqueId getDestination_Part_ID() throws XtumlException {
        checkLiving();
        return ref_Destination_Part_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getAssoc_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private InteractionParticipant R1206_starts_at_InteractionParticipant_inst;
    @Override
    public void setR1206_starts_at_InteractionParticipant( InteractionParticipant inst ) {
        R1206_starts_at_InteractionParticipant_inst = inst;
    }
    @Override
    public InteractionParticipant R1206_starts_at_InteractionParticipant() throws XtumlException {
        return R1206_starts_at_InteractionParticipant_inst;
    }
    private InteractionParticipant R1207_ends_at_InteractionParticipant_inst;
    @Override
    public void setR1207_ends_at_InteractionParticipant( InteractionParticipant inst ) {
        R1207_ends_at_InteractionParticipant_inst = inst;
    }
    @Override
    public InteractionParticipant R1207_ends_at_InteractionParticipant() throws XtumlException {
        return R1207_ends_at_InteractionParticipant_inst;
    }
    private BinaryAssociation R1210_is_a_BinaryAssociation_inst;
    @Override
    public void setR1210_is_a_BinaryAssociation( BinaryAssociation inst ) {
        R1210_is_a_BinaryAssociation_inst = inst;
    }
    @Override
    public BinaryAssociation R1210_is_a_BinaryAssociation() throws XtumlException {
        return R1210_is_a_BinaryAssociation_inst;
    }
    private Extend R1210_is_a_Extend_inst;
    @Override
    public void setR1210_is_a_Extend( Extend inst ) {
        R1210_is_a_Extend_inst = inst;
    }
    @Override
    public Extend R1210_is_a_Extend() throws XtumlException {
        return R1210_is_a_Extend_inst;
    }
    private Generalization R1210_is_a_Generalization_inst;
    @Override
    public void setR1210_is_a_Generalization( Generalization inst ) {
        R1210_is_a_Generalization_inst = inst;
    }
    @Override
    public Generalization R1210_is_a_Generalization() throws XtumlException {
        return R1210_is_a_Generalization_inst;
    }
    private Include R1210_is_a_Include_inst;
    @Override
    public void setR1210_is_a_Include( Include inst ) {
        R1210_is_a_Include_inst = inst;
    }
    @Override
    public Include R1210_is_a_Include() throws XtumlException {
        return R1210_is_a_Include_inst;
    }
    private PackageableElement R8001_is_a_PackageableElement_inst;
    @Override
    public void setR8001_is_a_PackageableElement( PackageableElement inst ) {
        R8001_is_a_PackageableElement_inst = inst;
    }
    @Override
    public PackageableElement R8001_is_a_PackageableElement() throws XtumlException {
        return R8001_is_a_PackageableElement_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public UseCaseAssociation self() {
        return this;
    }

    @Override
    public UseCaseAssociation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_USECASEASSOCIATION;
    }

}

class EmptyUseCaseAssociation extends ModelInstance<UseCaseAssociation,Sql> implements UseCaseAssociation {

    // attributes
    public UniqueId getAssoc_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAssoc_ID( UniqueId ref_Assoc_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSource_Part_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSource_Part_ID( UniqueId ref_Source_Part_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setDestination_Part_ID( UniqueId ref_Destination_Part_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getDestination_Part_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public InteractionParticipant R1206_starts_at_InteractionParticipant() {
        return InteractionParticipantImpl.EMPTY_INTERACTIONPARTICIPANT;
    }
    @Override
    public InteractionParticipant R1207_ends_at_InteractionParticipant() {
        return InteractionParticipantImpl.EMPTY_INTERACTIONPARTICIPANT;
    }
    @Override
    public BinaryAssociation R1210_is_a_BinaryAssociation() {
        return BinaryAssociationImpl.EMPTY_BINARYASSOCIATION;
    }
    @Override
    public Extend R1210_is_a_Extend() {
        return ExtendImpl.EMPTY_EXTEND;
    }
    @Override
    public Generalization R1210_is_a_Generalization() {
        return GeneralizationImpl.EMPTY_GENERALIZATION;
    }
    @Override
    public Include R1210_is_a_Include() {
        return IncludeImpl.EMPTY_INCLUDE;
    }
    @Override
    public PackageableElement R8001_is_a_PackageableElement() {
        return PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }


    @Override
    public String getKeyLetters() {
        return UseCaseAssociationImpl.KEY_LETTERS;
    }

    @Override
    public UseCaseAssociation self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public UseCaseAssociation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return UseCaseAssociationImpl.EMPTY_USECASEASSOCIATION;
    }

}
