package io.ciera.tool.sql.ooaofooa.usecase.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.usecase.BinaryAssociation;
import io.ciera.tool.sql.ooaofooa.usecase.UseCaseAssociation;
import io.ciera.tool.sql.ooaofooa.usecase.impl.UseCaseAssociationImpl;


public class BinaryAssociationImpl extends ModelInstance<BinaryAssociation,Sql> implements BinaryAssociation {

    public static final String KEY_LETTERS = "UC_BA";
    public static final BinaryAssociation EMPTY_BINARYASSOCIATION = new EmptyBinaryAssociation();

    private Sql context;

    // constructors
    private BinaryAssociationImpl( Sql context ) {
        this.context = context;
        ref_Assoc_ID = UniqueId.random();
        m_Descrip = "";
        R1210_is_a_UseCaseAssociation_inst = UseCaseAssociationImpl.EMPTY_USECASEASSOCIATION;
    }

    private BinaryAssociationImpl( Sql context, UniqueId instanceId, UniqueId ref_Assoc_ID, String m_Descrip ) {
        super(instanceId);
        this.context = context;
        this.ref_Assoc_ID = ref_Assoc_ID;
        this.m_Descrip = m_Descrip;
        R1210_is_a_UseCaseAssociation_inst = UseCaseAssociationImpl.EMPTY_USECASEASSOCIATION;
    }

    public static BinaryAssociation create( Sql context ) throws XtumlException {
        BinaryAssociation newBinaryAssociation = new BinaryAssociationImpl( context );
        if ( context.addInstance( newBinaryAssociation ) ) {
            newBinaryAssociation.getRunContext().addChange(new InstanceCreatedDelta(newBinaryAssociation, KEY_LETTERS));
            return newBinaryAssociation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static BinaryAssociation create( Sql context, UniqueId instanceId, UniqueId ref_Assoc_ID, String m_Descrip ) throws XtumlException {
        BinaryAssociation newBinaryAssociation = new BinaryAssociationImpl( context, instanceId, ref_Assoc_ID, m_Descrip );
        if ( context.addInstance( newBinaryAssociation ) ) {
            return newBinaryAssociation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Assoc_ID;
    @Override
    public UniqueId getAssoc_ID() throws XtumlException {
        checkLiving();
        return ref_Assoc_ID;
    }
    @Override
    public void setAssoc_ID(UniqueId ref_Assoc_ID) throws XtumlException {
        checkLiving();
        if (ref_Assoc_ID.inequality( this.ref_Assoc_ID)) {
            final UniqueId oldValue = this.ref_Assoc_ID;
            this.ref_Assoc_ID = ref_Assoc_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Assoc_ID", oldValue, this.ref_Assoc_ID));
        }
    }
    private String m_Descrip;
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getAssoc_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private UseCaseAssociation R1210_is_a_UseCaseAssociation_inst;
    @Override
    public void setR1210_is_a_UseCaseAssociation( UseCaseAssociation inst ) {
        R1210_is_a_UseCaseAssociation_inst = inst;
    }
    @Override
    public UseCaseAssociation R1210_is_a_UseCaseAssociation() throws XtumlException {
        return R1210_is_a_UseCaseAssociation_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public BinaryAssociation self() {
        return this;
    }

    @Override
    public BinaryAssociation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_BINARYASSOCIATION;
    }

}

class EmptyBinaryAssociation extends ModelInstance<BinaryAssociation,Sql> implements BinaryAssociation {

    // attributes
    public UniqueId getAssoc_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAssoc_ID( UniqueId ref_Assoc_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public UseCaseAssociation R1210_is_a_UseCaseAssociation() {
        return UseCaseAssociationImpl.EMPTY_USECASEASSOCIATION;
    }


    @Override
    public String getKeyLetters() {
        return BinaryAssociationImpl.KEY_LETTERS;
    }

    @Override
    public BinaryAssociation self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public BinaryAssociation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return BinaryAssociationImpl.EMPTY_BINARYASSOCIATION;
    }

}
