package io.ciera.tool.sql.ooaofooa.subsystem.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.classes.ModelInst;
import io.ciera.tool.sql.architecture.classes.impl.ModelInstImpl;
import io.ciera.tool.sql.ooaofooa.association.ClassInAssociation;
import io.ciera.tool.sql.ooaofooa.association.ClassInAssociationSet;
import io.ciera.tool.sql.ooaofooa.association.impl.ClassInAssociationSetImpl;
import io.ciera.tool.sql.ooaofooa.body.ForStmt;
import io.ciera.tool.sql.ooaofooa.body.ForStmtSet;
import io.ciera.tool.sql.ooaofooa.body.impl.ForStmtSetImpl;
import io.ciera.tool.sql.ooaofooa.domain.InstanceReferenceDataType;
import io.ciera.tool.sql.ooaofooa.domain.InstanceReferenceDataTypeSet;
import io.ciera.tool.sql.ooaofooa.domain.impl.InstanceReferenceDataTypeSetImpl;
import io.ciera.tool.sql.ooaofooa.instanceaccess.Create;
import io.ciera.tool.sql.ooaofooa.instanceaccess.CreateNoVariable;
import io.ciera.tool.sql.ooaofooa.instanceaccess.CreateNoVariableSet;
import io.ciera.tool.sql.ooaofooa.instanceaccess.CreateSet;
import io.ciera.tool.sql.ooaofooa.instanceaccess.impl.CreateNoVariableSetImpl;
import io.ciera.tool.sql.ooaofooa.instanceaccess.impl.CreateSetImpl;
import io.ciera.tool.sql.ooaofooa.interaction.ClassInstanceParticipant;
import io.ciera.tool.sql.ooaofooa.interaction.ClassInstanceParticipantSet;
import io.ciera.tool.sql.ooaofooa.interaction.ClassParticipant;
import io.ciera.tool.sql.ooaofooa.interaction.ClassParticipantSet;
import io.ciera.tool.sql.ooaofooa.interaction.impl.ClassInstanceParticipantSetImpl;
import io.ciera.tool.sql.ooaofooa.interaction.impl.ClassParticipantSetImpl;
import io.ciera.tool.sql.ooaofooa.packageableelement.PackageableElement;
import io.ciera.tool.sql.ooaofooa.packageableelement.impl.PackageableElementImpl;
import io.ciera.tool.sql.ooaofooa.selection.ACT_FIO;
import io.ciera.tool.sql.ooaofooa.selection.ACT_FIOSet;
import io.ciera.tool.sql.ooaofooa.selection.ChainLink;
import io.ciera.tool.sql.ooaofooa.selection.ChainLinkSet;
import io.ciera.tool.sql.ooaofooa.selection.SelectFromInstancesWhere;
import io.ciera.tool.sql.ooaofooa.selection.SelectFromInstancesWhereSet;
import io.ciera.tool.sql.ooaofooa.selection.impl.ACT_FIOSetImpl;
import io.ciera.tool.sql.ooaofooa.selection.impl.ChainLinkSetImpl;
import io.ciera.tool.sql.ooaofooa.selection.impl.SelectFromInstancesWhereSetImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.ClassStateMachine;
import io.ciera.tool.sql.ooaofooa.statemachine.InstanceStateMachine;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.ClassStateMachineImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.InstanceStateMachineImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.ClassIdentifier;
import io.ciera.tool.sql.ooaofooa.subsystem.ClassIdentifierSet;
import io.ciera.tool.sql.ooaofooa.subsystem.ImportedClass;
import io.ciera.tool.sql.ooaofooa.subsystem.ImportedClassSet;
import io.ciera.tool.sql.ooaofooa.subsystem.ModelClass;
import io.ciera.tool.sql.ooaofooa.subsystem.O_ATTR;
import io.ciera.tool.sql.ooaofooa.subsystem.O_ATTRSet;
import io.ciera.tool.sql.ooaofooa.subsystem.O_TFR;
import io.ciera.tool.sql.ooaofooa.subsystem.O_TFRSet;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.ClassIdentifierSetImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.ImportedClassSetImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.O_ATTRSetImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.O_TFRSetImpl;
import io.ciera.tool.sql.ooaofooa.value.InstanceHandle;
import io.ciera.tool.sql.ooaofooa.value.InstanceHandleSet;
import io.ciera.tool.sql.ooaofooa.value.V_INS;
import io.ciera.tool.sql.ooaofooa.value.V_INSSet;
import io.ciera.tool.sql.ooaofooa.value.impl.InstanceHandleSetImpl;
import io.ciera.tool.sql.ooaofooa.value.impl.V_INSSetImpl;


public class ModelClassImpl extends ModelInstance<ModelClass,Sql> implements ModelClass {

    public static final String KEY_LETTERS = "O_OBJ";
    public static final ModelClass EMPTY_MODELCLASS = new EmptyModelClass();

    private Sql context;

    // constructors
    private ModelClassImpl( Sql context ) {
        this.context = context;
        ref_Obj_ID = UniqueId.random();
        m_Name = "";
        m_Numb = 0;
        m_Key_Lett = "";
        m_Descrip = "";
        m_SS_IDdeprecated = UniqueId.random();
        R101_has_presence_in_other_subsystems_ImportedClass_set = new ImportedClassSetImpl();
        R102_has_characteristics_abstracted_by_O_ATTR_set = new O_ATTRSetImpl();
        R104_is_identified_by_ClassIdentifier_set = new ClassIdentifierSetImpl();
        R115_may_contain_O_TFR_set = new O_TFRSetImpl();
        R123_is_available_as_a_reference_by_InstanceReferenceDataType_set = new InstanceReferenceDataTypeSetImpl();
        R201_has_instance_associations_abstracted_ClassInAssociation_set = new ClassInAssociationSetImpl();
        R409_is_basis_for_ModelInst_inst = ModelInstImpl.EMPTY_MODELINST;
        R518_InstanceStateMachine_inst = InstanceStateMachineImpl.EMPTY_INSTANCESTATEMACHINE;
        R519_ClassStateMachine_inst = ClassStateMachineImpl.EMPTY_CLASSSTATEMACHINE;
        R670_ForStmt_set = new ForStmtSetImpl();
        R671_Create_set = new CreateSetImpl();
        R672_CreateNoVariable_set = new CreateNoVariableSetImpl();
        R676_SelectFromInstancesWhere_set = new SelectFromInstancesWhereSetImpl();
        R677_ACT_FIO_set = new ACT_FIOSetImpl();
        R678_ChainLink_set = new ChainLinkSetImpl();
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
        R818_InstanceHandle_set = new InstanceHandleSetImpl();
        R819_V_INS_set = new V_INSSetImpl();
        R934_represents_participant_of_ClassInstanceParticipant_set = new ClassInstanceParticipantSetImpl();
        R939_represents_participant_of_ClassParticipant_set = new ClassParticipantSetImpl();
    }

    private ModelClassImpl( Sql context, UniqueId instanceId, UniqueId ref_Obj_ID, String m_Name, int m_Numb, String m_Key_Lett, String m_Descrip, UniqueId m_SS_IDdeprecated ) {
        super(instanceId);
        this.context = context;
        this.ref_Obj_ID = ref_Obj_ID;
        this.m_Name = m_Name;
        this.m_Numb = m_Numb;
        this.m_Key_Lett = m_Key_Lett;
        this.m_Descrip = m_Descrip;
        this.m_SS_IDdeprecated = m_SS_IDdeprecated;
        R101_has_presence_in_other_subsystems_ImportedClass_set = new ImportedClassSetImpl();
        R102_has_characteristics_abstracted_by_O_ATTR_set = new O_ATTRSetImpl();
        R104_is_identified_by_ClassIdentifier_set = new ClassIdentifierSetImpl();
        R115_may_contain_O_TFR_set = new O_TFRSetImpl();
        R123_is_available_as_a_reference_by_InstanceReferenceDataType_set = new InstanceReferenceDataTypeSetImpl();
        R201_has_instance_associations_abstracted_ClassInAssociation_set = new ClassInAssociationSetImpl();
        R409_is_basis_for_ModelInst_inst = ModelInstImpl.EMPTY_MODELINST;
        R518_InstanceStateMachine_inst = InstanceStateMachineImpl.EMPTY_INSTANCESTATEMACHINE;
        R519_ClassStateMachine_inst = ClassStateMachineImpl.EMPTY_CLASSSTATEMACHINE;
        R670_ForStmt_set = new ForStmtSetImpl();
        R671_Create_set = new CreateSetImpl();
        R672_CreateNoVariable_set = new CreateNoVariableSetImpl();
        R676_SelectFromInstancesWhere_set = new SelectFromInstancesWhereSetImpl();
        R677_ACT_FIO_set = new ACT_FIOSetImpl();
        R678_ChainLink_set = new ChainLinkSetImpl();
        R8001_is_a_PackageableElement_inst = PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
        R818_InstanceHandle_set = new InstanceHandleSetImpl();
        R819_V_INS_set = new V_INSSetImpl();
        R934_represents_participant_of_ClassInstanceParticipant_set = new ClassInstanceParticipantSetImpl();
        R939_represents_participant_of_ClassParticipant_set = new ClassParticipantSetImpl();
    }

    public static ModelClass create( Sql context ) throws XtumlException {
        ModelClass newModelClass = new ModelClassImpl( context );
        if ( context.addInstance( newModelClass ) ) {
            newModelClass.getRunContext().addChange(new InstanceCreatedDelta(newModelClass, KEY_LETTERS));
            return newModelClass;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ModelClass create( Sql context, UniqueId instanceId, UniqueId ref_Obj_ID, String m_Name, int m_Numb, String m_Key_Lett, String m_Descrip, UniqueId m_SS_IDdeprecated ) throws XtumlException {
        ModelClass newModelClass = new ModelClassImpl( context, instanceId, ref_Obj_ID, m_Name, m_Numb, m_Key_Lett, m_Descrip, m_SS_IDdeprecated );
        if ( context.addInstance( newModelClass ) ) {
            return newModelClass;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Obj_ID;
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
        return ref_Obj_ID;
    }
    @Override
    public void setObj_ID(UniqueId ref_Obj_ID) throws XtumlException {
        checkLiving();
        if (ref_Obj_ID.inequality( this.ref_Obj_ID)) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
            if ( !R101_has_presence_in_other_subsystems_ImportedClass().isEmpty() ) R101_has_presence_in_other_subsystems_ImportedClass().setObj_ID( ref_Obj_ID );
            if ( !R676_SelectFromInstancesWhere().isEmpty() ) R676_SelectFromInstancesWhere().setObj_ID( ref_Obj_ID );
            if ( !R519_ClassStateMachine().isEmpty() ) R519_ClassStateMachine().setObj_ID( ref_Obj_ID );
            if ( !R939_represents_participant_of_ClassParticipant().isEmpty() ) R939_represents_participant_of_ClassParticipant().setObj_ID( ref_Obj_ID );
            if ( !R671_Create().isEmpty() ) R671_Create().setObj_ID( ref_Obj_ID );
            if ( !R672_CreateNoVariable().isEmpty() ) R672_CreateNoVariable().setObj_ID( ref_Obj_ID );
            if ( !R115_may_contain_O_TFR().isEmpty() ) R115_may_contain_O_TFR().setObj_ID( ref_Obj_ID );
            if ( !R518_InstanceStateMachine().isEmpty() ) R518_InstanceStateMachine().setObj_ID( ref_Obj_ID );
            if ( !R677_ACT_FIO().isEmpty() ) R677_ACT_FIO().setObj_ID( ref_Obj_ID );
            if ( !R678_ChainLink().isEmpty() ) R678_ChainLink().setObj_ID( ref_Obj_ID );
            if ( !R104_is_identified_by_ClassIdentifier().isEmpty() ) R104_is_identified_by_ClassIdentifier().setObj_ID( ref_Obj_ID );
            if ( !R819_V_INS().isEmpty() ) R819_V_INS().setObj_ID( ref_Obj_ID );
            if ( !R201_has_instance_associations_abstracted_ClassInAssociation().isEmpty() ) R201_has_instance_associations_abstracted_ClassInAssociation().setObj_ID( ref_Obj_ID );
            if ( !R670_ForStmt().isEmpty() ) R670_ForStmt().setObj_ID( ref_Obj_ID );
            if ( !R934_represents_participant_of_ClassInstanceParticipant().isEmpty() ) R934_represents_participant_of_ClassInstanceParticipant().setObj_ID( ref_Obj_ID );
            if ( !R409_is_basis_for_ModelInst().isEmpty() ) R409_is_basis_for_ModelInst().setObj_ID( ref_Obj_ID );
            if ( !R123_is_available_as_a_reference_by_InstanceReferenceDataType().isEmpty() ) R123_is_available_as_a_reference_by_InstanceReferenceDataType().setObj_ID( ref_Obj_ID );
            if ( !R102_has_characteristics_abstracted_by_O_ATTR().isEmpty() ) R102_has_characteristics_abstracted_by_O_ATTR().setObj_ID( ref_Obj_ID );
            if ( !R818_InstanceHandle().isEmpty() ) R818_InstanceHandle().setObj_ID( ref_Obj_ID );
        }
    }
    private String m_Name;
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    private int m_Numb;
    @Override
    public void setNumb(int m_Numb) throws XtumlException {
        checkLiving();
        if (m_Numb != this.m_Numb) {
            final int oldValue = this.m_Numb;
            this.m_Numb = m_Numb;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Numb", oldValue, this.m_Numb));
        }
    }
    @Override
    public int getNumb() throws XtumlException {
        checkLiving();
        return m_Numb;
    }
    private String m_Key_Lett;
    @Override
    public void setKey_Lett(String m_Key_Lett) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Key_Lett, this.m_Key_Lett)) {
            final String oldValue = this.m_Key_Lett;
            this.m_Key_Lett = m_Key_Lett;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Key_Lett", oldValue, this.m_Key_Lett));
        }
    }
    @Override
    public String getKey_Lett() throws XtumlException {
        checkLiving();
        return m_Key_Lett;
    }
    private String m_Descrip;
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    private UniqueId m_SS_IDdeprecated;
    @Override
    public void setSS_IDdeprecated(UniqueId m_SS_IDdeprecated) throws XtumlException {
        checkLiving();
        if (m_SS_IDdeprecated.inequality( this.m_SS_IDdeprecated)) {
            final UniqueId oldValue = this.m_SS_IDdeprecated;
            this.m_SS_IDdeprecated = m_SS_IDdeprecated;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_SS_IDdeprecated", oldValue, this.m_SS_IDdeprecated));
        }
    }
    @Override
    public UniqueId getSS_IDdeprecated() throws XtumlException {
        checkLiving();
        return m_SS_IDdeprecated;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getObj_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ImportedClassSet R101_has_presence_in_other_subsystems_ImportedClass_set;
    @Override
    public void addR101_has_presence_in_other_subsystems_ImportedClass( ImportedClass inst ) {
        R101_has_presence_in_other_subsystems_ImportedClass_set.add(inst);
    }
    @Override
    public void removeR101_has_presence_in_other_subsystems_ImportedClass( ImportedClass inst ) {
        R101_has_presence_in_other_subsystems_ImportedClass_set.remove(inst);
    }
    @Override
    public ImportedClassSet R101_has_presence_in_other_subsystems_ImportedClass() throws XtumlException {
        return R101_has_presence_in_other_subsystems_ImportedClass_set;
    }
    private O_ATTRSet R102_has_characteristics_abstracted_by_O_ATTR_set;
    @Override
    public void addR102_has_characteristics_abstracted_by_O_ATTR( O_ATTR inst ) {
        R102_has_characteristics_abstracted_by_O_ATTR_set.add(inst);
    }
    @Override
    public void removeR102_has_characteristics_abstracted_by_O_ATTR( O_ATTR inst ) {
        R102_has_characteristics_abstracted_by_O_ATTR_set.remove(inst);
    }
    @Override
    public O_ATTRSet R102_has_characteristics_abstracted_by_O_ATTR() throws XtumlException {
        return R102_has_characteristics_abstracted_by_O_ATTR_set;
    }
    private ClassIdentifierSet R104_is_identified_by_ClassIdentifier_set;
    @Override
    public void addR104_is_identified_by_ClassIdentifier( ClassIdentifier inst ) {
        R104_is_identified_by_ClassIdentifier_set.add(inst);
    }
    @Override
    public void removeR104_is_identified_by_ClassIdentifier( ClassIdentifier inst ) {
        R104_is_identified_by_ClassIdentifier_set.remove(inst);
    }
    @Override
    public ClassIdentifierSet R104_is_identified_by_ClassIdentifier() throws XtumlException {
        return R104_is_identified_by_ClassIdentifier_set;
    }
    private O_TFRSet R115_may_contain_O_TFR_set;
    @Override
    public void addR115_may_contain_O_TFR( O_TFR inst ) {
        R115_may_contain_O_TFR_set.add(inst);
    }
    @Override
    public void removeR115_may_contain_O_TFR( O_TFR inst ) {
        R115_may_contain_O_TFR_set.remove(inst);
    }
    @Override
    public O_TFRSet R115_may_contain_O_TFR() throws XtumlException {
        return R115_may_contain_O_TFR_set;
    }
    private InstanceReferenceDataTypeSet R123_is_available_as_a_reference_by_InstanceReferenceDataType_set;
    @Override
    public void addR123_is_available_as_a_reference_by_InstanceReferenceDataType( InstanceReferenceDataType inst ) {
        R123_is_available_as_a_reference_by_InstanceReferenceDataType_set.add(inst);
    }
    @Override
    public void removeR123_is_available_as_a_reference_by_InstanceReferenceDataType( InstanceReferenceDataType inst ) {
        R123_is_available_as_a_reference_by_InstanceReferenceDataType_set.remove(inst);
    }
    @Override
    public InstanceReferenceDataTypeSet R123_is_available_as_a_reference_by_InstanceReferenceDataType() throws XtumlException {
        return R123_is_available_as_a_reference_by_InstanceReferenceDataType_set;
    }
    private ClassInAssociationSet R201_has_instance_associations_abstracted_ClassInAssociation_set;
    @Override
    public void addR201_has_instance_associations_abstracted_ClassInAssociation( ClassInAssociation inst ) {
        R201_has_instance_associations_abstracted_ClassInAssociation_set.add(inst);
    }
    @Override
    public void removeR201_has_instance_associations_abstracted_ClassInAssociation( ClassInAssociation inst ) {
        R201_has_instance_associations_abstracted_ClassInAssociation_set.remove(inst);
    }
    @Override
    public ClassInAssociationSet R201_has_instance_associations_abstracted_ClassInAssociation() throws XtumlException {
        return R201_has_instance_associations_abstracted_ClassInAssociation_set;
    }
    private ModelInst R409_is_basis_for_ModelInst_inst;
    @Override
    public void setR409_is_basis_for_ModelInst( ModelInst inst ) {
        R409_is_basis_for_ModelInst_inst = inst;
    }
    @Override
    public ModelInst R409_is_basis_for_ModelInst() throws XtumlException {
        return R409_is_basis_for_ModelInst_inst;
    }
    private InstanceStateMachine R518_InstanceStateMachine_inst;
    @Override
    public void setR518_InstanceStateMachine( InstanceStateMachine inst ) {
        R518_InstanceStateMachine_inst = inst;
    }
    @Override
    public InstanceStateMachine R518_InstanceStateMachine() throws XtumlException {
        return R518_InstanceStateMachine_inst;
    }
    private ClassStateMachine R519_ClassStateMachine_inst;
    @Override
    public void setR519_ClassStateMachine( ClassStateMachine inst ) {
        R519_ClassStateMachine_inst = inst;
    }
    @Override
    public ClassStateMachine R519_ClassStateMachine() throws XtumlException {
        return R519_ClassStateMachine_inst;
    }
    private ForStmtSet R670_ForStmt_set;
    @Override
    public void addR670_ForStmt( ForStmt inst ) {
        R670_ForStmt_set.add(inst);
    }
    @Override
    public void removeR670_ForStmt( ForStmt inst ) {
        R670_ForStmt_set.remove(inst);
    }
    @Override
    public ForStmtSet R670_ForStmt() throws XtumlException {
        return R670_ForStmt_set;
    }
    private CreateSet R671_Create_set;
    @Override
    public void addR671_Create( Create inst ) {
        R671_Create_set.add(inst);
    }
    @Override
    public void removeR671_Create( Create inst ) {
        R671_Create_set.remove(inst);
    }
    @Override
    public CreateSet R671_Create() throws XtumlException {
        return R671_Create_set;
    }
    private CreateNoVariableSet R672_CreateNoVariable_set;
    @Override
    public void addR672_CreateNoVariable( CreateNoVariable inst ) {
        R672_CreateNoVariable_set.add(inst);
    }
    @Override
    public void removeR672_CreateNoVariable( CreateNoVariable inst ) {
        R672_CreateNoVariable_set.remove(inst);
    }
    @Override
    public CreateNoVariableSet R672_CreateNoVariable() throws XtumlException {
        return R672_CreateNoVariable_set;
    }
    private SelectFromInstancesWhereSet R676_SelectFromInstancesWhere_set;
    @Override
    public void addR676_SelectFromInstancesWhere( SelectFromInstancesWhere inst ) {
        R676_SelectFromInstancesWhere_set.add(inst);
    }
    @Override
    public void removeR676_SelectFromInstancesWhere( SelectFromInstancesWhere inst ) {
        R676_SelectFromInstancesWhere_set.remove(inst);
    }
    @Override
    public SelectFromInstancesWhereSet R676_SelectFromInstancesWhere() throws XtumlException {
        return R676_SelectFromInstancesWhere_set;
    }
    private ACT_FIOSet R677_ACT_FIO_set;
    @Override
    public void addR677_ACT_FIO( ACT_FIO inst ) {
        R677_ACT_FIO_set.add(inst);
    }
    @Override
    public void removeR677_ACT_FIO( ACT_FIO inst ) {
        R677_ACT_FIO_set.remove(inst);
    }
    @Override
    public ACT_FIOSet R677_ACT_FIO() throws XtumlException {
        return R677_ACT_FIO_set;
    }
    private ChainLinkSet R678_ChainLink_set;
    @Override
    public void addR678_ChainLink( ChainLink inst ) {
        R678_ChainLink_set.add(inst);
    }
    @Override
    public void removeR678_ChainLink( ChainLink inst ) {
        R678_ChainLink_set.remove(inst);
    }
    @Override
    public ChainLinkSet R678_ChainLink() throws XtumlException {
        return R678_ChainLink_set;
    }
    private PackageableElement R8001_is_a_PackageableElement_inst;
    @Override
    public void setR8001_is_a_PackageableElement( PackageableElement inst ) {
        R8001_is_a_PackageableElement_inst = inst;
    }
    @Override
    public PackageableElement R8001_is_a_PackageableElement() throws XtumlException {
        return R8001_is_a_PackageableElement_inst;
    }
    private InstanceHandleSet R818_InstanceHandle_set;
    @Override
    public void addR818_InstanceHandle( InstanceHandle inst ) {
        R818_InstanceHandle_set.add(inst);
    }
    @Override
    public void removeR818_InstanceHandle( InstanceHandle inst ) {
        R818_InstanceHandle_set.remove(inst);
    }
    @Override
    public InstanceHandleSet R818_InstanceHandle() throws XtumlException {
        return R818_InstanceHandle_set;
    }
    private V_INSSet R819_V_INS_set;
    @Override
    public void addR819_V_INS( V_INS inst ) {
        R819_V_INS_set.add(inst);
    }
    @Override
    public void removeR819_V_INS( V_INS inst ) {
        R819_V_INS_set.remove(inst);
    }
    @Override
    public V_INSSet R819_V_INS() throws XtumlException {
        return R819_V_INS_set;
    }
    private ClassInstanceParticipantSet R934_represents_participant_of_ClassInstanceParticipant_set;
    @Override
    public void addR934_represents_participant_of_ClassInstanceParticipant( ClassInstanceParticipant inst ) {
        R934_represents_participant_of_ClassInstanceParticipant_set.add(inst);
    }
    @Override
    public void removeR934_represents_participant_of_ClassInstanceParticipant( ClassInstanceParticipant inst ) {
        R934_represents_participant_of_ClassInstanceParticipant_set.remove(inst);
    }
    @Override
    public ClassInstanceParticipantSet R934_represents_participant_of_ClassInstanceParticipant() throws XtumlException {
        return R934_represents_participant_of_ClassInstanceParticipant_set;
    }
    private ClassParticipantSet R939_represents_participant_of_ClassParticipant_set;
    @Override
    public void addR939_represents_participant_of_ClassParticipant( ClassParticipant inst ) {
        R939_represents_participant_of_ClassParticipant_set.add(inst);
    }
    @Override
    public void removeR939_represents_participant_of_ClassParticipant( ClassParticipant inst ) {
        R939_represents_participant_of_ClassParticipant_set.remove(inst);
    }
    @Override
    public ClassParticipantSet R939_represents_participant_of_ClassParticipant() throws XtumlException {
        return R939_represents_participant_of_ClassParticipant_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ModelClass self() {
        return this;
    }

    @Override
    public ModelClass oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_MODELCLASS;
    }

}

class EmptyModelClass extends ModelInstance<ModelClass,Sql> implements ModelClass {

    // attributes
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setNumb( int m_Numb ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getNumb() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setKey_Lett( String m_Key_Lett ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getKey_Lett() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSS_IDdeprecated( UniqueId m_SS_IDdeprecated ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSS_IDdeprecated() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ImportedClassSet R101_has_presence_in_other_subsystems_ImportedClass() {
        return (new ImportedClassSetImpl());
    }
    @Override
    public O_ATTRSet R102_has_characteristics_abstracted_by_O_ATTR() {
        return (new O_ATTRSetImpl());
    }
    @Override
    public ClassIdentifierSet R104_is_identified_by_ClassIdentifier() {
        return (new ClassIdentifierSetImpl());
    }
    @Override
    public O_TFRSet R115_may_contain_O_TFR() {
        return (new O_TFRSetImpl());
    }
    @Override
    public InstanceReferenceDataTypeSet R123_is_available_as_a_reference_by_InstanceReferenceDataType() {
        return (new InstanceReferenceDataTypeSetImpl());
    }
    @Override
    public ClassInAssociationSet R201_has_instance_associations_abstracted_ClassInAssociation() {
        return (new ClassInAssociationSetImpl());
    }
    @Override
    public ModelInst R409_is_basis_for_ModelInst() {
        return ModelInstImpl.EMPTY_MODELINST;
    }
    @Override
    public InstanceStateMachine R518_InstanceStateMachine() {
        return InstanceStateMachineImpl.EMPTY_INSTANCESTATEMACHINE;
    }
    @Override
    public ClassStateMachine R519_ClassStateMachine() {
        return ClassStateMachineImpl.EMPTY_CLASSSTATEMACHINE;
    }
    @Override
    public ForStmtSet R670_ForStmt() {
        return (new ForStmtSetImpl());
    }
    @Override
    public CreateSet R671_Create() {
        return (new CreateSetImpl());
    }
    @Override
    public CreateNoVariableSet R672_CreateNoVariable() {
        return (new CreateNoVariableSetImpl());
    }
    @Override
    public SelectFromInstancesWhereSet R676_SelectFromInstancesWhere() {
        return (new SelectFromInstancesWhereSetImpl());
    }
    @Override
    public ACT_FIOSet R677_ACT_FIO() {
        return (new ACT_FIOSetImpl());
    }
    @Override
    public ChainLinkSet R678_ChainLink() {
        return (new ChainLinkSetImpl());
    }
    @Override
    public PackageableElement R8001_is_a_PackageableElement() {
        return PackageableElementImpl.EMPTY_PACKAGEABLEELEMENT;
    }
    @Override
    public InstanceHandleSet R818_InstanceHandle() {
        return (new InstanceHandleSetImpl());
    }
    @Override
    public V_INSSet R819_V_INS() {
        return (new V_INSSetImpl());
    }
    @Override
    public ClassInstanceParticipantSet R934_represents_participant_of_ClassInstanceParticipant() {
        return (new ClassInstanceParticipantSetImpl());
    }
    @Override
    public ClassParticipantSet R939_represents_participant_of_ClassParticipant() {
        return (new ClassParticipantSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return ModelClassImpl.KEY_LETTERS;
    }

    @Override
    public ModelClass self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ModelClass oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ModelClassImpl.EMPTY_MODELCLASS;
    }

}
