package io.ciera.tool.sql.ooaofooa.statemachine.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.statemachine.NonLocalEvent;
import io.ciera.tool.sql.ooaofooa.statemachine.NonLocalEventSet;
import io.ciera.tool.sql.ooaofooa.statemachine.PolymorphicEvent;
import io.ciera.tool.sql.ooaofooa.statemachine.StateMachineEvent;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.NonLocalEventSetImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.StateMachineEventImpl;


public class PolymorphicEventImpl extends ModelInstance<PolymorphicEvent,Sql> implements PolymorphicEvent {

    public static final String KEY_LETTERS = "SM_PEVT";
    public static final PolymorphicEvent EMPTY_POLYMORPHICEVENT = new EmptyPolymorphicEvent();

    private Sql context;

    // constructors
    private PolymorphicEventImpl( Sql context ) {
        this.context = context;
        ref_SMevt_ID = UniqueId.random();
        ref_SM_ID = UniqueId.random();
        m_SMspd_IDdeprecated = UniqueId.random();
        m_localClassName = "";
        m_localClassKL = "";
        m_localEventMning = "";
        R525_is_a_StateMachineEvent_inst = StateMachineEventImpl.EMPTY_STATEMACHINEEVENT;
        R527_is_aliased_by_NonLocalEvent_set = new NonLocalEventSetImpl();
    }

    private PolymorphicEventImpl( Sql context, UniqueId instanceId, UniqueId ref_SMevt_ID, UniqueId ref_SM_ID, UniqueId m_SMspd_IDdeprecated, String m_localClassName, String m_localClassKL, String m_localEventMning ) {
        super(instanceId);
        this.context = context;
        this.ref_SMevt_ID = ref_SMevt_ID;
        this.ref_SM_ID = ref_SM_ID;
        this.m_SMspd_IDdeprecated = m_SMspd_IDdeprecated;
        this.m_localClassName = m_localClassName;
        this.m_localClassKL = m_localClassKL;
        this.m_localEventMning = m_localEventMning;
        R525_is_a_StateMachineEvent_inst = StateMachineEventImpl.EMPTY_STATEMACHINEEVENT;
        R527_is_aliased_by_NonLocalEvent_set = new NonLocalEventSetImpl();
    }

    public static PolymorphicEvent create( Sql context ) throws XtumlException {
        PolymorphicEvent newPolymorphicEvent = new PolymorphicEventImpl( context );
        if ( context.addInstance( newPolymorphicEvent ) ) {
            newPolymorphicEvent.getRunContext().addChange(new InstanceCreatedDelta(newPolymorphicEvent, KEY_LETTERS));
            return newPolymorphicEvent;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static PolymorphicEvent create( Sql context, UniqueId instanceId, UniqueId ref_SMevt_ID, UniqueId ref_SM_ID, UniqueId m_SMspd_IDdeprecated, String m_localClassName, String m_localClassKL, String m_localEventMning ) throws XtumlException {
        PolymorphicEvent newPolymorphicEvent = new PolymorphicEventImpl( context, instanceId, ref_SMevt_ID, ref_SM_ID, m_SMspd_IDdeprecated, m_localClassName, m_localClassKL, m_localEventMning );
        if ( context.addInstance( newPolymorphicEvent ) ) {
            return newPolymorphicEvent;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_SMevt_ID;
    @Override
    public UniqueId getSMevt_ID() throws XtumlException {
        checkLiving();
        return ref_SMevt_ID;
    }
    @Override
    public void setSMevt_ID(UniqueId ref_SMevt_ID) throws XtumlException {
        checkLiving();
        if (ref_SMevt_ID.inequality( this.ref_SMevt_ID)) {
            final UniqueId oldValue = this.ref_SMevt_ID;
            this.ref_SMevt_ID = ref_SMevt_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SMevt_ID", oldValue, this.ref_SMevt_ID));
            if ( !R527_is_aliased_by_NonLocalEvent().isEmpty() ) R527_is_aliased_by_NonLocalEvent().setPolySMevt_ID( ref_SMevt_ID );
        }
    }
    private UniqueId ref_SM_ID;
    @Override
    public void setSM_ID(UniqueId ref_SM_ID) throws XtumlException {
        checkLiving();
        if (ref_SM_ID.inequality( this.ref_SM_ID)) {
            final UniqueId oldValue = this.ref_SM_ID;
            this.ref_SM_ID = ref_SM_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SM_ID", oldValue, this.ref_SM_ID));
            if ( !R527_is_aliased_by_NonLocalEvent().isEmpty() ) R527_is_aliased_by_NonLocalEvent().setPolySM_ID( ref_SM_ID );
        }
    }
    @Override
    public UniqueId getSM_ID() throws XtumlException {
        checkLiving();
        return ref_SM_ID;
    }
    private UniqueId m_SMspd_IDdeprecated;
    @Override
    public void setSMspd_IDdeprecated(UniqueId m_SMspd_IDdeprecated) throws XtumlException {
        checkLiving();
        if (m_SMspd_IDdeprecated.inequality( this.m_SMspd_IDdeprecated)) {
            final UniqueId oldValue = this.m_SMspd_IDdeprecated;
            this.m_SMspd_IDdeprecated = m_SMspd_IDdeprecated;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_SMspd_IDdeprecated", oldValue, this.m_SMspd_IDdeprecated));
        }
    }
    @Override
    public UniqueId getSMspd_IDdeprecated() throws XtumlException {
        checkLiving();
        return m_SMspd_IDdeprecated;
    }
    private String m_localClassName;
    @Override
    public void setLocalClassName(String m_localClassName) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_localClassName, this.m_localClassName)) {
            final String oldValue = this.m_localClassName;
            this.m_localClassName = m_localClassName;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_localClassName", oldValue, this.m_localClassName));
        }
    }
    @Override
    public String getLocalClassName() throws XtumlException {
        checkLiving();
        return m_localClassName;
    }
    private String m_localClassKL;
    @Override
    public String getLocalClassKL() throws XtumlException {
        checkLiving();
        return m_localClassKL;
    }
    @Override
    public void setLocalClassKL(String m_localClassKL) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_localClassKL, this.m_localClassKL)) {
            final String oldValue = this.m_localClassKL;
            this.m_localClassKL = m_localClassKL;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_localClassKL", oldValue, this.m_localClassKL));
        }
    }
    private String m_localEventMning;
    @Override
    public String getLocalEventMning() throws XtumlException {
        checkLiving();
        return m_localEventMning;
    }
    @Override
    public void setLocalEventMning(String m_localEventMning) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_localEventMning, this.m_localEventMning)) {
            final String oldValue = this.m_localEventMning;
            this.m_localEventMning = m_localEventMning;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_localEventMning", oldValue, this.m_localEventMning));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getSMevt_ID(), getSM_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private StateMachineEvent R525_is_a_StateMachineEvent_inst;
    @Override
    public void setR525_is_a_StateMachineEvent( StateMachineEvent inst ) {
        R525_is_a_StateMachineEvent_inst = inst;
    }
    @Override
    public StateMachineEvent R525_is_a_StateMachineEvent() throws XtumlException {
        return R525_is_a_StateMachineEvent_inst;
    }
    private NonLocalEventSet R527_is_aliased_by_NonLocalEvent_set;
    @Override
    public void addR527_is_aliased_by_NonLocalEvent( NonLocalEvent inst ) {
        R527_is_aliased_by_NonLocalEvent_set.add(inst);
    }
    @Override
    public void removeR527_is_aliased_by_NonLocalEvent( NonLocalEvent inst ) {
        R527_is_aliased_by_NonLocalEvent_set.remove(inst);
    }
    @Override
    public NonLocalEventSet R527_is_aliased_by_NonLocalEvent() throws XtumlException {
        return R527_is_aliased_by_NonLocalEvent_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public PolymorphicEvent self() {
        return this;
    }

    @Override
    public PolymorphicEvent oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_POLYMORPHICEVENT;
    }

}

class EmptyPolymorphicEvent extends ModelInstance<PolymorphicEvent,Sql> implements PolymorphicEvent {

    // attributes
    public UniqueId getSMevt_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSMevt_ID( UniqueId ref_SMevt_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setSM_ID( UniqueId ref_SM_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSM_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSMspd_IDdeprecated( UniqueId m_SMspd_IDdeprecated ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSMspd_IDdeprecated() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLocalClassName( String m_localClassName ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLocalClassName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getLocalClassKL() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLocalClassKL( String m_localClassKL ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLocalEventMning() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLocalEventMning( String m_localEventMning ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public StateMachineEvent R525_is_a_StateMachineEvent() {
        return StateMachineEventImpl.EMPTY_STATEMACHINEEVENT;
    }
    @Override
    public NonLocalEventSet R527_is_aliased_by_NonLocalEvent() {
        return (new NonLocalEventSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return PolymorphicEventImpl.KEY_LETTERS;
    }

    @Override
    public PolymorphicEvent self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public PolymorphicEvent oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return PolymorphicEventImpl.EMPTY_POLYMORPHICEVENT;
    }

}
