package io.ciera.tool.sql.ooaofooa.message.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.message.OperationMessage;
import io.ciera.tool.sql.ooaofooa.message.SynchronousMessage;
import io.ciera.tool.sql.ooaofooa.message.impl.SynchronousMessageImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.O_TFR;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.O_TFRImpl;


public class OperationMessageImpl extends ModelInstance<OperationMessage,Sql> implements OperationMessage {

    public static final String KEY_LETTERS = "MSG_O";
    public static final OperationMessage EMPTY_OPERATIONMESSAGE = new EmptyOperationMessage();

    private Sql context;

    // constructors
    private OperationMessageImpl( Sql context ) {
        this.context = context;
        ref_Msg_ID = UniqueId.random();
        ref_Tfr_ID = UniqueId.random();
        R1011_is_invocation_of_O_TFR_inst = O_TFRImpl.EMPTY_O_TFR;
        R1020_is_a_SynchronousMessage_inst = SynchronousMessageImpl.EMPTY_SYNCHRONOUSMESSAGE;
    }

    private OperationMessageImpl( Sql context, UniqueId instanceId, UniqueId ref_Msg_ID, UniqueId ref_Tfr_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Msg_ID = ref_Msg_ID;
        this.ref_Tfr_ID = ref_Tfr_ID;
        R1011_is_invocation_of_O_TFR_inst = O_TFRImpl.EMPTY_O_TFR;
        R1020_is_a_SynchronousMessage_inst = SynchronousMessageImpl.EMPTY_SYNCHRONOUSMESSAGE;
    }

    public static OperationMessage create( Sql context ) throws XtumlException {
        OperationMessage newOperationMessage = new OperationMessageImpl( context );
        if ( context.addInstance( newOperationMessage ) ) {
            newOperationMessage.getRunContext().addChange(new InstanceCreatedDelta(newOperationMessage, KEY_LETTERS));
            return newOperationMessage;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static OperationMessage create( Sql context, UniqueId instanceId, UniqueId ref_Msg_ID, UniqueId ref_Tfr_ID ) throws XtumlException {
        OperationMessage newOperationMessage = new OperationMessageImpl( context, instanceId, ref_Msg_ID, ref_Tfr_ID );
        if ( context.addInstance( newOperationMessage ) ) {
            return newOperationMessage;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Msg_ID;
    @Override
    public void setMsg_ID(UniqueId ref_Msg_ID) throws XtumlException {
        checkLiving();
        if (ref_Msg_ID.inequality( this.ref_Msg_ID)) {
            final UniqueId oldValue = this.ref_Msg_ID;
            this.ref_Msg_ID = ref_Msg_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Msg_ID", oldValue, this.ref_Msg_ID));
        }
    }
    @Override
    public UniqueId getMsg_ID() throws XtumlException {
        checkLiving();
        return ref_Msg_ID;
    }
    private UniqueId ref_Tfr_ID;
    @Override
    public void setTfr_ID(UniqueId ref_Tfr_ID) throws XtumlException {
        checkLiving();
        if (ref_Tfr_ID.inequality( this.ref_Tfr_ID)) {
            final UniqueId oldValue = this.ref_Tfr_ID;
            this.ref_Tfr_ID = ref_Tfr_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Tfr_ID", oldValue, this.ref_Tfr_ID));
        }
    }
    @Override
    public UniqueId getTfr_ID() throws XtumlException {
        checkLiving();
        return ref_Tfr_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getMsg_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private O_TFR R1011_is_invocation_of_O_TFR_inst;
    @Override
    public void setR1011_is_invocation_of_O_TFR( O_TFR inst ) {
        R1011_is_invocation_of_O_TFR_inst = inst;
    }
    @Override
    public O_TFR R1011_is_invocation_of_O_TFR() throws XtumlException {
        return R1011_is_invocation_of_O_TFR_inst;
    }
    private SynchronousMessage R1020_is_a_SynchronousMessage_inst;
    @Override
    public void setR1020_is_a_SynchronousMessage( SynchronousMessage inst ) {
        R1020_is_a_SynchronousMessage_inst = inst;
    }
    @Override
    public SynchronousMessage R1020_is_a_SynchronousMessage() throws XtumlException {
        return R1020_is_a_SynchronousMessage_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public OperationMessage self() {
        return this;
    }

    @Override
    public OperationMessage oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_OPERATIONMESSAGE;
    }

}

class EmptyOperationMessage extends ModelInstance<OperationMessage,Sql> implements OperationMessage {

    // attributes
    public void setMsg_ID( UniqueId ref_Msg_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getMsg_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setTfr_ID( UniqueId ref_Tfr_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getTfr_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public O_TFR R1011_is_invocation_of_O_TFR() {
        return O_TFRImpl.EMPTY_O_TFR;
    }
    @Override
    public SynchronousMessage R1020_is_a_SynchronousMessage() {
        return SynchronousMessageImpl.EMPTY_SYNCHRONOUSMESSAGE;
    }


    @Override
    public String getKeyLetters() {
        return OperationMessageImpl.KEY_LETTERS;
    }

    @Override
    public OperationMessage self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public OperationMessage oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return OperationMessageImpl.EMPTY_OPERATIONMESSAGE;
    }

}
