package io.ciera.tool.sql.ooaofooa.message.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.component.PropertyParameter;
import io.ciera.tool.sql.ooaofooa.component.impl.PropertyParameterImpl;
import io.ciera.tool.sql.ooaofooa.message.ExecutablePropertyArgument;
import io.ciera.tool.sql.ooaofooa.message.MessageArgument;
import io.ciera.tool.sql.ooaofooa.message.impl.MessageArgumentImpl;


public class ExecutablePropertyArgumentImpl extends ModelInstance<ExecutablePropertyArgument,Sql> implements ExecutablePropertyArgument {

    public static final String KEY_LETTERS = "MSG_EPA";
    public static final ExecutablePropertyArgument EMPTY_EXECUTABLEPROPERTYARGUMENT = new EmptyExecutablePropertyArgument();

    private Sql context;

    // constructors
    private ExecutablePropertyArgumentImpl( Sql context ) {
        this.context = context;
        ref_Arg_ID = UniqueId.random();
        ref_PP_Id = UniqueId.random();
        R1013_is_a_MessageArgument_inst = MessageArgumentImpl.EMPTY_MESSAGEARGUMENT;
        R1023_is_represented_by_PropertyParameter_inst = PropertyParameterImpl.EMPTY_PROPERTYPARAMETER;
    }

    private ExecutablePropertyArgumentImpl( Sql context, UniqueId instanceId, UniqueId ref_Arg_ID, UniqueId ref_PP_Id ) {
        super(instanceId);
        this.context = context;
        this.ref_Arg_ID = ref_Arg_ID;
        this.ref_PP_Id = ref_PP_Id;
        R1013_is_a_MessageArgument_inst = MessageArgumentImpl.EMPTY_MESSAGEARGUMENT;
        R1023_is_represented_by_PropertyParameter_inst = PropertyParameterImpl.EMPTY_PROPERTYPARAMETER;
    }

    public static ExecutablePropertyArgument create( Sql context ) throws XtumlException {
        ExecutablePropertyArgument newExecutablePropertyArgument = new ExecutablePropertyArgumentImpl( context );
        if ( context.addInstance( newExecutablePropertyArgument ) ) {
            newExecutablePropertyArgument.getRunContext().addChange(new InstanceCreatedDelta(newExecutablePropertyArgument, KEY_LETTERS));
            return newExecutablePropertyArgument;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ExecutablePropertyArgument create( Sql context, UniqueId instanceId, UniqueId ref_Arg_ID, UniqueId ref_PP_Id ) throws XtumlException {
        ExecutablePropertyArgument newExecutablePropertyArgument = new ExecutablePropertyArgumentImpl( context, instanceId, ref_Arg_ID, ref_PP_Id );
        if ( context.addInstance( newExecutablePropertyArgument ) ) {
            return newExecutablePropertyArgument;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Arg_ID;
    @Override
    public UniqueId getArg_ID() throws XtumlException {
        checkLiving();
        return ref_Arg_ID;
    }
    @Override
    public void setArg_ID(UniqueId ref_Arg_ID) throws XtumlException {
        checkLiving();
        if (ref_Arg_ID.inequality( this.ref_Arg_ID)) {
            final UniqueId oldValue = this.ref_Arg_ID;
            this.ref_Arg_ID = ref_Arg_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Arg_ID", oldValue, this.ref_Arg_ID));
        }
    }
    private UniqueId ref_PP_Id;
    @Override
    public UniqueId getPP_Id() throws XtumlException {
        checkLiving();
        return ref_PP_Id;
    }
    @Override
    public void setPP_Id(UniqueId ref_PP_Id) throws XtumlException {
        checkLiving();
        if (ref_PP_Id.inequality( this.ref_PP_Id)) {
            final UniqueId oldValue = this.ref_PP_Id;
            this.ref_PP_Id = ref_PP_Id;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_PP_Id", oldValue, this.ref_PP_Id));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getArg_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private MessageArgument R1013_is_a_MessageArgument_inst;
    @Override
    public void setR1013_is_a_MessageArgument( MessageArgument inst ) {
        R1013_is_a_MessageArgument_inst = inst;
    }
    @Override
    public MessageArgument R1013_is_a_MessageArgument() throws XtumlException {
        return R1013_is_a_MessageArgument_inst;
    }
    private PropertyParameter R1023_is_represented_by_PropertyParameter_inst;
    @Override
    public void setR1023_is_represented_by_PropertyParameter( PropertyParameter inst ) {
        R1023_is_represented_by_PropertyParameter_inst = inst;
    }
    @Override
    public PropertyParameter R1023_is_represented_by_PropertyParameter() throws XtumlException {
        return R1023_is_represented_by_PropertyParameter_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ExecutablePropertyArgument self() {
        return this;
    }

    @Override
    public ExecutablePropertyArgument oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_EXECUTABLEPROPERTYARGUMENT;
    }

}

class EmptyExecutablePropertyArgument extends ModelInstance<ExecutablePropertyArgument,Sql> implements ExecutablePropertyArgument {

    // attributes
    public UniqueId getArg_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setArg_ID( UniqueId ref_Arg_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getPP_Id() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPP_Id( UniqueId ref_PP_Id ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public MessageArgument R1013_is_a_MessageArgument() {
        return MessageArgumentImpl.EMPTY_MESSAGEARGUMENT;
    }
    @Override
    public PropertyParameter R1023_is_represented_by_PropertyParameter() {
        return PropertyParameterImpl.EMPTY_PROPERTYPARAMETER;
    }


    @Override
    public String getKeyLetters() {
        return ExecutablePropertyArgumentImpl.KEY_LETTERS;
    }

    @Override
    public ExecutablePropertyArgument self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ExecutablePropertyArgument oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ExecutablePropertyArgumentImpl.EMPTY_EXECUTABLEPROPERTYARGUMENT;
    }

}
