package io.ciera.tool.sql.ooaofooa.message.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.message.AsynchronousMessage;
import io.ciera.tool.sql.ooaofooa.message.EventMessage;
import io.ciera.tool.sql.ooaofooa.message.impl.AsynchronousMessageImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.StateMachineEvent;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.StateMachineEventImpl;


public class EventMessageImpl extends ModelInstance<EventMessage,Sql> implements EventMessage {

    public static final String KEY_LETTERS = "MSG_E";
    public static final EventMessage EMPTY_EVENTMESSAGE = new EmptyEventMessage();

    private Sql context;

    // constructors
    private EventMessageImpl( Sql context ) {
        this.context = context;
        ref_Msg_ID = UniqueId.random();
        ref_SMevt_ID = UniqueId.random();
        R1009_generates_StateMachineEvent_inst = StateMachineEventImpl.EMPTY_STATEMACHINEEVENT;
        R1019_is_a_AsynchronousMessage_inst = AsynchronousMessageImpl.EMPTY_ASYNCHRONOUSMESSAGE;
    }

    private EventMessageImpl( Sql context, UniqueId instanceId, UniqueId ref_Msg_ID, UniqueId ref_SMevt_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Msg_ID = ref_Msg_ID;
        this.ref_SMevt_ID = ref_SMevt_ID;
        R1009_generates_StateMachineEvent_inst = StateMachineEventImpl.EMPTY_STATEMACHINEEVENT;
        R1019_is_a_AsynchronousMessage_inst = AsynchronousMessageImpl.EMPTY_ASYNCHRONOUSMESSAGE;
    }

    public static EventMessage create( Sql context ) throws XtumlException {
        EventMessage newEventMessage = new EventMessageImpl( context );
        if ( context.addInstance( newEventMessage ) ) {
            newEventMessage.getRunContext().addChange(new InstanceCreatedDelta(newEventMessage, KEY_LETTERS));
            return newEventMessage;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static EventMessage create( Sql context, UniqueId instanceId, UniqueId ref_Msg_ID, UniqueId ref_SMevt_ID ) throws XtumlException {
        EventMessage newEventMessage = new EventMessageImpl( context, instanceId, ref_Msg_ID, ref_SMevt_ID );
        if ( context.addInstance( newEventMessage ) ) {
            return newEventMessage;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Msg_ID;
    @Override
    public UniqueId getMsg_ID() throws XtumlException {
        checkLiving();
        return ref_Msg_ID;
    }
    @Override
    public void setMsg_ID(UniqueId ref_Msg_ID) throws XtumlException {
        checkLiving();
        if (ref_Msg_ID.inequality( this.ref_Msg_ID)) {
            final UniqueId oldValue = this.ref_Msg_ID;
            this.ref_Msg_ID = ref_Msg_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Msg_ID", oldValue, this.ref_Msg_ID));
        }
    }
    private UniqueId ref_SMevt_ID;
    @Override
    public UniqueId getSMevt_ID() throws XtumlException {
        checkLiving();
        return ref_SMevt_ID;
    }
    @Override
    public void setSMevt_ID(UniqueId ref_SMevt_ID) throws XtumlException {
        checkLiving();
        if (ref_SMevt_ID.inequality( this.ref_SMevt_ID)) {
            final UniqueId oldValue = this.ref_SMevt_ID;
            this.ref_SMevt_ID = ref_SMevt_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SMevt_ID", oldValue, this.ref_SMevt_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getMsg_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private StateMachineEvent R1009_generates_StateMachineEvent_inst;
    @Override
    public void setR1009_generates_StateMachineEvent( StateMachineEvent inst ) {
        R1009_generates_StateMachineEvent_inst = inst;
    }
    @Override
    public StateMachineEvent R1009_generates_StateMachineEvent() throws XtumlException {
        return R1009_generates_StateMachineEvent_inst;
    }
    private AsynchronousMessage R1019_is_a_AsynchronousMessage_inst;
    @Override
    public void setR1019_is_a_AsynchronousMessage( AsynchronousMessage inst ) {
        R1019_is_a_AsynchronousMessage_inst = inst;
    }
    @Override
    public AsynchronousMessage R1019_is_a_AsynchronousMessage() throws XtumlException {
        return R1019_is_a_AsynchronousMessage_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public EventMessage self() {
        return this;
    }

    @Override
    public EventMessage oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_EVENTMESSAGE;
    }

}

class EmptyEventMessage extends ModelInstance<EventMessage,Sql> implements EventMessage {

    // attributes
    public UniqueId getMsg_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setMsg_ID( UniqueId ref_Msg_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSMevt_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSMevt_ID( UniqueId ref_SMevt_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public StateMachineEvent R1009_generates_StateMachineEvent() {
        return StateMachineEventImpl.EMPTY_STATEMACHINEEVENT;
    }
    @Override
    public AsynchronousMessage R1019_is_a_AsynchronousMessage() {
        return AsynchronousMessageImpl.EMPTY_ASYNCHRONOUSMESSAGE;
    }


    @Override
    public String getKeyLetters() {
        return EventMessageImpl.KEY_LETTERS;
    }

    @Override
    public EventMessage self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public EventMessage oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return EventMessageImpl.EMPTY_EVENTMESSAGE;
    }

}
