package io.ciera.tool.sql.ooaofooa.invocation.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.ACT_SMT;
import io.ciera.tool.sql.ooaofooa.body.impl.ACT_SMTImpl;
import io.ciera.tool.sql.ooaofooa.invocation.OperationInvocation;
import io.ciera.tool.sql.ooaofooa.subsystem.O_TFR;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.O_TFRImpl;
import io.ciera.tool.sql.ooaofooa.value.V_PAR;
import io.ciera.tool.sql.ooaofooa.value.V_PARSet;
import io.ciera.tool.sql.ooaofooa.value.V_VAR;
import io.ciera.tool.sql.ooaofooa.value.impl.V_PARSetImpl;
import io.ciera.tool.sql.ooaofooa.value.impl.V_VARImpl;


public class OperationInvocationImpl extends ModelInstance<OperationInvocation,Sql> implements OperationInvocation {

    public static final String KEY_LETTERS = "ACT_TFM";
    public static final OperationInvocation EMPTY_OPERATIONINVOCATION = new EmptyOperationInvocation();

    private Sql context;

    // constructors
    private OperationInvocationImpl( Sql context ) {
        this.context = context;
        ref_Statement_ID = UniqueId.random();
        ref_Tfr_ID = UniqueId.random();
        ref_Var_ID = UniqueId.random();
        m_operationNameLineNumber = 0;
        m_operationNameColumn = 0;
        m_modelClassKeyLettersLineNumber = 0;
        m_modelClassKeyLettersColumn = 0;
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R627_takes_V_PAR_set = new V_PARSetImpl();
        R667_has_target_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
        R673_is_an_invocation_of_O_TFR_inst = O_TFRImpl.EMPTY_O_TFR;
    }

    private OperationInvocationImpl( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Tfr_ID, UniqueId ref_Var_ID, int m_operationNameLineNumber, int m_operationNameColumn, int m_modelClassKeyLettersLineNumber, int m_modelClassKeyLettersColumn ) {
        super(instanceId);
        this.context = context;
        this.ref_Statement_ID = ref_Statement_ID;
        this.ref_Tfr_ID = ref_Tfr_ID;
        this.ref_Var_ID = ref_Var_ID;
        this.m_operationNameLineNumber = m_operationNameLineNumber;
        this.m_operationNameColumn = m_operationNameColumn;
        this.m_modelClassKeyLettersLineNumber = m_modelClassKeyLettersLineNumber;
        this.m_modelClassKeyLettersColumn = m_modelClassKeyLettersColumn;
        R603_is_a_ACT_SMT_inst = ACT_SMTImpl.EMPTY_ACT_SMT;
        R627_takes_V_PAR_set = new V_PARSetImpl();
        R667_has_target_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
        R673_is_an_invocation_of_O_TFR_inst = O_TFRImpl.EMPTY_O_TFR;
    }

    public static OperationInvocation create( Sql context ) throws XtumlException {
        OperationInvocation newOperationInvocation = new OperationInvocationImpl( context );
        if ( context.addInstance( newOperationInvocation ) ) {
            newOperationInvocation.getRunContext().addChange(new InstanceCreatedDelta(newOperationInvocation, KEY_LETTERS));
            return newOperationInvocation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static OperationInvocation create( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Tfr_ID, UniqueId ref_Var_ID, int m_operationNameLineNumber, int m_operationNameColumn, int m_modelClassKeyLettersLineNumber, int m_modelClassKeyLettersColumn ) throws XtumlException {
        OperationInvocation newOperationInvocation = new OperationInvocationImpl( context, instanceId, ref_Statement_ID, ref_Tfr_ID, ref_Var_ID, m_operationNameLineNumber, m_operationNameColumn, m_modelClassKeyLettersLineNumber, m_modelClassKeyLettersColumn );
        if ( context.addInstance( newOperationInvocation ) ) {
            return newOperationInvocation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Statement_ID;
    @Override
    public UniqueId getStatement_ID() throws XtumlException {
        checkLiving();
        return ref_Statement_ID;
    }
    @Override
    public void setStatement_ID(UniqueId ref_Statement_ID) throws XtumlException {
        checkLiving();
        if (ref_Statement_ID.inequality( this.ref_Statement_ID)) {
            final UniqueId oldValue = this.ref_Statement_ID;
            this.ref_Statement_ID = ref_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Statement_ID", oldValue, this.ref_Statement_ID));
            if ( !R627_takes_V_PAR().isEmpty() ) R627_takes_V_PAR().setStatement_ID( ref_Statement_ID );
        }
    }
    private UniqueId ref_Tfr_ID;
    @Override
    public UniqueId getTfr_ID() throws XtumlException {
        checkLiving();
        return ref_Tfr_ID;
    }
    @Override
    public void setTfr_ID(UniqueId ref_Tfr_ID) throws XtumlException {
        checkLiving();
        if (ref_Tfr_ID.inequality( this.ref_Tfr_ID)) {
            final UniqueId oldValue = this.ref_Tfr_ID;
            this.ref_Tfr_ID = ref_Tfr_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Tfr_ID", oldValue, this.ref_Tfr_ID));
        }
    }
    private UniqueId ref_Var_ID;
    @Override
    public UniqueId getVar_ID() throws XtumlException {
        checkLiving();
        return ref_Var_ID;
    }
    @Override
    public void setVar_ID(UniqueId ref_Var_ID) throws XtumlException {
        checkLiving();
        if (ref_Var_ID.inequality( this.ref_Var_ID)) {
            final UniqueId oldValue = this.ref_Var_ID;
            this.ref_Var_ID = ref_Var_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Var_ID", oldValue, this.ref_Var_ID));
        }
    }
    private int m_operationNameLineNumber;
    @Override
    public int getOperationNameLineNumber() throws XtumlException {
        checkLiving();
        return m_operationNameLineNumber;
    }
    @Override
    public void setOperationNameLineNumber(int m_operationNameLineNumber) throws XtumlException {
        checkLiving();
        if (m_operationNameLineNumber != this.m_operationNameLineNumber) {
            final int oldValue = this.m_operationNameLineNumber;
            this.m_operationNameLineNumber = m_operationNameLineNumber;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_operationNameLineNumber", oldValue, this.m_operationNameLineNumber));
        }
    }
    private int m_operationNameColumn;
    @Override
    public void setOperationNameColumn(int m_operationNameColumn) throws XtumlException {
        checkLiving();
        if (m_operationNameColumn != this.m_operationNameColumn) {
            final int oldValue = this.m_operationNameColumn;
            this.m_operationNameColumn = m_operationNameColumn;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_operationNameColumn", oldValue, this.m_operationNameColumn));
        }
    }
    @Override
    public int getOperationNameColumn() throws XtumlException {
        checkLiving();
        return m_operationNameColumn;
    }
    private int m_modelClassKeyLettersLineNumber;
    @Override
    public int getModelClassKeyLettersLineNumber() throws XtumlException {
        checkLiving();
        return m_modelClassKeyLettersLineNumber;
    }
    @Override
    public void setModelClassKeyLettersLineNumber(int m_modelClassKeyLettersLineNumber) throws XtumlException {
        checkLiving();
        if (m_modelClassKeyLettersLineNumber != this.m_modelClassKeyLettersLineNumber) {
            final int oldValue = this.m_modelClassKeyLettersLineNumber;
            this.m_modelClassKeyLettersLineNumber = m_modelClassKeyLettersLineNumber;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_modelClassKeyLettersLineNumber", oldValue, this.m_modelClassKeyLettersLineNumber));
        }
    }
    private int m_modelClassKeyLettersColumn;
    @Override
    public void setModelClassKeyLettersColumn(int m_modelClassKeyLettersColumn) throws XtumlException {
        checkLiving();
        if (m_modelClassKeyLettersColumn != this.m_modelClassKeyLettersColumn) {
            final int oldValue = this.m_modelClassKeyLettersColumn;
            this.m_modelClassKeyLettersColumn = m_modelClassKeyLettersColumn;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_modelClassKeyLettersColumn", oldValue, this.m_modelClassKeyLettersColumn));
        }
    }
    @Override
    public int getModelClassKeyLettersColumn() throws XtumlException {
        checkLiving();
        return m_modelClassKeyLettersColumn;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStatement_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ACT_SMT R603_is_a_ACT_SMT_inst;
    @Override
    public void setR603_is_a_ACT_SMT( ACT_SMT inst ) {
        R603_is_a_ACT_SMT_inst = inst;
    }
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() throws XtumlException {
        return R603_is_a_ACT_SMT_inst;
    }
    private V_PARSet R627_takes_V_PAR_set;
    @Override
    public void addR627_takes_V_PAR( V_PAR inst ) {
        R627_takes_V_PAR_set.add(inst);
    }
    @Override
    public void removeR627_takes_V_PAR( V_PAR inst ) {
        R627_takes_V_PAR_set.remove(inst);
    }
    @Override
    public V_PARSet R627_takes_V_PAR() throws XtumlException {
        return R627_takes_V_PAR_set;
    }
    private V_VAR R667_has_target_V_VAR_inst;
    @Override
    public void setR667_has_target_V_VAR( V_VAR inst ) {
        R667_has_target_V_VAR_inst = inst;
    }
    @Override
    public V_VAR R667_has_target_V_VAR() throws XtumlException {
        return R667_has_target_V_VAR_inst;
    }
    private O_TFR R673_is_an_invocation_of_O_TFR_inst;
    @Override
    public void setR673_is_an_invocation_of_O_TFR( O_TFR inst ) {
        R673_is_an_invocation_of_O_TFR_inst = inst;
    }
    @Override
    public O_TFR R673_is_an_invocation_of_O_TFR() throws XtumlException {
        return R673_is_an_invocation_of_O_TFR_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public OperationInvocation self() {
        return this;
    }

    @Override
    public OperationInvocation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_OPERATIONINVOCATION;
    }

}

class EmptyOperationInvocation extends ModelInstance<OperationInvocation,Sql> implements OperationInvocation {

    // attributes
    public UniqueId getStatement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getTfr_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setTfr_ID( UniqueId ref_Tfr_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getVar_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setVar_ID( UniqueId ref_Var_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getOperationNameLineNumber() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setOperationNameLineNumber( int m_operationNameLineNumber ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setOperationNameColumn( int m_operationNameColumn ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getOperationNameColumn() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public int getModelClassKeyLettersLineNumber() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setModelClassKeyLettersLineNumber( int m_modelClassKeyLettersLineNumber ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setModelClassKeyLettersColumn( int m_modelClassKeyLettersColumn ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public int getModelClassKeyLettersColumn() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ACT_SMT R603_is_a_ACT_SMT() {
        return ACT_SMTImpl.EMPTY_ACT_SMT;
    }
    @Override
    public V_PARSet R627_takes_V_PAR() {
        return (new V_PARSetImpl());
    }
    @Override
    public V_VAR R667_has_target_V_VAR() {
        return V_VARImpl.EMPTY_V_VAR;
    }
    @Override
    public O_TFR R673_is_an_invocation_of_O_TFR() {
        return O_TFRImpl.EMPTY_O_TFR;
    }


    @Override
    public String getKeyLetters() {
        return OperationInvocationImpl.KEY_LETTERS;
    }

    @Override
    public OperationInvocation self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public OperationInvocation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return OperationInvocationImpl.EMPTY_OPERATIONINVOCATION;
    }

}
