package io.ciera.tool.sql.ooaofooa.interaction.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.interaction.Lifespan;
import io.ciera.tool.sql.ooaofooa.interaction.TimeSpan;
import io.ciera.tool.sql.ooaofooa.interaction.TimeSpanSet;
import io.ciera.tool.sql.ooaofooa.interaction.TimingMark;
import io.ciera.tool.sql.ooaofooa.interaction.impl.LifespanImpl;
import io.ciera.tool.sql.ooaofooa.interaction.impl.TimeSpanSetImpl;


public class TimingMarkImpl extends ModelInstance<TimingMark,Sql> implements TimingMark {

    public static final String KEY_LETTERS = "SQ_TM";
    public static final TimingMark EMPTY_TIMINGMARK = new EmptyTimingMark();

    private Sql context;

    // constructors
    private TimingMarkImpl( Sql context ) {
        this.context = context;
        m_Mark_ID = UniqueId.random();
        m_Name = "";
        ref_Part_ID = UniqueId.random();
        m_Descrip = "";
        R931_marks_a_point_in_time_Lifespan_inst = LifespanImpl.EMPTY_LIFESPAN;
        R941_defines_start_of_TimeSpan_set = new TimeSpanSetImpl();
        R942_defines_end_of_TimeSpan_set = new TimeSpanSetImpl();
    }

    private TimingMarkImpl( Sql context, UniqueId instanceId, UniqueId m_Mark_ID, String m_Name, UniqueId ref_Part_ID, String m_Descrip ) {
        super(instanceId);
        this.context = context;
        this.m_Mark_ID = m_Mark_ID;
        this.m_Name = m_Name;
        this.ref_Part_ID = ref_Part_ID;
        this.m_Descrip = m_Descrip;
        R931_marks_a_point_in_time_Lifespan_inst = LifespanImpl.EMPTY_LIFESPAN;
        R941_defines_start_of_TimeSpan_set = new TimeSpanSetImpl();
        R942_defines_end_of_TimeSpan_set = new TimeSpanSetImpl();
    }

    public static TimingMark create( Sql context ) throws XtumlException {
        TimingMark newTimingMark = new TimingMarkImpl( context );
        if ( context.addInstance( newTimingMark ) ) {
            newTimingMark.getRunContext().addChange(new InstanceCreatedDelta(newTimingMark, KEY_LETTERS));
            return newTimingMark;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static TimingMark create( Sql context, UniqueId instanceId, UniqueId m_Mark_ID, String m_Name, UniqueId ref_Part_ID, String m_Descrip ) throws XtumlException {
        TimingMark newTimingMark = new TimingMarkImpl( context, instanceId, m_Mark_ID, m_Name, ref_Part_ID, m_Descrip );
        if ( context.addInstance( newTimingMark ) ) {
            return newTimingMark;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_Mark_ID;
    @Override
    public void setMark_ID(UniqueId m_Mark_ID) throws XtumlException {
        checkLiving();
        if (m_Mark_ID.inequality( this.m_Mark_ID)) {
            final UniqueId oldValue = this.m_Mark_ID;
            this.m_Mark_ID = m_Mark_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Mark_ID", oldValue, this.m_Mark_ID));
            if ( !R942_defines_end_of_TimeSpan().isEmpty() ) R942_defines_end_of_TimeSpan().setMark_ID( m_Mark_ID );
            if ( !R941_defines_start_of_TimeSpan().isEmpty() ) R941_defines_start_of_TimeSpan().setPrev_Mark_ID( m_Mark_ID );
        }
    }
    @Override
    public UniqueId getMark_ID() throws XtumlException {
        checkLiving();
        return m_Mark_ID;
    }
    private String m_Name;
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    private UniqueId ref_Part_ID;
    @Override
    public UniqueId getPart_ID() throws XtumlException {
        checkLiving();
        return ref_Part_ID;
    }
    @Override
    public void setPart_ID(UniqueId ref_Part_ID) throws XtumlException {
        checkLiving();
        if (ref_Part_ID.inequality( this.ref_Part_ID)) {
            final UniqueId oldValue = this.ref_Part_ID;
            this.ref_Part_ID = ref_Part_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Part_ID", oldValue, this.ref_Part_ID));
        }
    }
    private String m_Descrip;
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getMark_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Lifespan R931_marks_a_point_in_time_Lifespan_inst;
    @Override
    public void setR931_marks_a_point_in_time_Lifespan( Lifespan inst ) {
        R931_marks_a_point_in_time_Lifespan_inst = inst;
    }
    @Override
    public Lifespan R931_marks_a_point_in_time_Lifespan() throws XtumlException {
        return R931_marks_a_point_in_time_Lifespan_inst;
    }
    private TimeSpanSet R941_defines_start_of_TimeSpan_set;
    @Override
    public void addR941_defines_start_of_TimeSpan( TimeSpan inst ) {
        R941_defines_start_of_TimeSpan_set.add(inst);
    }
    @Override
    public void removeR941_defines_start_of_TimeSpan( TimeSpan inst ) {
        R941_defines_start_of_TimeSpan_set.remove(inst);
    }
    @Override
    public TimeSpanSet R941_defines_start_of_TimeSpan() throws XtumlException {
        return R941_defines_start_of_TimeSpan_set;
    }
    private TimeSpanSet R942_defines_end_of_TimeSpan_set;
    @Override
    public void addR942_defines_end_of_TimeSpan( TimeSpan inst ) {
        R942_defines_end_of_TimeSpan_set.add(inst);
    }
    @Override
    public void removeR942_defines_end_of_TimeSpan( TimeSpan inst ) {
        R942_defines_end_of_TimeSpan_set.remove(inst);
    }
    @Override
    public TimeSpanSet R942_defines_end_of_TimeSpan() throws XtumlException {
        return R942_defines_end_of_TimeSpan_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public TimingMark self() {
        return this;
    }

    @Override
    public TimingMark oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_TIMINGMARK;
    }

}

class EmptyTimingMark extends ModelInstance<TimingMark,Sql> implements TimingMark {

    // attributes
    public void setMark_ID( UniqueId m_Mark_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getMark_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getPart_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPart_ID( UniqueId ref_Part_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Lifespan R931_marks_a_point_in_time_Lifespan() {
        return LifespanImpl.EMPTY_LIFESPAN;
    }
    @Override
    public TimeSpanSet R941_defines_start_of_TimeSpan() {
        return (new TimeSpanSetImpl());
    }
    @Override
    public TimeSpanSet R942_defines_end_of_TimeSpan() {
        return (new TimeSpanSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return TimingMarkImpl.KEY_LETTERS;
    }

    @Override
    public TimingMark self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public TimingMark oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return TimingMarkImpl.EMPTY_TIMINGMARK;
    }

}
