package io.ciera.tool.sql.ooaofooa.interaction.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.ooaofooa.interaction.TimeSpan;
import io.ciera.tool.sql.ooaofooa.interaction.TimeSpanSet;
import io.ciera.tool.sql.ooaofooa.interaction.TimingMarkSet;
import io.ciera.tool.sql.ooaofooa.interaction.impl.TimingMarkSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class TimeSpanSetImpl extends InstanceSet<TimeSpanSet,TimeSpan> implements TimeSpanSet {

    public TimeSpanSetImpl() {
    }

    public TimeSpanSetImpl(Comparator<? super TimeSpan> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setName( String m_Name ) throws XtumlException {
        for ( TimeSpan timespan : this ) timespan.setName( m_Name );
    }
    @Override
    public void setPrev_Mark_ID( UniqueId ref_Prev_Mark_ID ) throws XtumlException {
        for ( TimeSpan timespan : this ) timespan.setPrev_Mark_ID( ref_Prev_Mark_ID );
    }
    @Override
    public void setSpan_ID( UniqueId m_Span_ID ) throws XtumlException {
        for ( TimeSpan timespan : this ) timespan.setSpan_ID( m_Span_ID );
    }
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        for ( TimeSpan timespan : this ) timespan.setDescrip( m_Descrip );
    }
    @Override
    public void setMark_ID( UniqueId ref_Mark_ID ) throws XtumlException {
        for ( TimeSpan timespan : this ) timespan.setMark_ID( ref_Mark_ID );
    }


    // selections
    @Override
    public TimingMarkSet R941_span_begins_at_TimingMark() throws XtumlException {
        TimingMarkSet timingmarkset = new TimingMarkSetImpl();
        for ( TimeSpan timespan : this ) timingmarkset.add( timespan.R941_span_begins_at_TimingMark() );
        return timingmarkset;
    }
    @Override
    public TimingMarkSet R942_span_ends_at_TimingMark() throws XtumlException {
        TimingMarkSet timingmarkset = new TimingMarkSetImpl();
        for ( TimeSpan timespan : this ) timingmarkset.add( timespan.R942_span_ends_at_TimingMark() );
        return timingmarkset;
    }


    @Override
    public TimeSpan nullElement() {
        return TimeSpanImpl.EMPTY_TIMESPAN;
    }

    @Override
    public TimeSpanSet emptySet() {
      return new TimeSpanSetImpl();
    }

    @Override
    public TimeSpanSet emptySet(Comparator<? super TimeSpan> comp) {
      return new TimeSpanSetImpl(comp);
    }

    @Override
    public List<TimeSpan> elements() {
        TimeSpan[] elements = toArray(new TimeSpan[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
