package io.ciera.tool.sql.ooaofooa.interaction.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.interaction.ClassInstanceParticipant;
import io.ciera.tool.sql.ooaofooa.interaction.InstanceAttributeValue;
import io.ciera.tool.sql.ooaofooa.interaction.InstanceAttributeValueSet;
import io.ciera.tool.sql.ooaofooa.interaction.InteractionParticipant;
import io.ciera.tool.sql.ooaofooa.interaction.impl.InstanceAttributeValueSetImpl;
import io.ciera.tool.sql.ooaofooa.interaction.impl.InteractionParticipantImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.ModelClass;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.ModelClassImpl;


public class ClassInstanceParticipantImpl extends ModelInstance<ClassInstanceParticipant,Sql> implements ClassInstanceParticipant {

    public static final String KEY_LETTERS = "SQ_CIP";
    public static final ClassInstanceParticipant EMPTY_CLASSINSTANCEPARTICIPANT = new EmptyClassInstanceParticipant();

    private Sql context;

    // constructors
    private ClassInstanceParticipantImpl( Sql context ) {
        this.context = context;
        ref_Part_ID = UniqueId.random();
        ref_Obj_ID = UniqueId.random();
        m_Name = "";
        m_InformalClassName = "";
        m_Label = "";
        m_Descrip = "";
        m_isFormal = false;
        R930_is_a_InteractionParticipant_inst = InteractionParticipantImpl.EMPTY_INTERACTIONPARTICIPANT;
        R934_represents_ModelClass_inst = ModelClassImpl.EMPTY_MODELCLASS;
        R936_contains_informal_InstanceAttributeValue_set = new InstanceAttributeValueSetImpl();
        R937_contains_formal_InstanceAttributeValue_set = new InstanceAttributeValueSetImpl();
    }

    private ClassInstanceParticipantImpl( Sql context, UniqueId instanceId, UniqueId ref_Part_ID, UniqueId ref_Obj_ID, String m_Name, String m_InformalClassName, String m_Label, String m_Descrip, boolean m_isFormal ) {
        super(instanceId);
        this.context = context;
        this.ref_Part_ID = ref_Part_ID;
        this.ref_Obj_ID = ref_Obj_ID;
        this.m_Name = m_Name;
        this.m_InformalClassName = m_InformalClassName;
        this.m_Label = m_Label;
        this.m_Descrip = m_Descrip;
        this.m_isFormal = m_isFormal;
        R930_is_a_InteractionParticipant_inst = InteractionParticipantImpl.EMPTY_INTERACTIONPARTICIPANT;
        R934_represents_ModelClass_inst = ModelClassImpl.EMPTY_MODELCLASS;
        R936_contains_informal_InstanceAttributeValue_set = new InstanceAttributeValueSetImpl();
        R937_contains_formal_InstanceAttributeValue_set = new InstanceAttributeValueSetImpl();
    }

    public static ClassInstanceParticipant create( Sql context ) throws XtumlException {
        ClassInstanceParticipant newClassInstanceParticipant = new ClassInstanceParticipantImpl( context );
        if ( context.addInstance( newClassInstanceParticipant ) ) {
            newClassInstanceParticipant.getRunContext().addChange(new InstanceCreatedDelta(newClassInstanceParticipant, KEY_LETTERS));
            return newClassInstanceParticipant;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ClassInstanceParticipant create( Sql context, UniqueId instanceId, UniqueId ref_Part_ID, UniqueId ref_Obj_ID, String m_Name, String m_InformalClassName, String m_Label, String m_Descrip, boolean m_isFormal ) throws XtumlException {
        ClassInstanceParticipant newClassInstanceParticipant = new ClassInstanceParticipantImpl( context, instanceId, ref_Part_ID, ref_Obj_ID, m_Name, m_InformalClassName, m_Label, m_Descrip, m_isFormal );
        if ( context.addInstance( newClassInstanceParticipant ) ) {
            return newClassInstanceParticipant;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Part_ID;
    @Override
    public UniqueId getPart_ID() throws XtumlException {
        checkLiving();
        return ref_Part_ID;
    }
    @Override
    public void setPart_ID(UniqueId ref_Part_ID) throws XtumlException {
        checkLiving();
        if (ref_Part_ID.inequality( this.ref_Part_ID)) {
            final UniqueId oldValue = this.ref_Part_ID;
            this.ref_Part_ID = ref_Part_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Part_ID", oldValue, this.ref_Part_ID));
            if ( !R937_contains_formal_InstanceAttributeValue().isEmpty() ) R937_contains_formal_InstanceAttributeValue().setFormal_Part_ID( ref_Part_ID );
            if ( !R936_contains_informal_InstanceAttributeValue().isEmpty() ) R936_contains_informal_InstanceAttributeValue().setInformal_Part_ID( ref_Part_ID );
        }
    }
    private UniqueId ref_Obj_ID;
    @Override
    public void setObj_ID(UniqueId ref_Obj_ID) throws XtumlException {
        checkLiving();
        if (ref_Obj_ID.inequality( this.ref_Obj_ID)) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
        }
    }
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
        return ref_Obj_ID;
    }
    private String m_Name;
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    private String m_InformalClassName;
    @Override
    public String getInformalClassName() throws XtumlException {
        checkLiving();
        return m_InformalClassName;
    }
    @Override
    public void setInformalClassName(String m_InformalClassName) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_InformalClassName, this.m_InformalClassName)) {
            final String oldValue = this.m_InformalClassName;
            this.m_InformalClassName = m_InformalClassName;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_InformalClassName", oldValue, this.m_InformalClassName));
        }
    }
    private String m_Label;
    @Override
    public String getLabel() throws XtumlException {
        checkLiving();
        return m_Label;
    }
    @Override
    public void setLabel(String m_Label) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Label, this.m_Label)) {
            final String oldValue = this.m_Label;
            this.m_Label = m_Label;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Label", oldValue, this.m_Label));
        }
    }
    private String m_Descrip;
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    private boolean m_isFormal;
    @Override
    public void setIsFormal(boolean m_isFormal) throws XtumlException {
        checkLiving();
        if (m_isFormal != this.m_isFormal) {
            final boolean oldValue = this.m_isFormal;
            this.m_isFormal = m_isFormal;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_isFormal", oldValue, this.m_isFormal));
        }
    }
    @Override
    public boolean getIsFormal() throws XtumlException {
        checkLiving();
        return m_isFormal;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getPart_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private InteractionParticipant R930_is_a_InteractionParticipant_inst;
    @Override
    public void setR930_is_a_InteractionParticipant( InteractionParticipant inst ) {
        R930_is_a_InteractionParticipant_inst = inst;
    }
    @Override
    public InteractionParticipant R930_is_a_InteractionParticipant() throws XtumlException {
        return R930_is_a_InteractionParticipant_inst;
    }
    private ModelClass R934_represents_ModelClass_inst;
    @Override
    public void setR934_represents_ModelClass( ModelClass inst ) {
        R934_represents_ModelClass_inst = inst;
    }
    @Override
    public ModelClass R934_represents_ModelClass() throws XtumlException {
        return R934_represents_ModelClass_inst;
    }
    private InstanceAttributeValueSet R936_contains_informal_InstanceAttributeValue_set;
    @Override
    public void addR936_contains_informal_InstanceAttributeValue( InstanceAttributeValue inst ) {
        R936_contains_informal_InstanceAttributeValue_set.add(inst);
    }
    @Override
    public void removeR936_contains_informal_InstanceAttributeValue( InstanceAttributeValue inst ) {
        R936_contains_informal_InstanceAttributeValue_set.remove(inst);
    }
    @Override
    public InstanceAttributeValueSet R936_contains_informal_InstanceAttributeValue() throws XtumlException {
        return R936_contains_informal_InstanceAttributeValue_set;
    }
    private InstanceAttributeValueSet R937_contains_formal_InstanceAttributeValue_set;
    @Override
    public void addR937_contains_formal_InstanceAttributeValue( InstanceAttributeValue inst ) {
        R937_contains_formal_InstanceAttributeValue_set.add(inst);
    }
    @Override
    public void removeR937_contains_formal_InstanceAttributeValue( InstanceAttributeValue inst ) {
        R937_contains_formal_InstanceAttributeValue_set.remove(inst);
    }
    @Override
    public InstanceAttributeValueSet R937_contains_formal_InstanceAttributeValue() throws XtumlException {
        return R937_contains_formal_InstanceAttributeValue_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ClassInstanceParticipant self() {
        return this;
    }

    @Override
    public ClassInstanceParticipant oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_CLASSINSTANCEPARTICIPANT;
    }

}

class EmptyClassInstanceParticipant extends ModelInstance<ClassInstanceParticipant,Sql> implements ClassInstanceParticipant {

    // attributes
    public UniqueId getPart_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPart_ID( UniqueId ref_Part_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getInformalClassName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setInformalClassName( String m_InformalClassName ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLabel() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLabel( String m_Label ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setIsFormal( boolean m_isFormal ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getIsFormal() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public InteractionParticipant R930_is_a_InteractionParticipant() {
        return InteractionParticipantImpl.EMPTY_INTERACTIONPARTICIPANT;
    }
    @Override
    public ModelClass R934_represents_ModelClass() {
        return ModelClassImpl.EMPTY_MODELCLASS;
    }
    @Override
    public InstanceAttributeValueSet R936_contains_informal_InstanceAttributeValue() {
        return (new InstanceAttributeValueSetImpl());
    }
    @Override
    public InstanceAttributeValueSet R937_contains_formal_InstanceAttributeValue() {
        return (new InstanceAttributeValueSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return ClassInstanceParticipantImpl.KEY_LETTERS;
    }

    @Override
    public ClassInstanceParticipant self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ClassInstanceParticipant oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ClassInstanceParticipantImpl.EMPTY_CLASSINSTANCEPARTICIPANT;
    }

}
