package io.ciera.tool.sql.ooaofooa.instance.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.instance.ComponentInstance;
import io.ciera.tool.sql.ooaofooa.instance.I_INS;
import io.ciera.tool.sql.ooaofooa.instance.Monitor;
import io.ciera.tool.sql.ooaofooa.instance.impl.ComponentInstanceImpl;
import io.ciera.tool.sql.ooaofooa.instance.impl.I_INSImpl;


public class MonitorImpl extends ModelInstance<Monitor,Sql> implements Monitor {

    public static final String KEY_LETTERS = "I_MON";
    public static final Monitor EMPTY_MONITOR = new EmptyMonitor();

    private Sql context;

    // constructors
    private MonitorImpl( Sql context ) {
        this.context = context;
        ref_Execution_Engine_ID = UniqueId.random();
        ref_Inst_ID = UniqueId.random();
        m_enabled = false;
        R2949_monitored_by_ComponentInstance_inst = ComponentInstanceImpl.EMPTY_COMPONENTINSTANCE;
        R2949_monitors_I_INS_inst = I_INSImpl.EMPTY_I_INS;
    }

    private MonitorImpl( Sql context, UniqueId instanceId, UniqueId ref_Execution_Engine_ID, UniqueId ref_Inst_ID, boolean m_enabled ) {
        super(instanceId);
        this.context = context;
        this.ref_Execution_Engine_ID = ref_Execution_Engine_ID;
        this.ref_Inst_ID = ref_Inst_ID;
        this.m_enabled = m_enabled;
        R2949_monitored_by_ComponentInstance_inst = ComponentInstanceImpl.EMPTY_COMPONENTINSTANCE;
        R2949_monitors_I_INS_inst = I_INSImpl.EMPTY_I_INS;
    }

    public static Monitor create( Sql context ) throws XtumlException {
        Monitor newMonitor = new MonitorImpl( context );
        if ( context.addInstance( newMonitor ) ) {
            newMonitor.getRunContext().addChange(new InstanceCreatedDelta(newMonitor, KEY_LETTERS));
            return newMonitor;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Monitor create( Sql context, UniqueId instanceId, UniqueId ref_Execution_Engine_ID, UniqueId ref_Inst_ID, boolean m_enabled ) throws XtumlException {
        Monitor newMonitor = new MonitorImpl( context, instanceId, ref_Execution_Engine_ID, ref_Inst_ID, m_enabled );
        if ( context.addInstance( newMonitor ) ) {
            return newMonitor;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Execution_Engine_ID;
    @Override
    public UniqueId getExecution_Engine_ID() throws XtumlException {
        checkLiving();
        return ref_Execution_Engine_ID;
    }
    @Override
    public void setExecution_Engine_ID(UniqueId ref_Execution_Engine_ID) throws XtumlException {
        checkLiving();
        if (ref_Execution_Engine_ID.inequality( this.ref_Execution_Engine_ID)) {
            final UniqueId oldValue = this.ref_Execution_Engine_ID;
            this.ref_Execution_Engine_ID = ref_Execution_Engine_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Execution_Engine_ID", oldValue, this.ref_Execution_Engine_ID));
        }
    }
    private UniqueId ref_Inst_ID;
    @Override
    public void setInst_ID(UniqueId ref_Inst_ID) throws XtumlException {
        checkLiving();
        if (ref_Inst_ID.inequality( this.ref_Inst_ID)) {
            final UniqueId oldValue = this.ref_Inst_ID;
            this.ref_Inst_ID = ref_Inst_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Inst_ID", oldValue, this.ref_Inst_ID));
        }
    }
    @Override
    public UniqueId getInst_ID() throws XtumlException {
        checkLiving();
        return ref_Inst_ID;
    }
    private boolean m_enabled;
    @Override
    public boolean getEnabled() throws XtumlException {
        checkLiving();
        return m_enabled;
    }
    @Override
    public void setEnabled(boolean m_enabled) throws XtumlException {
        checkLiving();
        if (m_enabled != this.m_enabled) {
            final boolean oldValue = this.m_enabled;
            this.m_enabled = m_enabled;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_enabled", oldValue, this.m_enabled));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getExecution_Engine_ID(), getInst_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ComponentInstance R2949_monitored_by_ComponentInstance_inst;
    @Override
    public void setR2949_monitored_by_ComponentInstance( ComponentInstance inst ) {
        R2949_monitored_by_ComponentInstance_inst = inst;
    }
    @Override
    public ComponentInstance R2949_monitored_by_ComponentInstance() throws XtumlException {
        return R2949_monitored_by_ComponentInstance_inst;
    }
    private I_INS R2949_monitors_I_INS_inst;
    @Override
    public void setR2949_monitors_I_INS( I_INS inst ) {
        R2949_monitors_I_INS_inst = inst;
    }
    @Override
    public I_INS R2949_monitors_I_INS() throws XtumlException {
        return R2949_monitors_I_INS_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Monitor self() {
        return this;
    }

    @Override
    public Monitor oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_MONITOR;
    }

}

class EmptyMonitor extends ModelInstance<Monitor,Sql> implements Monitor {

    // attributes
    public UniqueId getExecution_Engine_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setExecution_Engine_ID( UniqueId ref_Execution_Engine_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setInst_ID( UniqueId ref_Inst_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getInst_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public boolean getEnabled() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setEnabled( boolean m_enabled ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ComponentInstance R2949_monitored_by_ComponentInstance() {
        return ComponentInstanceImpl.EMPTY_COMPONENTINSTANCE;
    }
    @Override
    public I_INS R2949_monitors_I_INS() {
        return I_INSImpl.EMPTY_I_INS;
    }


    @Override
    public String getKeyLetters() {
        return MonitorImpl.KEY_LETTERS;
    }

    @Override
    public Monitor self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Monitor oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return MonitorImpl.EMPTY_MONITOR;
    }

}
