package io.ciera.tool.sql.ooaofooa.event.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.event.E_GEN;
import io.ciera.tool.sql.ooaofooa.event.GenerateEventStatement;
import io.ciera.tool.sql.ooaofooa.event.GenerateSMEventStatement;
import io.ciera.tool.sql.ooaofooa.event.GenerateToClass;
import io.ciera.tool.sql.ooaofooa.event.GenerateToCreator;
import io.ciera.tool.sql.ooaofooa.event.impl.E_GENImpl;
import io.ciera.tool.sql.ooaofooa.event.impl.GenerateEventStatementImpl;
import io.ciera.tool.sql.ooaofooa.event.impl.GenerateToClassImpl;
import io.ciera.tool.sql.ooaofooa.event.impl.GenerateToCreatorImpl;
import io.ciera.tool.sql.ooaofooa.statemachine.StateMachineEvent;
import io.ciera.tool.sql.ooaofooa.statemachine.impl.StateMachineEventImpl;


public class GenerateSMEventStatementImpl extends ModelInstance<GenerateSMEventStatement,Sql> implements GenerateSMEventStatement {

    public static final String KEY_LETTERS = "E_GSME";
    public static final GenerateSMEventStatement EMPTY_GENERATESMEVENTSTATEMENT = new EmptyGenerateSMEventStatement();

    private Sql context;

    // constructors
    private GenerateSMEventStatementImpl( Sql context ) {
        this.context = context;
        ref_Statement_ID = UniqueId.random();
        ref_SMevt_ID = UniqueId.random();
        R703_is_a_GenerateEventStatement_inst = GenerateEventStatementImpl.EMPTY_GENERATEEVENTSTATEMENT;
        R705_is_a_E_GEN_inst = E_GENImpl.EMPTY_E_GEN;
        R705_is_a_GenerateToClass_inst = GenerateToClassImpl.EMPTY_GENERATETOCLASS;
        R705_is_a_GenerateToCreator_inst = GenerateToCreatorImpl.EMPTY_GENERATETOCREATOR;
        R707_generates_StateMachineEvent_inst = StateMachineEventImpl.EMPTY_STATEMACHINEEVENT;
    }

    private GenerateSMEventStatementImpl( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_SMevt_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Statement_ID = ref_Statement_ID;
        this.ref_SMevt_ID = ref_SMevt_ID;
        R703_is_a_GenerateEventStatement_inst = GenerateEventStatementImpl.EMPTY_GENERATEEVENTSTATEMENT;
        R705_is_a_E_GEN_inst = E_GENImpl.EMPTY_E_GEN;
        R705_is_a_GenerateToClass_inst = GenerateToClassImpl.EMPTY_GENERATETOCLASS;
        R705_is_a_GenerateToCreator_inst = GenerateToCreatorImpl.EMPTY_GENERATETOCREATOR;
        R707_generates_StateMachineEvent_inst = StateMachineEventImpl.EMPTY_STATEMACHINEEVENT;
    }

    public static GenerateSMEventStatement create( Sql context ) throws XtumlException {
        GenerateSMEventStatement newGenerateSMEventStatement = new GenerateSMEventStatementImpl( context );
        if ( context.addInstance( newGenerateSMEventStatement ) ) {
            newGenerateSMEventStatement.getRunContext().addChange(new InstanceCreatedDelta(newGenerateSMEventStatement, KEY_LETTERS));
            return newGenerateSMEventStatement;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static GenerateSMEventStatement create( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_SMevt_ID ) throws XtumlException {
        GenerateSMEventStatement newGenerateSMEventStatement = new GenerateSMEventStatementImpl( context, instanceId, ref_Statement_ID, ref_SMevt_ID );
        if ( context.addInstance( newGenerateSMEventStatement ) ) {
            return newGenerateSMEventStatement;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Statement_ID;
    @Override
    public UniqueId getStatement_ID() throws XtumlException {
        checkLiving();
        return ref_Statement_ID;
    }
    @Override
    public void setStatement_ID(UniqueId ref_Statement_ID) throws XtumlException {
        checkLiving();
        if (ref_Statement_ID.inequality( this.ref_Statement_ID)) {
            final UniqueId oldValue = this.ref_Statement_ID;
            this.ref_Statement_ID = ref_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Statement_ID", oldValue, this.ref_Statement_ID));
            if ( !R705_is_a_GenerateToCreator().isEmpty() ) R705_is_a_GenerateToCreator().setStatement_ID( ref_Statement_ID );
            if ( !R705_is_a_GenerateToClass().isEmpty() ) R705_is_a_GenerateToClass().setStatement_ID( ref_Statement_ID );
            if ( !R705_is_a_E_GEN().isEmpty() ) R705_is_a_E_GEN().setStatement_ID( ref_Statement_ID );
        }
    }
    private UniqueId ref_SMevt_ID;
    @Override
    public UniqueId getSMevt_ID() throws XtumlException {
        checkLiving();
        return ref_SMevt_ID;
    }
    @Override
    public void setSMevt_ID(UniqueId ref_SMevt_ID) throws XtumlException {
        checkLiving();
        if (ref_SMevt_ID.inequality( this.ref_SMevt_ID)) {
            final UniqueId oldValue = this.ref_SMevt_ID;
            this.ref_SMevt_ID = ref_SMevt_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_SMevt_ID", oldValue, this.ref_SMevt_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStatement_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private GenerateEventStatement R703_is_a_GenerateEventStatement_inst;
    @Override
    public void setR703_is_a_GenerateEventStatement( GenerateEventStatement inst ) {
        R703_is_a_GenerateEventStatement_inst = inst;
    }
    @Override
    public GenerateEventStatement R703_is_a_GenerateEventStatement() throws XtumlException {
        return R703_is_a_GenerateEventStatement_inst;
    }
    private E_GEN R705_is_a_E_GEN_inst;
    @Override
    public void setR705_is_a_E_GEN( E_GEN inst ) {
        R705_is_a_E_GEN_inst = inst;
    }
    @Override
    public E_GEN R705_is_a_E_GEN() throws XtumlException {
        return R705_is_a_E_GEN_inst;
    }
    private GenerateToClass R705_is_a_GenerateToClass_inst;
    @Override
    public void setR705_is_a_GenerateToClass( GenerateToClass inst ) {
        R705_is_a_GenerateToClass_inst = inst;
    }
    @Override
    public GenerateToClass R705_is_a_GenerateToClass() throws XtumlException {
        return R705_is_a_GenerateToClass_inst;
    }
    private GenerateToCreator R705_is_a_GenerateToCreator_inst;
    @Override
    public void setR705_is_a_GenerateToCreator( GenerateToCreator inst ) {
        R705_is_a_GenerateToCreator_inst = inst;
    }
    @Override
    public GenerateToCreator R705_is_a_GenerateToCreator() throws XtumlException {
        return R705_is_a_GenerateToCreator_inst;
    }
    private StateMachineEvent R707_generates_StateMachineEvent_inst;
    @Override
    public void setR707_generates_StateMachineEvent( StateMachineEvent inst ) {
        R707_generates_StateMachineEvent_inst = inst;
    }
    @Override
    public StateMachineEvent R707_generates_StateMachineEvent() throws XtumlException {
        return R707_generates_StateMachineEvent_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public GenerateSMEventStatement self() {
        return this;
    }

    @Override
    public GenerateSMEventStatement oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_GENERATESMEVENTSTATEMENT;
    }

}

class EmptyGenerateSMEventStatement extends ModelInstance<GenerateSMEventStatement,Sql> implements GenerateSMEventStatement {

    // attributes
    public UniqueId getStatement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSMevt_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSMevt_ID( UniqueId ref_SMevt_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public GenerateEventStatement R703_is_a_GenerateEventStatement() {
        return GenerateEventStatementImpl.EMPTY_GENERATEEVENTSTATEMENT;
    }
    @Override
    public E_GEN R705_is_a_E_GEN() {
        return E_GENImpl.EMPTY_E_GEN;
    }
    @Override
    public GenerateToClass R705_is_a_GenerateToClass() {
        return GenerateToClassImpl.EMPTY_GENERATETOCLASS;
    }
    @Override
    public GenerateToCreator R705_is_a_GenerateToCreator() {
        return GenerateToCreatorImpl.EMPTY_GENERATETOCREATOR;
    }
    @Override
    public StateMachineEvent R707_generates_StateMachineEvent() {
        return StateMachineEventImpl.EMPTY_STATEMACHINEEVENT;
    }


    @Override
    public String getKeyLetters() {
        return GenerateSMEventStatementImpl.KEY_LETTERS;
    }

    @Override
    public GenerateSMEventStatement self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public GenerateSMEventStatement oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return GenerateSMEventStatementImpl.EMPTY_GENERATESMEVENTSTATEMENT;
    }

}
