package io.ciera.tool.sql.ooaofooa.event.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.event.EventSpecificationStatement;
import io.ciera.tool.sql.ooaofooa.event.GenerateEventStatement;
import io.ciera.tool.sql.ooaofooa.event.GenerateSMEventStatement;
import io.ciera.tool.sql.ooaofooa.event.impl.EventSpecificationStatementImpl;
import io.ciera.tool.sql.ooaofooa.event.impl.GenerateSMEventStatementImpl;


public class GenerateEventStatementImpl extends ModelInstance<GenerateEventStatement,Sql> implements GenerateEventStatement {

    public static final String KEY_LETTERS = "E_GES";
    public static final GenerateEventStatement EMPTY_GENERATEEVENTSTATEMENT = new EmptyGenerateEventStatement();

    private Sql context;

    // constructors
    private GenerateEventStatementImpl( Sql context ) {
        this.context = context;
        ref_Statement_ID = UniqueId.random();
        R701_is_a_EventSpecificationStatement_inst = EventSpecificationStatementImpl.EMPTY_EVENTSPECIFICATIONSTATEMENT;
        R703_is_a_GenerateSMEventStatement_inst = GenerateSMEventStatementImpl.EMPTY_GENERATESMEVENTSTATEMENT;
    }

    private GenerateEventStatementImpl( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Statement_ID = ref_Statement_ID;
        R701_is_a_EventSpecificationStatement_inst = EventSpecificationStatementImpl.EMPTY_EVENTSPECIFICATIONSTATEMENT;
        R703_is_a_GenerateSMEventStatement_inst = GenerateSMEventStatementImpl.EMPTY_GENERATESMEVENTSTATEMENT;
    }

    public static GenerateEventStatement create( Sql context ) throws XtumlException {
        GenerateEventStatement newGenerateEventStatement = new GenerateEventStatementImpl( context );
        if ( context.addInstance( newGenerateEventStatement ) ) {
            newGenerateEventStatement.getRunContext().addChange(new InstanceCreatedDelta(newGenerateEventStatement, KEY_LETTERS));
            return newGenerateEventStatement;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static GenerateEventStatement create( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID ) throws XtumlException {
        GenerateEventStatement newGenerateEventStatement = new GenerateEventStatementImpl( context, instanceId, ref_Statement_ID );
        if ( context.addInstance( newGenerateEventStatement ) ) {
            return newGenerateEventStatement;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Statement_ID;
    @Override
    public void setStatement_ID(UniqueId ref_Statement_ID) throws XtumlException {
        checkLiving();
        if (ref_Statement_ID.inequality( this.ref_Statement_ID)) {
            final UniqueId oldValue = this.ref_Statement_ID;
            this.ref_Statement_ID = ref_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Statement_ID", oldValue, this.ref_Statement_ID));
            if ( !R703_is_a_GenerateSMEventStatement().isEmpty() ) R703_is_a_GenerateSMEventStatement().setStatement_ID( ref_Statement_ID );
        }
    }
    @Override
    public UniqueId getStatement_ID() throws XtumlException {
        checkLiving();
        return ref_Statement_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStatement_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private EventSpecificationStatement R701_is_a_EventSpecificationStatement_inst;
    @Override
    public void setR701_is_a_EventSpecificationStatement( EventSpecificationStatement inst ) {
        R701_is_a_EventSpecificationStatement_inst = inst;
    }
    @Override
    public EventSpecificationStatement R701_is_a_EventSpecificationStatement() throws XtumlException {
        return R701_is_a_EventSpecificationStatement_inst;
    }
    private GenerateSMEventStatement R703_is_a_GenerateSMEventStatement_inst;
    @Override
    public void setR703_is_a_GenerateSMEventStatement( GenerateSMEventStatement inst ) {
        R703_is_a_GenerateSMEventStatement_inst = inst;
    }
    @Override
    public GenerateSMEventStatement R703_is_a_GenerateSMEventStatement() throws XtumlException {
        return R703_is_a_GenerateSMEventStatement_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public GenerateEventStatement self() {
        return this;
    }

    @Override
    public GenerateEventStatement oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_GENERATEEVENTSTATEMENT;
    }

}

class EmptyGenerateEventStatement extends ModelInstance<GenerateEventStatement,Sql> implements GenerateEventStatement {

    // attributes
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getStatement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public EventSpecificationStatement R701_is_a_EventSpecificationStatement() {
        return EventSpecificationStatementImpl.EMPTY_EVENTSPECIFICATIONSTATEMENT;
    }
    @Override
    public GenerateSMEventStatement R703_is_a_GenerateSMEventStatement() {
        return GenerateSMEventStatementImpl.EMPTY_GENERATESMEVENTSTATEMENT;
    }


    @Override
    public String getKeyLetters() {
        return GenerateEventStatementImpl.KEY_LETTERS;
    }

    @Override
    public GenerateEventStatement self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public GenerateEventStatement oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return GenerateEventStatementImpl.EMPTY_GENERATEEVENTSTATEMENT;
    }

}
