package io.ciera.tool.sql.ooaofooa.event.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.event.E_GEN;
import io.ciera.tool.sql.ooaofooa.event.GenerateSMEventStatement;
import io.ciera.tool.sql.ooaofooa.event.impl.GenerateSMEventStatementImpl;
import io.ciera.tool.sql.ooaofooa.value.V_VAR;
import io.ciera.tool.sql.ooaofooa.value.impl.V_VARImpl;


public class E_GENImpl extends ModelInstance<E_GEN,Sql> implements E_GEN {

    public static final String KEY_LETTERS = "E_GEN";
    public static final E_GEN EMPTY_E_GEN = new EmptyE_GEN();

    private Sql context;

    // constructors
    private E_GENImpl( Sql context ) {
        this.context = context;
        ref_Statement_ID = UniqueId.random();
        ref_Var_ID = UniqueId.random();
        R705_is_a_GenerateSMEventStatement_inst = GenerateSMEventStatementImpl.EMPTY_GENERATESMEVENTSTATEMENT;
        R712_has_recipient_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
    }

    private E_GENImpl( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Var_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Statement_ID = ref_Statement_ID;
        this.ref_Var_ID = ref_Var_ID;
        R705_is_a_GenerateSMEventStatement_inst = GenerateSMEventStatementImpl.EMPTY_GENERATESMEVENTSTATEMENT;
        R712_has_recipient_V_VAR_inst = V_VARImpl.EMPTY_V_VAR;
    }

    public static E_GEN create( Sql context ) throws XtumlException {
        E_GEN newE_GEN = new E_GENImpl( context );
        if ( context.addInstance( newE_GEN ) ) {
            newE_GEN.getRunContext().addChange(new InstanceCreatedDelta(newE_GEN, KEY_LETTERS));
            return newE_GEN;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static E_GEN create( Sql context, UniqueId instanceId, UniqueId ref_Statement_ID, UniqueId ref_Var_ID ) throws XtumlException {
        E_GEN newE_GEN = new E_GENImpl( context, instanceId, ref_Statement_ID, ref_Var_ID );
        if ( context.addInstance( newE_GEN ) ) {
            return newE_GEN;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Statement_ID;
    @Override
    public void setStatement_ID(UniqueId ref_Statement_ID) throws XtumlException {
        checkLiving();
        if (ref_Statement_ID.inequality( this.ref_Statement_ID)) {
            final UniqueId oldValue = this.ref_Statement_ID;
            this.ref_Statement_ID = ref_Statement_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Statement_ID", oldValue, this.ref_Statement_ID));
        }
    }
    @Override
    public UniqueId getStatement_ID() throws XtumlException {
        checkLiving();
        return ref_Statement_ID;
    }
    private UniqueId ref_Var_ID;
    @Override
    public void setVar_ID(UniqueId ref_Var_ID) throws XtumlException {
        checkLiving();
        if (ref_Var_ID.inequality( this.ref_Var_ID)) {
            final UniqueId oldValue = this.ref_Var_ID;
            this.ref_Var_ID = ref_Var_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Var_ID", oldValue, this.ref_Var_ID));
        }
    }
    @Override
    public UniqueId getVar_ID() throws XtumlException {
        checkLiving();
        return ref_Var_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getStatement_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private GenerateSMEventStatement R705_is_a_GenerateSMEventStatement_inst;
    @Override
    public void setR705_is_a_GenerateSMEventStatement( GenerateSMEventStatement inst ) {
        R705_is_a_GenerateSMEventStatement_inst = inst;
    }
    @Override
    public GenerateSMEventStatement R705_is_a_GenerateSMEventStatement() throws XtumlException {
        return R705_is_a_GenerateSMEventStatement_inst;
    }
    private V_VAR R712_has_recipient_V_VAR_inst;
    @Override
    public void setR712_has_recipient_V_VAR( V_VAR inst ) {
        R712_has_recipient_V_VAR_inst = inst;
    }
    @Override
    public V_VAR R712_has_recipient_V_VAR() throws XtumlException {
        return R712_has_recipient_V_VAR_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public E_GEN self() {
        return this;
    }

    @Override
    public E_GEN oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_E_GEN;
    }

}

class EmptyE_GEN extends ModelInstance<E_GEN,Sql> implements E_GEN {

    // attributes
    public void setStatement_ID( UniqueId ref_Statement_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getStatement_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setVar_ID( UniqueId ref_Var_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getVar_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public GenerateSMEventStatement R705_is_a_GenerateSMEventStatement() {
        return GenerateSMEventStatementImpl.EMPTY_GENERATESMEVENTSTATEMENT;
    }
    @Override
    public V_VAR R712_has_recipient_V_VAR() {
        return V_VARImpl.EMPTY_V_VAR;
    }


    @Override
    public String getKeyLetters() {
        return E_GENImpl.KEY_LETTERS;
    }

    @Override
    public E_GEN self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public E_GEN oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return E_GENImpl.EMPTY_E_GEN;
    }

}
