package io.ciera.tool.sql.ooaofooa.domain.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.domain.DataType;
import io.ciera.tool.sql.ooaofooa.domain.Dimensions;
import io.ciera.tool.sql.ooaofooa.domain.DimensionsSet;
import io.ciera.tool.sql.ooaofooa.domain.StructureMember;
import io.ciera.tool.sql.ooaofooa.domain.StructuredDataType;
import io.ciera.tool.sql.ooaofooa.domain.impl.DataTypeImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.DimensionsSetImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.StructureMemberImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.StructuredDataTypeImpl;
import io.ciera.tool.sql.ooaofooa.value.MemberValueReference;
import io.ciera.tool.sql.ooaofooa.value.MemberValueReferenceSet;
import io.ciera.tool.sql.ooaofooa.value.impl.MemberValueReferenceSetImpl;


public class StructureMemberImpl extends ModelInstance<StructureMember,Sql> implements StructureMember {

    public static final String KEY_LETTERS = "S_MBR";
    public static final StructureMember EMPTY_STRUCTUREMEMBER = new EmptyStructureMember();

    private Sql context;

    // constructors
    private StructureMemberImpl( Sql context ) {
        this.context = context;
        m_Member_ID = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        ref_Parent_DT_DT_ID = UniqueId.random();
        ref_DT_ID = UniqueId.random();
        ref_Previous_Member_ID = UniqueId.random();
        m_Dimensions = "";
        R44_has_parent_StructuredDataType_inst = StructuredDataTypeImpl.EMPTY_STRUCTUREDDATATYPE;
        R45_is_defined_by_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R46_precedes_StructureMember_inst = StructureMemberImpl.EMPTY_STRUCTUREMEMBER;
        R46_succeeds_StructureMember_inst = StructureMemberImpl.EMPTY_STRUCTUREMEMBER;
        R53_may_have_Dimensions_set = new DimensionsSetImpl();
        R836_MemberValueReference_set = new MemberValueReferenceSetImpl();
    }

    private StructureMemberImpl( Sql context, UniqueId instanceId, UniqueId m_Member_ID, String m_Name, String m_Descrip, UniqueId ref_Parent_DT_DT_ID, UniqueId ref_DT_ID, UniqueId ref_Previous_Member_ID, String m_Dimensions ) {
        super(instanceId);
        this.context = context;
        this.m_Member_ID = m_Member_ID;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        this.ref_Parent_DT_DT_ID = ref_Parent_DT_DT_ID;
        this.ref_DT_ID = ref_DT_ID;
        this.ref_Previous_Member_ID = ref_Previous_Member_ID;
        this.m_Dimensions = m_Dimensions;
        R44_has_parent_StructuredDataType_inst = StructuredDataTypeImpl.EMPTY_STRUCTUREDDATATYPE;
        R45_is_defined_by_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R46_precedes_StructureMember_inst = StructureMemberImpl.EMPTY_STRUCTUREMEMBER;
        R46_succeeds_StructureMember_inst = StructureMemberImpl.EMPTY_STRUCTUREMEMBER;
        R53_may_have_Dimensions_set = new DimensionsSetImpl();
        R836_MemberValueReference_set = new MemberValueReferenceSetImpl();
    }

    public static StructureMember create( Sql context ) throws XtumlException {
        StructureMember newStructureMember = new StructureMemberImpl( context );
        if ( context.addInstance( newStructureMember ) ) {
            newStructureMember.getRunContext().addChange(new InstanceCreatedDelta(newStructureMember, KEY_LETTERS));
            return newStructureMember;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static StructureMember create( Sql context, UniqueId instanceId, UniqueId m_Member_ID, String m_Name, String m_Descrip, UniqueId ref_Parent_DT_DT_ID, UniqueId ref_DT_ID, UniqueId ref_Previous_Member_ID, String m_Dimensions ) throws XtumlException {
        StructureMember newStructureMember = new StructureMemberImpl( context, instanceId, m_Member_ID, m_Name, m_Descrip, ref_Parent_DT_DT_ID, ref_DT_ID, ref_Previous_Member_ID, m_Dimensions );
        if ( context.addInstance( newStructureMember ) ) {
            return newStructureMember;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_Member_ID;
    @Override
    public UniqueId getMember_ID() throws XtumlException {
        checkLiving();
        return m_Member_ID;
    }
    @Override
    public void setMember_ID(UniqueId m_Member_ID) throws XtumlException {
        checkLiving();
        if (m_Member_ID.inequality( this.m_Member_ID)) {
            final UniqueId oldValue = this.m_Member_ID;
            this.m_Member_ID = m_Member_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Member_ID", oldValue, this.m_Member_ID));
            if ( !R46_precedes_StructureMember().isEmpty() ) R46_precedes_StructureMember().setPrevious_Member_ID( m_Member_ID );
            if ( !R53_may_have_Dimensions().isEmpty() ) R53_may_have_Dimensions().setMember_ID( m_Member_ID );
            if ( !R836_MemberValueReference().isEmpty() ) R836_MemberValueReference().setMember_ID( m_Member_ID );
        }
    }
    private String m_Name;
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    private String m_Descrip;
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    private UniqueId ref_Parent_DT_DT_ID;
    @Override
    public UniqueId getParent_DT_DT_ID() throws XtumlException {
        checkLiving();
        return ref_Parent_DT_DT_ID;
    }
    @Override
    public void setParent_DT_DT_ID(UniqueId ref_Parent_DT_DT_ID) throws XtumlException {
        checkLiving();
        if (ref_Parent_DT_DT_ID.inequality( this.ref_Parent_DT_DT_ID)) {
            final UniqueId oldValue = this.ref_Parent_DT_DT_ID;
            this.ref_Parent_DT_DT_ID = ref_Parent_DT_DT_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Parent_DT_DT_ID", oldValue, this.ref_Parent_DT_DT_ID));
            if ( !R836_MemberValueReference().isEmpty() ) R836_MemberValueReference().setDT_DT_ID( ref_Parent_DT_DT_ID );
            if ( !R46_precedes_StructureMember().isEmpty() ) R46_precedes_StructureMember().setParent_DT_DT_ID( ref_Parent_DT_DT_ID );
            if ( !R53_may_have_Dimensions().isEmpty() ) R53_may_have_Dimensions().setDT_ID( ref_Parent_DT_DT_ID );
        }
    }
    private UniqueId ref_DT_ID;
    @Override
    public void setDT_ID(UniqueId ref_DT_ID) throws XtumlException {
        checkLiving();
        if (ref_DT_ID.inequality( this.ref_DT_ID)) {
            final UniqueId oldValue = this.ref_DT_ID;
            this.ref_DT_ID = ref_DT_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_DT_ID", oldValue, this.ref_DT_ID));
        }
    }
    @Override
    public UniqueId getDT_ID() throws XtumlException {
        checkLiving();
        return ref_DT_ID;
    }
    private UniqueId ref_Previous_Member_ID;
    @Override
    public UniqueId getPrevious_Member_ID() throws XtumlException {
        checkLiving();
        return ref_Previous_Member_ID;
    }
    @Override
    public void setPrevious_Member_ID(UniqueId ref_Previous_Member_ID) throws XtumlException {
        checkLiving();
        if (ref_Previous_Member_ID.inequality( this.ref_Previous_Member_ID)) {
            final UniqueId oldValue = this.ref_Previous_Member_ID;
            this.ref_Previous_Member_ID = ref_Previous_Member_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Previous_Member_ID", oldValue, this.ref_Previous_Member_ID));
        }
    }
    private String m_Dimensions;
    @Override
    public String getDimensions() throws XtumlException {
        checkLiving();
        return m_Dimensions;
    }
    @Override
    public void setDimensions(String m_Dimensions) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Dimensions, this.m_Dimensions)) {
            final String oldValue = this.m_Dimensions;
            this.m_Dimensions = m_Dimensions;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Dimensions", oldValue, this.m_Dimensions));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getMember_ID(), getParent_DT_DT_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private StructuredDataType R44_has_parent_StructuredDataType_inst;
    @Override
    public void setR44_has_parent_StructuredDataType( StructuredDataType inst ) {
        R44_has_parent_StructuredDataType_inst = inst;
    }
    @Override
    public StructuredDataType R44_has_parent_StructuredDataType() throws XtumlException {
        return R44_has_parent_StructuredDataType_inst;
    }
    private DataType R45_is_defined_by_DataType_inst;
    @Override
    public void setR45_is_defined_by_DataType( DataType inst ) {
        R45_is_defined_by_DataType_inst = inst;
    }
    @Override
    public DataType R45_is_defined_by_DataType() throws XtumlException {
        return R45_is_defined_by_DataType_inst;
    }
    private StructureMember R46_precedes_StructureMember_inst;
    @Override
    public void setR46_precedes_StructureMember( StructureMember inst ) {
        R46_precedes_StructureMember_inst = inst;
    }
    @Override
    public StructureMember R46_precedes_StructureMember() throws XtumlException {
        return R46_precedes_StructureMember_inst;
    }
    private StructureMember R46_succeeds_StructureMember_inst;
    @Override
    public void setR46_succeeds_StructureMember( StructureMember inst ) {
        R46_succeeds_StructureMember_inst = inst;
    }
    @Override
    public StructureMember R46_succeeds_StructureMember() throws XtumlException {
        return R46_succeeds_StructureMember_inst;
    }
    private DimensionsSet R53_may_have_Dimensions_set;
    @Override
    public void addR53_may_have_Dimensions( Dimensions inst ) {
        R53_may_have_Dimensions_set.add(inst);
    }
    @Override
    public void removeR53_may_have_Dimensions( Dimensions inst ) {
        R53_may_have_Dimensions_set.remove(inst);
    }
    @Override
    public DimensionsSet R53_may_have_Dimensions() throws XtumlException {
        return R53_may_have_Dimensions_set;
    }
    private MemberValueReferenceSet R836_MemberValueReference_set;
    @Override
    public void addR836_MemberValueReference( MemberValueReference inst ) {
        R836_MemberValueReference_set.add(inst);
    }
    @Override
    public void removeR836_MemberValueReference( MemberValueReference inst ) {
        R836_MemberValueReference_set.remove(inst);
    }
    @Override
    public MemberValueReferenceSet R836_MemberValueReference() throws XtumlException {
        return R836_MemberValueReference_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public StructureMember self() {
        return this;
    }

    @Override
    public StructureMember oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_STRUCTUREMEMBER;
    }

}

class EmptyStructureMember extends ModelInstance<StructureMember,Sql> implements StructureMember {

    // attributes
    public UniqueId getMember_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setMember_ID( UniqueId m_Member_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getParent_DT_DT_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setParent_DT_DT_ID( UniqueId ref_Parent_DT_DT_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getDT_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getPrevious_Member_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPrevious_Member_ID( UniqueId ref_Previous_Member_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDimensions() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDimensions( String m_Dimensions ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public StructuredDataType R44_has_parent_StructuredDataType() {
        return StructuredDataTypeImpl.EMPTY_STRUCTUREDDATATYPE;
    }
    @Override
    public DataType R45_is_defined_by_DataType() {
        return DataTypeImpl.EMPTY_DATATYPE;
    }
    @Override
    public StructureMember R46_precedes_StructureMember() {
        return StructureMemberImpl.EMPTY_STRUCTUREMEMBER;
    }
    @Override
    public StructureMember R46_succeeds_StructureMember() {
        return StructureMemberImpl.EMPTY_STRUCTUREMEMBER;
    }
    @Override
    public DimensionsSet R53_may_have_Dimensions() {
        return (new DimensionsSetImpl());
    }
    @Override
    public MemberValueReferenceSet R836_MemberValueReference() {
        return (new MemberValueReferenceSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return StructureMemberImpl.KEY_LETTERS;
    }

    @Override
    public StructureMember self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public StructureMember oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return StructureMemberImpl.EMPTY_STRUCTUREMEMBER;
    }

}
