package io.ciera.tool.sql.ooaofooa.domain.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.domain.DataType;
import io.ciera.tool.sql.ooaofooa.domain.EnumerationDataType;
import io.ciera.tool.sql.ooaofooa.domain.S_ENUM;
import io.ciera.tool.sql.ooaofooa.domain.S_ENUMSet;
import io.ciera.tool.sql.ooaofooa.domain.impl.DataTypeImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.S_ENUMSetImpl;


public class EnumerationDataTypeImpl extends ModelInstance<EnumerationDataType,Sql> implements EnumerationDataType {

    public static final String KEY_LETTERS = "S_EDT";
    public static final EnumerationDataType EMPTY_ENUMERATIONDATATYPE = new EmptyEnumerationDataType();

    private Sql context;

    // constructors
    private EnumerationDataTypeImpl( Sql context ) {
        this.context = context;
        ref_DT_ID = UniqueId.random();
        R17_is_a_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R27_defines_S_ENUM_set = new S_ENUMSetImpl();
    }

    private EnumerationDataTypeImpl( Sql context, UniqueId instanceId, UniqueId ref_DT_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_DT_ID = ref_DT_ID;
        R17_is_a_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R27_defines_S_ENUM_set = new S_ENUMSetImpl();
    }

    public static EnumerationDataType create( Sql context ) throws XtumlException {
        EnumerationDataType newEnumerationDataType = new EnumerationDataTypeImpl( context );
        if ( context.addInstance( newEnumerationDataType ) ) {
            newEnumerationDataType.getRunContext().addChange(new InstanceCreatedDelta(newEnumerationDataType, KEY_LETTERS));
            return newEnumerationDataType;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static EnumerationDataType create( Sql context, UniqueId instanceId, UniqueId ref_DT_ID ) throws XtumlException {
        EnumerationDataType newEnumerationDataType = new EnumerationDataTypeImpl( context, instanceId, ref_DT_ID );
        if ( context.addInstance( newEnumerationDataType ) ) {
            return newEnumerationDataType;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_DT_ID;
    @Override
    public UniqueId getDT_ID() throws XtumlException {
        checkLiving();
        return ref_DT_ID;
    }
    @Override
    public void setDT_ID(UniqueId ref_DT_ID) throws XtumlException {
        checkLiving();
        if (ref_DT_ID.inequality( this.ref_DT_ID)) {
            final UniqueId oldValue = this.ref_DT_ID;
            this.ref_DT_ID = ref_DT_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_DT_ID", oldValue, this.ref_DT_ID));
            if ( !R27_defines_S_ENUM().isEmpty() ) R27_defines_S_ENUM().setEDT_DT_ID( ref_DT_ID );
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getDT_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private DataType R17_is_a_DataType_inst;
    @Override
    public void setR17_is_a_DataType( DataType inst ) {
        R17_is_a_DataType_inst = inst;
    }
    @Override
    public DataType R17_is_a_DataType() throws XtumlException {
        return R17_is_a_DataType_inst;
    }
    private S_ENUMSet R27_defines_S_ENUM_set;
    @Override
    public void addR27_defines_S_ENUM( S_ENUM inst ) {
        R27_defines_S_ENUM_set.add(inst);
    }
    @Override
    public void removeR27_defines_S_ENUM( S_ENUM inst ) {
        R27_defines_S_ENUM_set.remove(inst);
    }
    @Override
    public S_ENUMSet R27_defines_S_ENUM() throws XtumlException {
        return R27_defines_S_ENUM_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public EnumerationDataType self() {
        return this;
    }

    @Override
    public EnumerationDataType oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_ENUMERATIONDATATYPE;
    }

}

class EmptyEnumerationDataType extends ModelInstance<EnumerationDataType,Sql> implements EnumerationDataType {

    // attributes
    public UniqueId getDT_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public DataType R17_is_a_DataType() {
        return DataTypeImpl.EMPTY_DATATYPE;
    }
    @Override
    public S_ENUMSet R27_defines_S_ENUM() {
        return (new S_ENUMSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return EnumerationDataTypeImpl.KEY_LETTERS;
    }

    @Override
    public EnumerationDataType self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public EnumerationDataType oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return EnumerationDataTypeImpl.EMPTY_ENUMERATIONDATATYPE;
    }

}
