package io.ciera.tool.sql.ooaofooa.deployment.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.ooaofooa.deployment.DeploymentSet;
import io.ciera.tool.sql.ooaofooa.deployment.Terminator;
import io.ciera.tool.sql.ooaofooa.deployment.TerminatorServiceSet;
import io.ciera.tool.sql.ooaofooa.deployment.TerminatorSet;
import io.ciera.tool.sql.ooaofooa.deployment.impl.DeploymentSetImpl;
import io.ciera.tool.sql.ooaofooa.deployment.impl.TerminatorServiceSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class TerminatorSetImpl extends InstanceSet<TerminatorSet,Terminator> implements TerminatorSet {

    public TerminatorSetImpl() {
    }

    public TerminatorSetImpl(Comparator<? super Terminator> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setDomain_Name( String m_Domain_Name ) throws XtumlException {
        for ( Terminator terminator : this ) terminator.setDomain_Name( m_Domain_Name );
    }
    @Override
    public void setTerm_ID( UniqueId m_Term_ID ) throws XtumlException {
        for ( Terminator terminator : this ) terminator.setTerm_ID( m_Term_ID );
    }
    @Override
    public void setTerminator_Name( String m_Terminator_Name ) throws XtumlException {
        for ( Terminator terminator : this ) terminator.setTerminator_Name( m_Terminator_Name );
    }
    @Override
    public void setName( String m_Name ) throws XtumlException {
        for ( Terminator terminator : this ) terminator.setName( m_Name );
    }
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        for ( Terminator terminator : this ) terminator.setDescrip( m_Descrip );
    }
    @Override
    public void setProvider( boolean m_Provider ) throws XtumlException {
        for ( Terminator terminator : this ) terminator.setProvider( m_Provider );
    }
    @Override
    public void setDeployment_ID( UniqueId ref_Deployment_ID ) throws XtumlException {
        for ( Terminator terminator : this ) terminator.setDeployment_ID( ref_Deployment_ID );
    }


    // selections
    @Override
    public DeploymentSet R1650_Deployment() throws XtumlException {
        DeploymentSet deploymentset = new DeploymentSetImpl();
        for ( Terminator terminator : this ) deploymentset.add( terminator.R1650_Deployment() );
        return deploymentset;
    }
    @Override
    public TerminatorServiceSet R1651_TerminatorService() throws XtumlException {
        TerminatorServiceSet terminatorserviceset = new TerminatorServiceSetImpl();
        for ( Terminator terminator : this ) terminatorserviceset.addAll( terminator.R1651_TerminatorService() );
        return terminatorserviceset;
    }


    @Override
    public Terminator nullElement() {
        return TerminatorImpl.EMPTY_TERMINATOR;
    }

    @Override
    public TerminatorSet emptySet() {
      return new TerminatorSetImpl();
    }

    @Override
    public TerminatorSet emptySet(Comparator<? super Terminator> comp) {
      return new TerminatorSetImpl(comp);
    }

    @Override
    public List<Terminator> elements() {
        Terminator[] elements = toArray(new Terminator[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
