package io.ciera.tool.sql.ooaofooa.deployment.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.deployment.Terminator;
import io.ciera.tool.sql.ooaofooa.deployment.TerminatorService;
import io.ciera.tool.sql.ooaofooa.deployment.TerminatorServiceParameter;
import io.ciera.tool.sql.ooaofooa.deployment.TerminatorServiceParameterSet;
import io.ciera.tool.sql.ooaofooa.deployment.impl.TerminatorImpl;
import io.ciera.tool.sql.ooaofooa.deployment.impl.TerminatorServiceParameterSetImpl;
import io.ciera.tool.sql.ooaofooa.domain.DataType;
import io.ciera.tool.sql.ooaofooa.domain.Dimensions;
import io.ciera.tool.sql.ooaofooa.domain.DimensionsSet;
import io.ciera.tool.sql.ooaofooa.domain.impl.DataTypeImpl;
import io.ciera.tool.sql.ooaofooa.domain.impl.DimensionsSetImpl;

import ooaofooa.datatypes.ActionDialect;
import ooaofooa.datatypes.ImplementationScope;
import ooaofooa.datatypes.ParseStatus;


public class TerminatorServiceImpl extends ModelInstance<TerminatorService,Sql> implements TerminatorService {

    public static final String KEY_LETTERS = "D_TSVC";
    public static final TerminatorService EMPTY_TERMINATORSERVICE = new EmptyTerminatorService();

    private Sql context;

    // constructors
    private TerminatorServiceImpl( Sql context ) {
        this.context = context;
        m_Svc_ID = UniqueId.random();
        ref_Term_ID = UniqueId.random();
        m_Name = "";
        m_Descrip = "";
        m_Action_Semantics = "";
        m_Action_Semantics_internal = "";
        ref_DT_ID = UniqueId.random();
        m_Suc_Pars = ParseStatus.UNINITIALIZED_ENUM;
        m_Return_Dimensions = "";
        m_Dialect = ActionDialect.UNINITIALIZED_ENUM;
        m_Is_Stale = false;
        m_Implementation_Scope = ImplementationScope.UNINITIALIZED_ENUM;
        R1651_Terminator_inst = TerminatorImpl.EMPTY_TERMINATOR;
        R1652_TerminatorServiceParameter_set = new TerminatorServiceParameterSetImpl();
        R1656_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R1657_Dimensions_set = new DimensionsSetImpl();
    }

    private TerminatorServiceImpl( Sql context, UniqueId instanceId, UniqueId m_Svc_ID, UniqueId ref_Term_ID, String m_Name, String m_Descrip, String m_Action_Semantics, String m_Action_Semantics_internal, UniqueId ref_DT_ID, ParseStatus m_Suc_Pars, String m_Return_Dimensions, ActionDialect m_Dialect, boolean m_Is_Stale, ImplementationScope m_Implementation_Scope ) {
        super(instanceId);
        this.context = context;
        this.m_Svc_ID = m_Svc_ID;
        this.ref_Term_ID = ref_Term_ID;
        this.m_Name = m_Name;
        this.m_Descrip = m_Descrip;
        this.m_Action_Semantics = m_Action_Semantics;
        this.m_Action_Semantics_internal = m_Action_Semantics_internal;
        this.ref_DT_ID = ref_DT_ID;
        this.m_Suc_Pars = m_Suc_Pars;
        this.m_Return_Dimensions = m_Return_Dimensions;
        this.m_Dialect = m_Dialect;
        this.m_Is_Stale = m_Is_Stale;
        this.m_Implementation_Scope = m_Implementation_Scope;
        R1651_Terminator_inst = TerminatorImpl.EMPTY_TERMINATOR;
        R1652_TerminatorServiceParameter_set = new TerminatorServiceParameterSetImpl();
        R1656_DataType_inst = DataTypeImpl.EMPTY_DATATYPE;
        R1657_Dimensions_set = new DimensionsSetImpl();
    }

    public static TerminatorService create( Sql context ) throws XtumlException {
        TerminatorService newTerminatorService = new TerminatorServiceImpl( context );
        if ( context.addInstance( newTerminatorService ) ) {
            newTerminatorService.getRunContext().addChange(new InstanceCreatedDelta(newTerminatorService, KEY_LETTERS));
            return newTerminatorService;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static TerminatorService create( Sql context, UniqueId instanceId, UniqueId m_Svc_ID, UniqueId ref_Term_ID, String m_Name, String m_Descrip, String m_Action_Semantics, String m_Action_Semantics_internal, UniqueId ref_DT_ID, ParseStatus m_Suc_Pars, String m_Return_Dimensions, ActionDialect m_Dialect, boolean m_Is_Stale, ImplementationScope m_Implementation_Scope ) throws XtumlException {
        TerminatorService newTerminatorService = new TerminatorServiceImpl( context, instanceId, m_Svc_ID, ref_Term_ID, m_Name, m_Descrip, m_Action_Semantics, m_Action_Semantics_internal, ref_DT_ID, m_Suc_Pars, m_Return_Dimensions, m_Dialect, m_Is_Stale, m_Implementation_Scope );
        if ( context.addInstance( newTerminatorService ) ) {
            return newTerminatorService;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId m_Svc_ID;
    @Override
    public void setSvc_ID(UniqueId m_Svc_ID) throws XtumlException {
        checkLiving();
        if (m_Svc_ID.inequality( this.m_Svc_ID)) {
            final UniqueId oldValue = this.m_Svc_ID;
            this.m_Svc_ID = m_Svc_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Svc_ID", oldValue, this.m_Svc_ID));
            if ( !R1657_Dimensions().isEmpty() ) R1657_Dimensions().setSvc_ID( m_Svc_ID );
            if ( !R1652_TerminatorServiceParameter().isEmpty() ) R1652_TerminatorServiceParameter().setSvc_ID( m_Svc_ID );
        }
    }
    @Override
    public UniqueId getSvc_ID() throws XtumlException {
        checkLiving();
        return m_Svc_ID;
    }
    private UniqueId ref_Term_ID;
    @Override
    public void setTerm_ID(UniqueId ref_Term_ID) throws XtumlException {
        checkLiving();
        if (ref_Term_ID.inequality( this.ref_Term_ID)) {
            final UniqueId oldValue = this.ref_Term_ID;
            this.ref_Term_ID = ref_Term_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Term_ID", oldValue, this.ref_Term_ID));
        }
    }
    @Override
    public UniqueId getTerm_ID() throws XtumlException {
        checkLiving();
        return ref_Term_ID;
    }
    private String m_Name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_Name;
    }
    @Override
    public void setName(String m_Name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Name, this.m_Name)) {
            final String oldValue = this.m_Name;
            this.m_Name = m_Name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Name", oldValue, this.m_Name));
        }
    }
    private String m_Descrip;
    @Override
    public String getDescrip() throws XtumlException {
        checkLiving();
        return m_Descrip;
    }
    @Override
    public void setDescrip(String m_Descrip) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Descrip, this.m_Descrip)) {
            final String oldValue = this.m_Descrip;
            this.m_Descrip = m_Descrip;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Descrip", oldValue, this.m_Descrip));
        }
    }
    private String m_Action_Semantics;
    @Override
    public void setAction_Semantics(String m_Action_Semantics) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Action_Semantics, this.m_Action_Semantics)) {
            final String oldValue = this.m_Action_Semantics;
            this.m_Action_Semantics = m_Action_Semantics;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Action_Semantics", oldValue, this.m_Action_Semantics));
        }
    }
    @Override
    public String getAction_Semantics() throws XtumlException {
        checkLiving();
        return m_Action_Semantics;
    }
    private String m_Action_Semantics_internal;
    @Override
    public void setAction_Semantics_internal(String m_Action_Semantics_internal) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Action_Semantics_internal, this.m_Action_Semantics_internal)) {
            final String oldValue = this.m_Action_Semantics_internal;
            this.m_Action_Semantics_internal = m_Action_Semantics_internal;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Action_Semantics_internal", oldValue, this.m_Action_Semantics_internal));
        }
    }
    @Override
    public String getAction_Semantics_internal() throws XtumlException {
        checkLiving();
        return m_Action_Semantics_internal;
    }
    private UniqueId ref_DT_ID;
    @Override
    public void setDT_ID(UniqueId ref_DT_ID) throws XtumlException {
        checkLiving();
        if (ref_DT_ID.inequality( this.ref_DT_ID)) {
            final UniqueId oldValue = this.ref_DT_ID;
            this.ref_DT_ID = ref_DT_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_DT_ID", oldValue, this.ref_DT_ID));
        }
    }
    @Override
    public UniqueId getDT_ID() throws XtumlException {
        checkLiving();
        return ref_DT_ID;
    }
    private ParseStatus m_Suc_Pars;
    @Override
    public void setSuc_Pars(ParseStatus m_Suc_Pars) throws XtumlException {
        checkLiving();
        if (m_Suc_Pars.inequality( this.m_Suc_Pars)) {
            final ParseStatus oldValue = this.m_Suc_Pars;
            this.m_Suc_Pars = m_Suc_Pars;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Suc_Pars", oldValue, this.m_Suc_Pars));
        }
    }
    @Override
    public ParseStatus getSuc_Pars() throws XtumlException {
        checkLiving();
        return m_Suc_Pars;
    }
    private String m_Return_Dimensions;
    @Override
    public String getReturn_Dimensions() throws XtumlException {
        checkLiving();
        return m_Return_Dimensions;
    }
    @Override
    public void setReturn_Dimensions(String m_Return_Dimensions) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_Return_Dimensions, this.m_Return_Dimensions)) {
            final String oldValue = this.m_Return_Dimensions;
            this.m_Return_Dimensions = m_Return_Dimensions;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Return_Dimensions", oldValue, this.m_Return_Dimensions));
        }
    }
    private ActionDialect m_Dialect;
    @Override
    public ActionDialect getDialect() throws XtumlException {
        checkLiving();
        return m_Dialect;
    }
    @Override
    public void setDialect(ActionDialect m_Dialect) throws XtumlException {
        checkLiving();
        if (m_Dialect.inequality( this.m_Dialect)) {
            final ActionDialect oldValue = this.m_Dialect;
            this.m_Dialect = m_Dialect;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Dialect", oldValue, this.m_Dialect));
        }
    }
    private boolean m_Is_Stale;
    @Override
    public boolean getIs_Stale() throws XtumlException {
        checkLiving();
        return m_Is_Stale;
    }
    @Override
    public void setIs_Stale(boolean m_Is_Stale) throws XtumlException {
        checkLiving();
        if (m_Is_Stale != this.m_Is_Stale) {
            final boolean oldValue = this.m_Is_Stale;
            this.m_Is_Stale = m_Is_Stale;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Is_Stale", oldValue, this.m_Is_Stale));
        }
    }
    private ImplementationScope m_Implementation_Scope;
    @Override
    public ImplementationScope getImplementation_Scope() throws XtumlException {
        checkLiving();
        return m_Implementation_Scope;
    }
    @Override
    public void setImplementation_Scope(ImplementationScope m_Implementation_Scope) throws XtumlException {
        checkLiving();
        if (m_Implementation_Scope.inequality( this.m_Implementation_Scope)) {
            final ImplementationScope oldValue = this.m_Implementation_Scope;
            this.m_Implementation_Scope = m_Implementation_Scope;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_Implementation_Scope", oldValue, this.m_Implementation_Scope));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getSvc_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Terminator R1651_Terminator_inst;
    @Override
    public void setR1651_Terminator( Terminator inst ) {
        R1651_Terminator_inst = inst;
    }
    @Override
    public Terminator R1651_Terminator() throws XtumlException {
        return R1651_Terminator_inst;
    }
    private TerminatorServiceParameterSet R1652_TerminatorServiceParameter_set;
    @Override
    public void addR1652_TerminatorServiceParameter( TerminatorServiceParameter inst ) {
        R1652_TerminatorServiceParameter_set.add(inst);
    }
    @Override
    public void removeR1652_TerminatorServiceParameter( TerminatorServiceParameter inst ) {
        R1652_TerminatorServiceParameter_set.remove(inst);
    }
    @Override
    public TerminatorServiceParameterSet R1652_TerminatorServiceParameter() throws XtumlException {
        return R1652_TerminatorServiceParameter_set;
    }
    private DataType R1656_DataType_inst;
    @Override
    public void setR1656_DataType( DataType inst ) {
        R1656_DataType_inst = inst;
    }
    @Override
    public DataType R1656_DataType() throws XtumlException {
        return R1656_DataType_inst;
    }
    private DimensionsSet R1657_Dimensions_set;
    @Override
    public void addR1657_Dimensions( Dimensions inst ) {
        R1657_Dimensions_set.add(inst);
    }
    @Override
    public void removeR1657_Dimensions( Dimensions inst ) {
        R1657_Dimensions_set.remove(inst);
    }
    @Override
    public DimensionsSet R1657_Dimensions() throws XtumlException {
        return R1657_Dimensions_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public TerminatorService self() {
        return this;
    }

    @Override
    public TerminatorService oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_TERMINATORSERVICE;
    }

}

class EmptyTerminatorService extends ModelInstance<TerminatorService,Sql> implements TerminatorService {

    // attributes
    public void setSvc_ID( UniqueId m_Svc_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getSvc_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setTerm_ID( UniqueId ref_Term_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getTerm_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_Name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getDescrip() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDescrip( String m_Descrip ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setAction_Semantics( String m_Action_Semantics ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getAction_Semantics() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAction_Semantics_internal( String m_Action_Semantics_internal ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getAction_Semantics_internal() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDT_ID( UniqueId ref_DT_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getDT_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setSuc_Pars( ParseStatus m_Suc_Pars ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public ParseStatus getSuc_Pars() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getReturn_Dimensions() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setReturn_Dimensions( String m_Return_Dimensions ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public ActionDialect getDialect() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setDialect( ActionDialect m_Dialect ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getIs_Stale() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIs_Stale( boolean m_Is_Stale ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public ImplementationScope getImplementation_Scope() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setImplementation_Scope( ImplementationScope m_Implementation_Scope ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Terminator R1651_Terminator() {
        return TerminatorImpl.EMPTY_TERMINATOR;
    }
    @Override
    public TerminatorServiceParameterSet R1652_TerminatorServiceParameter() {
        return (new TerminatorServiceParameterSetImpl());
    }
    @Override
    public DataType R1656_DataType() {
        return DataTypeImpl.EMPTY_DATATYPE;
    }
    @Override
    public DimensionsSet R1657_Dimensions() {
        return (new DimensionsSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return TerminatorServiceImpl.KEY_LETTERS;
    }

    @Override
    public TerminatorService self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public TerminatorService oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return TerminatorServiceImpl.EMPTY_TERMINATORSERVICE;
    }

}
