package io.ciera.tool.sql.ooaofooa.component.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.ooaofooa.component.InterfaceReferenceSet;
import io.ciera.tool.sql.ooaofooa.component.Provision;
import io.ciera.tool.sql.ooaofooa.component.ProvisionSet;
import io.ciera.tool.sql.ooaofooa.component.SatisfactionSet;
import io.ciera.tool.sql.ooaofooa.component.impl.InterfaceReferenceSetImpl;
import io.ciera.tool.sql.ooaofooa.component.impl.SatisfactionSetImpl;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.ProvidedExecutablePropertySet;
import io.ciera.tool.sql.ooaofooa.component.signalprovisionsandrequirements.impl.ProvidedExecutablePropertySetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class ProvisionSetImpl extends InstanceSet<ProvisionSet,Provision> implements ProvisionSet {

    public ProvisionSetImpl() {
    }

    public ProvisionSetImpl(Comparator<? super Provision> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setName( String m_Name ) throws XtumlException {
        for ( Provision provision : this ) provision.setName( m_Name );
    }
    @Override
    public void setInformalName( String m_InformalName ) throws XtumlException {
        for ( Provision provision : this ) provision.setInformalName( m_InformalName );
    }
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        for ( Provision provision : this ) provision.setDescrip( m_Descrip );
    }
    @Override
    public void setPathFromComponent( String m_pathFromComponent ) throws XtumlException {
        for ( Provision provision : this ) provision.setPathFromComponent( m_pathFromComponent );
    }
    @Override
    public void setProvision_Id( UniqueId ref_Provision_Id ) throws XtumlException {
        for ( Provision provision : this ) provision.setProvision_Id( ref_Provision_Id );
    }


    // selections
    @Override
    public SatisfactionSet R4002_defines_required_satisfication_Satisfaction() throws XtumlException {
        SatisfactionSet satisfactionset = new SatisfactionSetImpl();
        for ( Provision provision : this ) satisfactionset.addAll( provision.R4002_defines_required_satisfication_Satisfaction() );
        return satisfactionset;
    }
    @Override
    public InterfaceReferenceSet R4009_is_a_InterfaceReference() throws XtumlException {
        InterfaceReferenceSet interfacereferenceset = new InterfaceReferenceSetImpl();
        for ( Provision provision : this ) interfacereferenceset.add( provision.R4009_is_a_InterfaceReference() );
        return interfacereferenceset;
    }
    @Override
    public ProvidedExecutablePropertySet R4501_implements_ProvidedExecutableProperty() throws XtumlException {
        ProvidedExecutablePropertySet providedexecutablepropertyset = new ProvidedExecutablePropertySetImpl();
        for ( Provision provision : this ) providedexecutablepropertyset.addAll( provision.R4501_implements_ProvidedExecutableProperty() );
        return providedexecutablepropertyset;
    }


    @Override
    public Provision nullElement() {
        return ProvisionImpl.EMPTY_PROVISION;
    }

    @Override
    public ProvisionSet emptySet() {
      return new ProvisionSetImpl();
    }

    @Override
    public ProvisionSet emptySet(Comparator<? super Provision> comp) {
      return new ProvisionSetImpl(comp);
    }

    @Override
    public List<Provision> elements() {
        Provision[] elements = toArray(new Provision[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
