package io.ciera.tool.sql.ooaofooa.communication.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.ooaofooa.association.AssociationSet;
import io.ciera.tool.sql.ooaofooa.association.impl.AssociationSetImpl;
import io.ciera.tool.sql.ooaofooa.communication.CommunicationLink;
import io.ciera.tool.sql.ooaofooa.communication.CommunicationLinkSet;
import io.ciera.tool.sql.ooaofooa.interaction.InteractionParticipantSet;
import io.ciera.tool.sql.ooaofooa.interaction.impl.InteractionParticipantSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

import ooaofooa.datatypes.Visibility;


public class CommunicationLinkSetImpl extends InstanceSet<CommunicationLinkSet,CommunicationLink> implements CommunicationLinkSet {

    public CommunicationLinkSetImpl() {
    }

    public CommunicationLinkSetImpl(Comparator<? super CommunicationLink> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setIsFormal( boolean m_isFormal ) throws XtumlException {
        for ( CommunicationLink communicationlink : this ) communicationlink.setIsFormal( m_isFormal );
    }
    @Override
    public void setEndText( String m_EndText ) throws XtumlException {
        for ( CommunicationLink communicationlink : this ) communicationlink.setEndText( m_EndText );
    }
    @Override
    public void setEndVisibility( Visibility m_EndVisibility ) throws XtumlException {
        for ( CommunicationLink communicationlink : this ) communicationlink.setEndVisibility( m_EndVisibility );
    }
    @Override
    public void setStart_Part_ID( UniqueId ref_Start_Part_ID ) throws XtumlException {
        for ( CommunicationLink communicationlink : this ) communicationlink.setStart_Part_ID( ref_Start_Part_ID );
    }
    @Override
    public void setNumb( String m_Numb ) throws XtumlException {
        for ( CommunicationLink communicationlink : this ) communicationlink.setNumb( m_Numb );
    }
    @Override
    public void setStartVisibility( Visibility m_StartVisibility ) throws XtumlException {
        for ( CommunicationLink communicationlink : this ) communicationlink.setStartVisibility( m_StartVisibility );
    }
    @Override
    public void setDescrip( String m_Descrip ) throws XtumlException {
        for ( CommunicationLink communicationlink : this ) communicationlink.setDescrip( m_Descrip );
    }
    @Override
    public void setRel_ID( UniqueId ref_Rel_ID ) throws XtumlException {
        for ( CommunicationLink communicationlink : this ) communicationlink.setRel_ID( ref_Rel_ID );
    }
    @Override
    public void setDestination_Part_ID( UniqueId ref_Destination_Part_ID ) throws XtumlException {
        for ( CommunicationLink communicationlink : this ) communicationlink.setDestination_Part_ID( ref_Destination_Part_ID );
    }
    @Override
    public void setLink_ID( UniqueId m_Link_ID ) throws XtumlException {
        for ( CommunicationLink communicationlink : this ) communicationlink.setLink_ID( m_Link_ID );
    }
    @Override
    public void setStartText( String m_StartText ) throws XtumlException {
        for ( CommunicationLink communicationlink : this ) communicationlink.setStartText( m_StartText );
    }


    // selections
    @Override
    public AssociationSet R1128_may_be_formalized_against_Association() throws XtumlException {
        AssociationSet associationset = new AssociationSetImpl();
        for ( CommunicationLink communicationlink : this ) associationset.add( communicationlink.R1128_may_be_formalized_against_Association() );
        return associationset;
    }
    @Override
    public InteractionParticipantSet R1133_starts_at_InteractionParticipant() throws XtumlException {
        InteractionParticipantSet interactionparticipantset = new InteractionParticipantSetImpl();
        for ( CommunicationLink communicationlink : this ) interactionparticipantset.add( communicationlink.R1133_starts_at_InteractionParticipant() );
        return interactionparticipantset;
    }
    @Override
    public InteractionParticipantSet R1134_is_destined_for_InteractionParticipant() throws XtumlException {
        InteractionParticipantSet interactionparticipantset = new InteractionParticipantSetImpl();
        for ( CommunicationLink communicationlink : this ) interactionparticipantset.add( communicationlink.R1134_is_destined_for_InteractionParticipant() );
        return interactionparticipantset;
    }


    @Override
    public CommunicationLink nullElement() {
        return CommunicationLinkImpl.EMPTY_COMMUNICATIONLINK;
    }

    @Override
    public CommunicationLinkSet emptySet() {
      return new CommunicationLinkSetImpl();
    }

    @Override
    public CommunicationLinkSet emptySet(Comparator<? super CommunicationLink> comp) {
      return new CommunicationLinkSetImpl(comp);
    }

    @Override
    public List<CommunicationLink> elements() {
        return Arrays.asList(toArray(new CommunicationLink[0]));
    }

}
