package io.ciera.tool.sql.ooaofooa.body.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.body.Body;
import io.ciera.tool.sql.ooaofooa.body.OperationBody;
import io.ciera.tool.sql.ooaofooa.body.impl.BodyImpl;
import io.ciera.tool.sql.ooaofooa.subsystem.O_TFR;
import io.ciera.tool.sql.ooaofooa.subsystem.impl.O_TFRImpl;


public class OperationBodyImpl extends ModelInstance<OperationBody,Sql> implements OperationBody {

    public static final String KEY_LETTERS = "ACT_OPB";
    public static final OperationBody EMPTY_OPERATIONBODY = new EmptyOperationBody();

    private Sql context;

    // constructors
    private OperationBodyImpl( Sql context ) {
        this.context = context;
        ref_Action_ID = UniqueId.random();
        ref_Tfr_ID = UniqueId.random();
        R696_specifies_processing_for_O_TFR_inst = O_TFRImpl.EMPTY_O_TFR;
        R698_is_a_Body_inst = BodyImpl.EMPTY_BODY;
    }

    private OperationBodyImpl( Sql context, UniqueId instanceId, UniqueId ref_Action_ID, UniqueId ref_Tfr_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Action_ID = ref_Action_ID;
        this.ref_Tfr_ID = ref_Tfr_ID;
        R696_specifies_processing_for_O_TFR_inst = O_TFRImpl.EMPTY_O_TFR;
        R698_is_a_Body_inst = BodyImpl.EMPTY_BODY;
    }

    public static OperationBody create( Sql context ) throws XtumlException {
        OperationBody newOperationBody = new OperationBodyImpl( context );
        if ( context.addInstance( newOperationBody ) ) {
            newOperationBody.getRunContext().addChange(new InstanceCreatedDelta(newOperationBody, KEY_LETTERS));
            return newOperationBody;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static OperationBody create( Sql context, UniqueId instanceId, UniqueId ref_Action_ID, UniqueId ref_Tfr_ID ) throws XtumlException {
        OperationBody newOperationBody = new OperationBodyImpl( context, instanceId, ref_Action_ID, ref_Tfr_ID );
        if ( context.addInstance( newOperationBody ) ) {
            return newOperationBody;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Action_ID;
    @Override
    public UniqueId getAction_ID() throws XtumlException {
        checkLiving();
        return ref_Action_ID;
    }
    @Override
    public void setAction_ID(UniqueId ref_Action_ID) throws XtumlException {
        checkLiving();
        if (ref_Action_ID.inequality( this.ref_Action_ID)) {
            final UniqueId oldValue = this.ref_Action_ID;
            this.ref_Action_ID = ref_Action_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Action_ID", oldValue, this.ref_Action_ID));
        }
    }
    private UniqueId ref_Tfr_ID;
    @Override
    public void setTfr_ID(UniqueId ref_Tfr_ID) throws XtumlException {
        checkLiving();
        if (ref_Tfr_ID.inequality( this.ref_Tfr_ID)) {
            final UniqueId oldValue = this.ref_Tfr_ID;
            this.ref_Tfr_ID = ref_Tfr_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Tfr_ID", oldValue, this.ref_Tfr_ID));
        }
    }
    @Override
    public UniqueId getTfr_ID() throws XtumlException {
        checkLiving();
        return ref_Tfr_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getAction_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private O_TFR R696_specifies_processing_for_O_TFR_inst;
    @Override
    public void setR696_specifies_processing_for_O_TFR( O_TFR inst ) {
        R696_specifies_processing_for_O_TFR_inst = inst;
    }
    @Override
    public O_TFR R696_specifies_processing_for_O_TFR() throws XtumlException {
        return R696_specifies_processing_for_O_TFR_inst;
    }
    private Body R698_is_a_Body_inst;
    @Override
    public void setR698_is_a_Body( Body inst ) {
        R698_is_a_Body_inst = inst;
    }
    @Override
    public Body R698_is_a_Body() throws XtumlException {
        return R698_is_a_Body_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public OperationBody self() {
        return this;
    }

    @Override
    public OperationBody oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_OPERATIONBODY;
    }

}

class EmptyOperationBody extends ModelInstance<OperationBody,Sql> implements OperationBody {

    // attributes
    public UniqueId getAction_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setAction_ID( UniqueId ref_Action_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setTfr_ID( UniqueId ref_Tfr_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getTfr_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public O_TFR R696_specifies_processing_for_O_TFR() {
        return O_TFRImpl.EMPTY_O_TFR;
    }
    @Override
    public Body R698_is_a_Body() {
        return BodyImpl.EMPTY_BODY;
    }


    @Override
    public String getKeyLetters() {
        return OperationBodyImpl.KEY_LETTERS;
    }

    @Override
    public OperationBody self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public OperationBody oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return OperationBodyImpl.EMPTY_OPERATIONBODY;
    }

}
