package io.ciera.tool.sql.ooaofooa.association.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.association.Association;
import io.ciera.tool.sql.ooaofooa.association.ClassAsAssociatedOneSide;
import io.ciera.tool.sql.ooaofooa.association.ClassAsAssociatedOtherSide;
import io.ciera.tool.sql.ooaofooa.association.ClassAsLink;
import io.ciera.tool.sql.ooaofooa.association.LinkedAssociation;
import io.ciera.tool.sql.ooaofooa.association.impl.AssociationImpl;
import io.ciera.tool.sql.ooaofooa.association.impl.ClassAsAssociatedOneSideImpl;
import io.ciera.tool.sql.ooaofooa.association.impl.ClassAsAssociatedOtherSideImpl;
import io.ciera.tool.sql.ooaofooa.association.impl.ClassAsLinkImpl;


public class LinkedAssociationImpl extends ModelInstance<LinkedAssociation,Sql> implements LinkedAssociation {

    public static final String KEY_LETTERS = "R_ASSOC";
    public static final LinkedAssociation EMPTY_LINKEDASSOCIATION = new EmptyLinkedAssociation();

    private Sql context;

    // constructors
    private LinkedAssociationImpl( Sql context ) {
        this.context = context;
        ref_Rel_ID = UniqueId.random();
        R206_is_a_Association_inst = AssociationImpl.EMPTY_ASSOCIATION;
        R209_relates_ClassAsAssociatedOneSide_inst = ClassAsAssociatedOneSideImpl.EMPTY_CLASSASASSOCIATEDONESIDE;
        R210_relates_ClassAsAssociatedOtherSide_inst = ClassAsAssociatedOtherSideImpl.EMPTY_CLASSASASSOCIATEDOTHERSIDE;
        R211_uses_a_formalizer_ClassAsLink_inst = ClassAsLinkImpl.EMPTY_CLASSASLINK;
    }

    private LinkedAssociationImpl( Sql context, UniqueId instanceId, UniqueId ref_Rel_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Rel_ID = ref_Rel_ID;
        R206_is_a_Association_inst = AssociationImpl.EMPTY_ASSOCIATION;
        R209_relates_ClassAsAssociatedOneSide_inst = ClassAsAssociatedOneSideImpl.EMPTY_CLASSASASSOCIATEDONESIDE;
        R210_relates_ClassAsAssociatedOtherSide_inst = ClassAsAssociatedOtherSideImpl.EMPTY_CLASSASASSOCIATEDOTHERSIDE;
        R211_uses_a_formalizer_ClassAsLink_inst = ClassAsLinkImpl.EMPTY_CLASSASLINK;
    }

    public static LinkedAssociation create( Sql context ) throws XtumlException {
        LinkedAssociation newLinkedAssociation = new LinkedAssociationImpl( context );
        if ( context.addInstance( newLinkedAssociation ) ) {
            newLinkedAssociation.getRunContext().addChange(new InstanceCreatedDelta(newLinkedAssociation, KEY_LETTERS));
            return newLinkedAssociation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static LinkedAssociation create( Sql context, UniqueId instanceId, UniqueId ref_Rel_ID ) throws XtumlException {
        LinkedAssociation newLinkedAssociation = new LinkedAssociationImpl( context, instanceId, ref_Rel_ID );
        if ( context.addInstance( newLinkedAssociation ) ) {
            return newLinkedAssociation;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Rel_ID;
    @Override
    public void setRel_ID(UniqueId ref_Rel_ID) throws XtumlException {
        checkLiving();
        if (ref_Rel_ID.inequality( this.ref_Rel_ID)) {
            final UniqueId oldValue = this.ref_Rel_ID;
            this.ref_Rel_ID = ref_Rel_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Rel_ID", oldValue, this.ref_Rel_ID));
            if ( !R210_relates_ClassAsAssociatedOtherSide().isEmpty() ) R210_relates_ClassAsAssociatedOtherSide().setRel_ID( ref_Rel_ID );
            if ( !R211_uses_a_formalizer_ClassAsLink().isEmpty() ) R211_uses_a_formalizer_ClassAsLink().setRel_ID( ref_Rel_ID );
            if ( !R209_relates_ClassAsAssociatedOneSide().isEmpty() ) R209_relates_ClassAsAssociatedOneSide().setRel_ID( ref_Rel_ID );
        }
    }
    @Override
    public UniqueId getRel_ID() throws XtumlException {
        checkLiving();
        return ref_Rel_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getRel_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Association R206_is_a_Association_inst;
    @Override
    public void setR206_is_a_Association( Association inst ) {
        R206_is_a_Association_inst = inst;
    }
    @Override
    public Association R206_is_a_Association() throws XtumlException {
        return R206_is_a_Association_inst;
    }
    private ClassAsAssociatedOneSide R209_relates_ClassAsAssociatedOneSide_inst;
    @Override
    public void setR209_relates_ClassAsAssociatedOneSide( ClassAsAssociatedOneSide inst ) {
        R209_relates_ClassAsAssociatedOneSide_inst = inst;
    }
    @Override
    public ClassAsAssociatedOneSide R209_relates_ClassAsAssociatedOneSide() throws XtumlException {
        return R209_relates_ClassAsAssociatedOneSide_inst;
    }
    private ClassAsAssociatedOtherSide R210_relates_ClassAsAssociatedOtherSide_inst;
    @Override
    public void setR210_relates_ClassAsAssociatedOtherSide( ClassAsAssociatedOtherSide inst ) {
        R210_relates_ClassAsAssociatedOtherSide_inst = inst;
    }
    @Override
    public ClassAsAssociatedOtherSide R210_relates_ClassAsAssociatedOtherSide() throws XtumlException {
        return R210_relates_ClassAsAssociatedOtherSide_inst;
    }
    private ClassAsLink R211_uses_a_formalizer_ClassAsLink_inst;
    @Override
    public void setR211_uses_a_formalizer_ClassAsLink( ClassAsLink inst ) {
        R211_uses_a_formalizer_ClassAsLink_inst = inst;
    }
    @Override
    public ClassAsLink R211_uses_a_formalizer_ClassAsLink() throws XtumlException {
        return R211_uses_a_formalizer_ClassAsLink_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public LinkedAssociation self() {
        return this;
    }

    @Override
    public LinkedAssociation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_LINKEDASSOCIATION;
    }

}

class EmptyLinkedAssociation extends ModelInstance<LinkedAssociation,Sql> implements LinkedAssociation {

    // attributes
    public void setRel_ID( UniqueId ref_Rel_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getRel_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Association R206_is_a_Association() {
        return AssociationImpl.EMPTY_ASSOCIATION;
    }
    @Override
    public ClassAsAssociatedOneSide R209_relates_ClassAsAssociatedOneSide() {
        return ClassAsAssociatedOneSideImpl.EMPTY_CLASSASASSOCIATEDONESIDE;
    }
    @Override
    public ClassAsAssociatedOtherSide R210_relates_ClassAsAssociatedOtherSide() {
        return ClassAsAssociatedOtherSideImpl.EMPTY_CLASSASASSOCIATEDOTHERSIDE;
    }
    @Override
    public ClassAsLink R211_uses_a_formalizer_ClassAsLink() {
        return ClassAsLinkImpl.EMPTY_CLASSASLINK;
    }


    @Override
    public String getKeyLetters() {
        return LinkedAssociationImpl.KEY_LETTERS;
    }

    @Override
    public LinkedAssociation self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public LinkedAssociation oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return LinkedAssociationImpl.EMPTY_LINKEDASSOCIATION;
    }

}
