package io.ciera.tool.sql.ooaofooa.association.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.association.ClassAsSupertype;
import io.ciera.tool.sql.ooaofooa.association.ReferredToClassInAssoc;
import io.ciera.tool.sql.ooaofooa.association.SubtypeSupertypeAssociation;
import io.ciera.tool.sql.ooaofooa.association.impl.ReferredToClassInAssocImpl;
import io.ciera.tool.sql.ooaofooa.association.impl.SubtypeSupertypeAssociationImpl;


public class ClassAsSupertypeImpl extends ModelInstance<ClassAsSupertype,Sql> implements ClassAsSupertype {

    public static final String KEY_LETTERS = "R_SUPER";
    public static final ClassAsSupertype EMPTY_CLASSASSUPERTYPE = new EmptyClassAsSupertype();

    private Sql context;

    // constructors
    private ClassAsSupertypeImpl( Sql context ) {
        this.context = context;
        ref_Obj_ID = UniqueId.random();
        ref_Rel_ID = UniqueId.random();
        ref_OIR_ID = UniqueId.random();
        R204_is_a_ReferredToClassInAssoc_inst = ReferredToClassInAssocImpl.EMPTY_REFERREDTOCLASSINASSOC;
        R212_is_related_to_subtypes_via_SubtypeSupertypeAssociation_inst = SubtypeSupertypeAssociationImpl.EMPTY_SUBTYPESUPERTYPEASSOCIATION;
    }

    private ClassAsSupertypeImpl( Sql context, UniqueId instanceId, UniqueId ref_Obj_ID, UniqueId ref_Rel_ID, UniqueId ref_OIR_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Obj_ID = ref_Obj_ID;
        this.ref_Rel_ID = ref_Rel_ID;
        this.ref_OIR_ID = ref_OIR_ID;
        R204_is_a_ReferredToClassInAssoc_inst = ReferredToClassInAssocImpl.EMPTY_REFERREDTOCLASSINASSOC;
        R212_is_related_to_subtypes_via_SubtypeSupertypeAssociation_inst = SubtypeSupertypeAssociationImpl.EMPTY_SUBTYPESUPERTYPEASSOCIATION;
    }

    public static ClassAsSupertype create( Sql context ) throws XtumlException {
        ClassAsSupertype newClassAsSupertype = new ClassAsSupertypeImpl( context );
        if ( context.addInstance( newClassAsSupertype ) ) {
            newClassAsSupertype.getRunContext().addChange(new InstanceCreatedDelta(newClassAsSupertype, KEY_LETTERS));
            return newClassAsSupertype;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ClassAsSupertype create( Sql context, UniqueId instanceId, UniqueId ref_Obj_ID, UniqueId ref_Rel_ID, UniqueId ref_OIR_ID ) throws XtumlException {
        ClassAsSupertype newClassAsSupertype = new ClassAsSupertypeImpl( context, instanceId, ref_Obj_ID, ref_Rel_ID, ref_OIR_ID );
        if ( context.addInstance( newClassAsSupertype ) ) {
            return newClassAsSupertype;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Obj_ID;
    @Override
    public void setObj_ID(UniqueId ref_Obj_ID) throws XtumlException {
        checkLiving();
        if (ref_Obj_ID.inequality( this.ref_Obj_ID)) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
        }
    }
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
        return ref_Obj_ID;
    }
    private UniqueId ref_Rel_ID;
    @Override
    public void setRel_ID(UniqueId ref_Rel_ID) throws XtumlException {
        checkLiving();
        if (ref_Rel_ID.inequality( this.ref_Rel_ID)) {
            final UniqueId oldValue = this.ref_Rel_ID;
            this.ref_Rel_ID = ref_Rel_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Rel_ID", oldValue, this.ref_Rel_ID));
        }
    }
    @Override
    public UniqueId getRel_ID() throws XtumlException {
        checkLiving();
        return ref_Rel_ID;
    }
    private UniqueId ref_OIR_ID;
    @Override
    public void setOIR_ID(UniqueId ref_OIR_ID) throws XtumlException {
        checkLiving();
        if (ref_OIR_ID.inequality( this.ref_OIR_ID)) {
            final UniqueId oldValue = this.ref_OIR_ID;
            this.ref_OIR_ID = ref_OIR_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_OIR_ID", oldValue, this.ref_OIR_ID));
        }
    }
    @Override
    public UniqueId getOIR_ID() throws XtumlException {
        checkLiving();
        return ref_OIR_ID;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getObj_ID(), getRel_ID(), getOIR_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ReferredToClassInAssoc R204_is_a_ReferredToClassInAssoc_inst;
    @Override
    public void setR204_is_a_ReferredToClassInAssoc( ReferredToClassInAssoc inst ) {
        R204_is_a_ReferredToClassInAssoc_inst = inst;
    }
    @Override
    public ReferredToClassInAssoc R204_is_a_ReferredToClassInAssoc() throws XtumlException {
        return R204_is_a_ReferredToClassInAssoc_inst;
    }
    private SubtypeSupertypeAssociation R212_is_related_to_subtypes_via_SubtypeSupertypeAssociation_inst;
    @Override
    public void setR212_is_related_to_subtypes_via_SubtypeSupertypeAssociation( SubtypeSupertypeAssociation inst ) {
        R212_is_related_to_subtypes_via_SubtypeSupertypeAssociation_inst = inst;
    }
    @Override
    public SubtypeSupertypeAssociation R212_is_related_to_subtypes_via_SubtypeSupertypeAssociation() throws XtumlException {
        return R212_is_related_to_subtypes_via_SubtypeSupertypeAssociation_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ClassAsSupertype self() {
        return this;
    }

    @Override
    public ClassAsSupertype oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_CLASSASSUPERTYPE;
    }

}

class EmptyClassAsSupertype extends ModelInstance<ClassAsSupertype,Sql> implements ClassAsSupertype {

    // attributes
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRel_ID( UniqueId ref_Rel_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getRel_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setOIR_ID( UniqueId ref_OIR_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getOIR_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ReferredToClassInAssoc R204_is_a_ReferredToClassInAssoc() {
        return ReferredToClassInAssocImpl.EMPTY_REFERREDTOCLASSINASSOC;
    }
    @Override
    public SubtypeSupertypeAssociation R212_is_related_to_subtypes_via_SubtypeSupertypeAssociation() {
        return SubtypeSupertypeAssociationImpl.EMPTY_SUBTYPESUPERTYPEASSOCIATION;
    }


    @Override
    public String getKeyLetters() {
        return ClassAsSupertypeImpl.KEY_LETTERS;
    }

    @Override
    public ClassAsSupertype self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ClassAsSupertype oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ClassAsSupertypeImpl.EMPTY_CLASSASSUPERTYPE;
    }

}
