package io.ciera.tool.sql.ooaofooa.association.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofooa.association.ClassAsSubtype;
import io.ciera.tool.sql.ooaofooa.association.ReferringClassInAssoc;
import io.ciera.tool.sql.ooaofooa.association.SubtypeSupertypeAssociation;
import io.ciera.tool.sql.ooaofooa.association.impl.ReferringClassInAssocImpl;
import io.ciera.tool.sql.ooaofooa.association.impl.SubtypeSupertypeAssociationImpl;


public class ClassAsSubtypeImpl extends ModelInstance<ClassAsSubtype,Sql> implements ClassAsSubtype {

    public static final String KEY_LETTERS = "R_SUB";
    public static final ClassAsSubtype EMPTY_CLASSASSUBTYPE = new EmptyClassAsSubtype();

    private Sql context;

    // constructors
    private ClassAsSubtypeImpl( Sql context ) {
        this.context = context;
        ref_Obj_ID = UniqueId.random();
        ref_Rel_ID = UniqueId.random();
        ref_OIR_ID = UniqueId.random();
        R205_is_a_ReferringClassInAssoc_inst = ReferringClassInAssocImpl.EMPTY_REFERRINGCLASSINASSOC;
        R213_is_related_to_supertype_via_SubtypeSupertypeAssociation_inst = SubtypeSupertypeAssociationImpl.EMPTY_SUBTYPESUPERTYPEASSOCIATION;
    }

    private ClassAsSubtypeImpl( Sql context, UniqueId instanceId, UniqueId ref_Obj_ID, UniqueId ref_Rel_ID, UniqueId ref_OIR_ID ) {
        super(instanceId);
        this.context = context;
        this.ref_Obj_ID = ref_Obj_ID;
        this.ref_Rel_ID = ref_Rel_ID;
        this.ref_OIR_ID = ref_OIR_ID;
        R205_is_a_ReferringClassInAssoc_inst = ReferringClassInAssocImpl.EMPTY_REFERRINGCLASSINASSOC;
        R213_is_related_to_supertype_via_SubtypeSupertypeAssociation_inst = SubtypeSupertypeAssociationImpl.EMPTY_SUBTYPESUPERTYPEASSOCIATION;
    }

    public static ClassAsSubtype create( Sql context ) throws XtumlException {
        ClassAsSubtype newClassAsSubtype = new ClassAsSubtypeImpl( context );
        if ( context.addInstance( newClassAsSubtype ) ) {
            newClassAsSubtype.getRunContext().addChange(new InstanceCreatedDelta(newClassAsSubtype, KEY_LETTERS));
            return newClassAsSubtype;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ClassAsSubtype create( Sql context, UniqueId instanceId, UniqueId ref_Obj_ID, UniqueId ref_Rel_ID, UniqueId ref_OIR_ID ) throws XtumlException {
        ClassAsSubtype newClassAsSubtype = new ClassAsSubtypeImpl( context, instanceId, ref_Obj_ID, ref_Rel_ID, ref_OIR_ID );
        if ( context.addInstance( newClassAsSubtype ) ) {
            return newClassAsSubtype;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private UniqueId ref_Obj_ID;
    @Override
    public void setObj_ID(UniqueId ref_Obj_ID) throws XtumlException {
        checkLiving();
        if (ref_Obj_ID.inequality( this.ref_Obj_ID)) {
            final UniqueId oldValue = this.ref_Obj_ID;
            this.ref_Obj_ID = ref_Obj_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Obj_ID", oldValue, this.ref_Obj_ID));
        }
    }
    @Override
    public UniqueId getObj_ID() throws XtumlException {
        checkLiving();
        return ref_Obj_ID;
    }
    private UniqueId ref_Rel_ID;
    @Override
    public UniqueId getRel_ID() throws XtumlException {
        checkLiving();
        return ref_Rel_ID;
    }
    @Override
    public void setRel_ID(UniqueId ref_Rel_ID) throws XtumlException {
        checkLiving();
        if (ref_Rel_ID.inequality( this.ref_Rel_ID)) {
            final UniqueId oldValue = this.ref_Rel_ID;
            this.ref_Rel_ID = ref_Rel_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_Rel_ID", oldValue, this.ref_Rel_ID));
        }
    }
    private UniqueId ref_OIR_ID;
    @Override
    public UniqueId getOIR_ID() throws XtumlException {
        checkLiving();
        return ref_OIR_ID;
    }
    @Override
    public void setOIR_ID(UniqueId ref_OIR_ID) throws XtumlException {
        checkLiving();
        if (ref_OIR_ID.inequality( this.ref_OIR_ID)) {
            final UniqueId oldValue = this.ref_OIR_ID;
            this.ref_OIR_ID = ref_OIR_ID;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_OIR_ID", oldValue, this.ref_OIR_ID));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getObj_ID(), getRel_ID(), getOIR_ID());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private ReferringClassInAssoc R205_is_a_ReferringClassInAssoc_inst;
    @Override
    public void setR205_is_a_ReferringClassInAssoc( ReferringClassInAssoc inst ) {
        R205_is_a_ReferringClassInAssoc_inst = inst;
    }
    @Override
    public ReferringClassInAssoc R205_is_a_ReferringClassInAssoc() throws XtumlException {
        return R205_is_a_ReferringClassInAssoc_inst;
    }
    private SubtypeSupertypeAssociation R213_is_related_to_supertype_via_SubtypeSupertypeAssociation_inst;
    @Override
    public void setR213_is_related_to_supertype_via_SubtypeSupertypeAssociation( SubtypeSupertypeAssociation inst ) {
        R213_is_related_to_supertype_via_SubtypeSupertypeAssociation_inst = inst;
    }
    @Override
    public SubtypeSupertypeAssociation R213_is_related_to_supertype_via_SubtypeSupertypeAssociation() throws XtumlException {
        return R213_is_related_to_supertype_via_SubtypeSupertypeAssociation_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ClassAsSubtype self() {
        return this;
    }

    @Override
    public ClassAsSubtype oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_CLASSASSUBTYPE;
    }

}

class EmptyClassAsSubtype extends ModelInstance<ClassAsSubtype,Sql> implements ClassAsSubtype {

    // attributes
    public void setObj_ID( UniqueId ref_Obj_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getObj_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public UniqueId getRel_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setRel_ID( UniqueId ref_Rel_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public UniqueId getOIR_ID() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setOIR_ID( UniqueId ref_OIR_ID ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public ReferringClassInAssoc R205_is_a_ReferringClassInAssoc() {
        return ReferringClassInAssocImpl.EMPTY_REFERRINGCLASSINASSOC;
    }
    @Override
    public SubtypeSupertypeAssociation R213_is_related_to_supertype_via_SubtypeSupertypeAssociation() {
        return SubtypeSupertypeAssociationImpl.EMPTY_SUBTYPESUPERTYPEASSOCIATION;
    }


    @Override
    public String getKeyLetters() {
        return ClassAsSubtypeImpl.KEY_LETTERS;
    }

    @Override
    public ClassAsSubtype self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ClassAsSubtype oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ClassAsSubtypeImpl.EMPTY_CLASSASSUBTYPE;
    }

}
