package io.ciera.tool.sql.ooaofmarking.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.ActionHome;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.ooaofmarking.Feature;
import io.ciera.tool.sql.ooaofmarking.FeatureSet;
import io.ciera.tool.sql.ooaofmarking.Mark;
import io.ciera.tool.sql.ooaofmarking.MarkSet;
import io.ciera.tool.sql.ooaofmarking.MarkableElementType;
import io.ciera.tool.sql.ooaofmarking.MarkableElementTypeSet;
import io.ciera.tool.sql.ooaofmarking.impl.FeatureImpl;
import io.ciera.tool.sql.ooaofmarking.impl.MarkSetImpl;
import io.ciera.tool.sql.ooaofmarking.impl.MarkableElementTypeImpl;
import io.ciera.tool.sql.ooaofmarking.impl.MarkableElementTypeSetImpl;

import java.util.Iterator;


public class FeatureImpl extends ModelInstance<Feature,Sql> implements Feature {

    public static final String KEY_LETTERS = "Feature";
    public static final Feature EMPTY_FEATURE = new EmptyFeature();

    private Sql context;

    // constructors
    private FeatureImpl( Sql context ) {
        this.context = context;
        m_name = "";
        R2821_marks_Mark_set = new MarkSetImpl();
        R2822_is_available_for_MarkableElementType_set = new MarkableElementTypeSetImpl();
    }

    private FeatureImpl( Sql context, UniqueId instanceId, String m_name ) {
        super(instanceId);
        this.context = context;
        this.m_name = m_name;
        R2821_marks_Mark_set = new MarkSetImpl();
        R2822_is_available_for_MarkableElementType_set = new MarkableElementTypeSetImpl();
    }

    public static Feature create( Sql context ) throws XtumlException {
        Feature newFeature = new FeatureImpl( context );
        if ( context.addInstance( newFeature ) ) {
            newFeature.getRunContext().addChange(new InstanceCreatedDelta(newFeature, KEY_LETTERS));
            return newFeature;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static Feature create( Sql context, UniqueId instanceId, String m_name ) throws XtumlException {
        Feature newFeature = new FeatureImpl( context, instanceId, m_name );
        if ( context.addInstance( newFeature ) ) {
            return newFeature;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String m_name;
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return m_name;
    }
    @Override
    public void setName(String m_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_name, this.m_name)) {
            final String oldValue = this.m_name;
            this.m_name = m_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_name", oldValue, this.m_name));
            if ( !R2821_marks_Mark().isEmpty() ) R2821_marks_Mark().setFeature_name( m_name );
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getName());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void dispose() throws XtumlException {
        MarkableElementTypeSet markables = self().R2822_is_available_for_MarkableElementType();
        MarkableElementType markable;
        for ( Iterator<MarkableElementType> _markable_iter = markables.elements().iterator(); _markable_iter.hasNext(); ) {
            markable = _markable_iter.next();
            context().unrelate_R2822_MarkableElementType_makes_available_Feature( markable, self() );
        }
        self().delete();
    }



    // static operations
    public static class CLASS extends ActionHome<Sql> {

        public CLASS( Sql context ) {
            super( context );
        }

        public void load( final String p_filename,  final String[] p_values ) throws XtumlException {
            boolean done = false;
            while ( !done ) {
                int count = context().CSV().readline( p_filename, p_values );
                if ( count > 0 ) {
                    if ( count == 2 ) {
                        MarkableElementType markable = new MarkableElementTypeImpl.CLASS(context()).populate( p_values[0] );
                        Feature feature = new FeatureImpl.CLASS(context()).populate( p_values[1] );
                        Feature related_feature = markable.R2822_makes_available_Feature().anyWhere(selected -> StringUtil.equality(((Feature)selected).getName(), feature.getName()));
                        if ( related_feature.isEmpty() ) {
                            context().relate_R2822_MarkableElementType_makes_available_Feature( markable, feature );
                        }
                    }
                }
                else {
                    done = true;
                }
            }
        }

        public void persist( final String p_filename,  final String[] p_values ) throws XtumlException {
            MarkableElementTypeSet markables = context().MarkableElementType_instances();
            MarkableElementType markable;
            for ( Iterator<MarkableElementType> _markable_iter = markables.elements().iterator(); _markable_iter.hasNext(); ) {
                markable = _markable_iter.next();
                FeatureSet features = markable.R2822_makes_available_Feature();
                Feature feature;
                for ( Iterator<Feature> _feature_iter = features.elements().iterator(); _feature_iter.hasNext(); ) {
                    feature = _feature_iter.next();
                    p_values[0] = markable.getName();
                    p_values[1] = feature.getName();
                    p_values[2] = "";
                    context().CSV().writeline( p_filename, p_values );
                }
            }
        }

        public Feature populate( final String p_name ) throws XtumlException {
            Feature feature = context().Feature_instances().anyWhere(selected -> StringUtil.equality(((Feature)selected).getName(), p_name));
            if ( feature.isEmpty() ) {
                feature = FeatureImpl.create( context() );
                feature.setName(p_name);
            }
            return feature;
        }



    }


    // events


    // selections
    private MarkSet R2821_marks_Mark_set;
    @Override
    public void addR2821_marks_Mark( Mark inst ) {
        R2821_marks_Mark_set.add(inst);
    }
    @Override
    public void removeR2821_marks_Mark( Mark inst ) {
        R2821_marks_Mark_set.remove(inst);
    }
    @Override
    public MarkSet R2821_marks_Mark() throws XtumlException {
        return R2821_marks_Mark_set;
    }
    private MarkableElementTypeSet R2822_is_available_for_MarkableElementType_set;
    @Override
    public void addR2822_is_available_for_MarkableElementType( MarkableElementType inst ) {
        R2822_is_available_for_MarkableElementType_set.add(inst);
    }
    @Override
    public void removeR2822_is_available_for_MarkableElementType( MarkableElementType inst ) {
        R2822_is_available_for_MarkableElementType_set.remove(inst);
    }
    @Override
    public MarkableElementTypeSet R2822_is_available_for_MarkableElementType() throws XtumlException {
        return R2822_is_available_for_MarkableElementType_set;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public Feature self() {
        return this;
    }

    @Override
    public Feature oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_FEATURE;
    }

}

class EmptyFeature extends ModelInstance<Feature,Sql> implements Feature {

    // attributes
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setName( String m_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void dispose() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public MarkSet R2821_marks_Mark() {
        return (new MarkSetImpl());
    }
    @Override
    public MarkableElementTypeSet R2822_is_available_for_MarkableElementType() {
        return (new MarkableElementTypeSetImpl());
    }


    @Override
    public String getKeyLetters() {
        return FeatureImpl.KEY_LETTERS;
    }

    @Override
    public Feature self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Feature oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return FeatureImpl.EMPTY_FEATURE;
    }

}
