package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.loader.AttributeLoaderSet;
import io.ciera.tool.sql.loader.RealLoader;
import io.ciera.tool.sql.loader.RealLoaderSet;
import io.ciera.tool.sql.loader.impl.AttributeLoaderSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class RealLoaderSetImpl extends InstanceSet<RealLoaderSet,RealLoader> implements RealLoaderSet {

    public RealLoaderSetImpl() {
    }

    public RealLoaderSetImpl(Comparator<? super RealLoader> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setIndex( int ref_index ) throws XtumlException {
        for ( RealLoader realloader : this ) realloader.setIndex( ref_index );
    }
    @Override
    public void setAttr_name( String ref_attr_name ) throws XtumlException {
        for ( RealLoader realloader : this ) realloader.setAttr_name( ref_attr_name );
    }
    @Override
    public void setClass_name( String ref_class_name ) throws XtumlException {
        for ( RealLoader realloader : this ) realloader.setClass_name( ref_class_name );
    }
    @Override
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        for ( RealLoader realloader : this ) realloader.setLoader_package( ref_loader_package );
    }
    @Override
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        for ( RealLoader realloader : this ) realloader.setLoader_name( ref_loader_name );
    }


    // selections
    @Override
    public AttributeLoaderSet R3008_is_a_AttributeLoader() throws XtumlException {
        AttributeLoaderSet attributeloaderset = new AttributeLoaderSetImpl();
        for ( RealLoader realloader : this ) attributeloaderset.add( realloader.R3008_is_a_AttributeLoader() );
        return attributeloaderset;
    }


    @Override
    public RealLoader nullElement() {
        return RealLoaderImpl.EMPTY_REALLOADER;
    }

    @Override
    public RealLoaderSet emptySet() {
      return new RealLoaderSetImpl();
    }

    @Override
    public RealLoaderSet emptySet(Comparator<? super RealLoader> comp) {
      return new RealLoaderSetImpl(comp);
    }

    @Override
    public List<RealLoader> elements() {
        return Arrays.asList(toArray(new RealLoader[0]));
    }

}
