package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.loader.AttributeSerializer;
import io.ciera.tool.sql.loader.ClassInstanceSerializer;
import io.ciera.tool.sql.loader.InstanceSerializer;
import io.ciera.tool.sql.loader.impl.InstanceSerializerImpl;


public class ClassInstanceSerializerImpl extends ModelInstance<ClassInstanceSerializer,Sql> implements ClassInstanceSerializer {

    public static final String KEY_LETTERS = "ClassInstanceSerializer";
    public static final ClassInstanceSerializer EMPTY_CLASSINSTANCESERIALIZER = new EmptyClassInstanceSerializer();

    private Sql context;

    // constructors
    private ClassInstanceSerializerImpl( Sql context ) {
        this.context = context;
        ref_loader_name = "";
        ref_loader_package = "";
        ref_class_name = "";
        m_class_package = "";
        m_class_key_letters = "";
        R3015_is_a_InstanceSerializer_inst = InstanceSerializerImpl.EMPTY_INSTANCESERIALIZER;
    }

    private ClassInstanceSerializerImpl( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, String ref_class_name, String m_class_package, String m_class_key_letters ) {
        super(instanceId);
        this.context = context;
        this.ref_loader_name = ref_loader_name;
        this.ref_loader_package = ref_loader_package;
        this.ref_class_name = ref_class_name;
        this.m_class_package = m_class_package;
        this.m_class_key_letters = m_class_key_letters;
        R3015_is_a_InstanceSerializer_inst = InstanceSerializerImpl.EMPTY_INSTANCESERIALIZER;
    }

    public static ClassInstanceSerializer create( Sql context ) throws XtumlException {
        ClassInstanceSerializer newClassInstanceSerializer = new ClassInstanceSerializerImpl( context );
        if ( context.addInstance( newClassInstanceSerializer ) ) {
            newClassInstanceSerializer.getRunContext().addChange(new InstanceCreatedDelta(newClassInstanceSerializer, KEY_LETTERS));
            return newClassInstanceSerializer;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static ClassInstanceSerializer create( Sql context, UniqueId instanceId, String ref_loader_name, String ref_loader_package, String ref_class_name, String m_class_package, String m_class_key_letters ) throws XtumlException {
        ClassInstanceSerializer newClassInstanceSerializer = new ClassInstanceSerializerImpl( context, instanceId, ref_loader_name, ref_loader_package, ref_class_name, m_class_package, m_class_key_letters );
        if ( context.addInstance( newClassInstanceSerializer ) ) {
            return newClassInstanceSerializer;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_loader_name;
    @Override
    public void setLoader_name(String ref_loader_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_loader_name, this.ref_loader_name)) {
            final String oldValue = this.ref_loader_name;
            this.ref_loader_name = ref_loader_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_name", oldValue, this.ref_loader_name));
        }
    }
    @Override
    public String getLoader_name() throws XtumlException {
        checkLiving();
        return ref_loader_name;
    }
    private String ref_loader_package;
    @Override
    public String getLoader_package() throws XtumlException {
        checkLiving();
        return ref_loader_package;
    }
    @Override
    public void setLoader_package(String ref_loader_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_loader_package, this.ref_loader_package)) {
            final String oldValue = this.ref_loader_package;
            this.ref_loader_package = ref_loader_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_loader_package", oldValue, this.ref_loader_package));
        }
    }
    private String ref_class_name;
    @Override
    public String getClass_name() throws XtumlException {
        checkLiving();
        return ref_class_name;
    }
    @Override
    public void setClass_name(String ref_class_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_class_name, this.ref_class_name)) {
            final String oldValue = this.ref_class_name;
            this.ref_class_name = ref_class_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_class_name", oldValue, this.ref_class_name));
        }
    }
    private String m_class_package;
    @Override
    public void setClass_package(String m_class_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_class_package, this.m_class_package)) {
            final String oldValue = this.m_class_package;
            this.m_class_package = m_class_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_class_package", oldValue, this.m_class_package));
        }
    }
    @Override
    public String getClass_package() throws XtumlException {
        checkLiving();
        return m_class_package;
    }
    private String m_class_key_letters;
    @Override
    public String getClass_key_letters() throws XtumlException {
        checkLiving();
        return m_class_key_letters;
    }
    @Override
    public void setClass_key_letters(String m_class_key_letters) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(m_class_key_letters, this.m_class_key_letters)) {
            final String oldValue = this.m_class_key_letters;
            this.m_class_key_letters = m_class_key_letters;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_class_key_letters", oldValue, this.m_class_key_letters));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getLoader_name(), getLoader_package(), getClass_name());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        context().T().include( "loader/t.classinstanceserializer.java", self() );
    }

    @Override
    public void render_def() throws XtumlException {
        context().T().push_buffer();
        AttributeSerializer attr_serializer = self().R3015_is_a_InstanceSerializer().R3002_serializes_data_value_using_AttributeSerializer().any();
        AttributeSerializer prev_attr_serializer = attr_serializer.R3003_follows_AttributeSerializer();
        while ( !prev_attr_serializer.isEmpty() ) {
            attr_serializer = prev_attr_serializer;
            prev_attr_serializer = attr_serializer.R3003_follows_AttributeSerializer();
        }
        while ( !attr_serializer.isEmpty() ) {
            attr_serializer.render();
            attr_serializer = attr_serializer.R3003_precedes_AttributeSerializer();
            if ( !attr_serializer.isEmpty() ) {
                context().T().include( "loader/t.attributeserializer.sep.java" );
            }
        }
        String attribute_serializers = context().T().body();
        context().T().pop_buffer();
        context().T().include( "loader/t.classinstanceserializer.def.java", attribute_serializers, self() );
    }

    @Override
    public void render_init() throws XtumlException {
        context().T().include( "loader/t.classinstanceserializer.init.java" );
    }



    // static operations


    // events


    // selections
    private InstanceSerializer R3015_is_a_InstanceSerializer_inst;
    @Override
    public void setR3015_is_a_InstanceSerializer( InstanceSerializer inst ) {
        R3015_is_a_InstanceSerializer_inst = inst;
    }
    @Override
    public InstanceSerializer R3015_is_a_InstanceSerializer() throws XtumlException {
        return R3015_is_a_InstanceSerializer_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public ClassInstanceSerializer self() {
        return this;
    }

    @Override
    public ClassInstanceSerializer oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_CLASSINSTANCESERIALIZER;
    }

}

class EmptyClassInstanceSerializer extends ModelInstance<ClassInstanceSerializer,Sql> implements ClassInstanceSerializer {

    // attributes
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getLoader_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getLoader_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getClass_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setClass_name( String ref_class_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setClass_package( String m_class_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getClass_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getClass_key_letters() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setClass_key_letters( String m_class_key_letters ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_def() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_init() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public InstanceSerializer R3015_is_a_InstanceSerializer() {
        return InstanceSerializerImpl.EMPTY_INSTANCESERIALIZER;
    }


    @Override
    public String getKeyLetters() {
        return ClassInstanceSerializerImpl.KEY_LETTERS;
    }

    @Override
    public ClassInstanceSerializer self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ClassInstanceSerializer oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return ClassInstanceSerializerImpl.EMPTY_CLASSINSTANCESERIALIZER;
    }

}
