package io.ciera.tool.sql.loader.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.loader.AttributeComparisonSet;
import io.ciera.tool.sql.loader.BatchRelator;
import io.ciera.tool.sql.loader.BatchRelatorSet;
import io.ciera.tool.sql.loader.PopulationLoaderSet;
import io.ciera.tool.sql.loader.impl.AttributeComparisonSetImpl;
import io.ciera.tool.sql.loader.impl.PopulationLoaderSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class BatchRelatorSetImpl extends InstanceSet<BatchRelatorSet,BatchRelator> implements BatchRelatorSet {

    public BatchRelatorSetImpl() {
    }

    public BatchRelatorSetImpl(Comparator<? super BatchRelator> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setUnconditional( boolean m_unconditional ) throws XtumlException {
        for ( BatchRelator batchrelator : this ) batchrelator.setUnconditional( m_unconditional );
    }
    @Override
    public void setLoader_package( String ref_loader_package ) throws XtumlException {
        for ( BatchRelator batchrelator : this ) batchrelator.setLoader_package( ref_loader_package );
    }
    @Override
    public void setRel_name( String m_rel_name ) throws XtumlException {
        for ( BatchRelator batchrelator : this ) batchrelator.setRel_name( m_rel_name );
    }
    @Override
    public void setId_num( int m_id_num ) throws XtumlException {
        for ( BatchRelator batchrelator : this ) batchrelator.setId_num( m_id_num );
    }
    @Override
    public void setPart_name( String m_part_name ) throws XtumlException {
        for ( BatchRelator batchrelator : this ) batchrelator.setPart_name( m_part_name );
    }
    @Override
    public void setLoader_name( String ref_loader_name ) throws XtumlException {
        for ( BatchRelator batchrelator : this ) batchrelator.setLoader_name( ref_loader_name );
    }
    @Override
    public void setForm_name( String m_form_name ) throws XtumlException {
        for ( BatchRelator batchrelator : this ) batchrelator.setForm_name( m_form_name );
    }


    // selections
    @Override
    public PopulationLoaderSet R3011_invoked_by_PopulationLoader() throws XtumlException {
        PopulationLoaderSet populationloaderset = new PopulationLoaderSetImpl();
        for ( BatchRelator batchrelator : this ) populationloaderset.add( batchrelator.R3011_invoked_by_PopulationLoader() );
        return populationloaderset;
    }
    @Override
    public AttributeComparisonSet R3012_selects_participant_by_evaluating_AttributeComparison() throws XtumlException {
        AttributeComparisonSet attributecomparisonset = new AttributeComparisonSetImpl();
        for ( BatchRelator batchrelator : this ) attributecomparisonset.addAll( batchrelator.R3012_selects_participant_by_evaluating_AttributeComparison() );
        return attributecomparisonset;
    }


    @Override
    public BatchRelator nullElement() {
        return BatchRelatorImpl.EMPTY_BATCHRELATOR;
    }

    @Override
    public BatchRelatorSet emptySet() {
      return new BatchRelatorSetImpl();
    }

    @Override
    public BatchRelatorSet emptySet(Comparator<? super BatchRelator> comp) {
      return new BatchRelatorSetImpl(comp);
    }

    @Override
    public List<BatchRelator> elements() {
        return Arrays.asList(toArray(new BatchRelator[0]));
    }

}
