package io.ciera.tool.sql.architecture.type.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.type.BuiltInType;
import io.ciera.tool.sql.architecture.type.Type;
import io.ciera.tool.sql.architecture.type.impl.TypeImpl;


public class BuiltInTypeImpl extends ModelInstance<BuiltInType,Sql> implements BuiltInType {

    public static final String KEY_LETTERS = "BuiltInType";
    public static final BuiltInType EMPTY_BUILTINTYPE = new EmptyBuiltInType();

    private Sql context;

    // constructors
    private BuiltInTypeImpl( Sql context ) {
        this.context = context;
        ref_name = "";
        ref_package = "";
        m_primitive = false;
        m_unique = false;
        m_inst = false;
        m_instset = false;
        R407_is_a_Type_inst = TypeImpl.EMPTY_TYPE;
    }

    private BuiltInTypeImpl( Sql context, UniqueId instanceId, String ref_name, String ref_package, boolean m_primitive, boolean m_unique, boolean m_inst, boolean m_instset ) {
        super(instanceId);
        this.context = context;
        this.ref_name = ref_name;
        this.ref_package = ref_package;
        this.m_primitive = m_primitive;
        this.m_unique = m_unique;
        this.m_inst = m_inst;
        this.m_instset = m_instset;
        R407_is_a_Type_inst = TypeImpl.EMPTY_TYPE;
    }

    public static BuiltInType create( Sql context ) throws XtumlException {
        BuiltInType newBuiltInType = new BuiltInTypeImpl( context );
        if ( context.addInstance( newBuiltInType ) ) {
            newBuiltInType.getRunContext().addChange(new InstanceCreatedDelta(newBuiltInType, KEY_LETTERS));
            return newBuiltInType;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static BuiltInType create( Sql context, UniqueId instanceId, String ref_name, String ref_package, boolean m_primitive, boolean m_unique, boolean m_inst, boolean m_instset ) throws XtumlException {
        BuiltInType newBuiltInType = new BuiltInTypeImpl( context, instanceId, ref_name, ref_package, m_primitive, m_unique, m_inst, m_instset );
        if ( context.addInstance( newBuiltInType ) ) {
            return newBuiltInType;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_name;
    @Override
    public void setName(String ref_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_name, this.ref_name)) {
            final String oldValue = this.ref_name;
            this.ref_name = ref_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_name", oldValue, this.ref_name));
        }
    }
    @Override
    public String getName() throws XtumlException {
        checkLiving();
        return ref_name;
    }
    private String ref_package;
    @Override
    public String getPackage() throws XtumlException {
        checkLiving();
        return ref_package;
    }
    @Override
    public void setPackage(String ref_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_package, this.ref_package)) {
            final String oldValue = this.ref_package;
            this.ref_package = ref_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_package", oldValue, this.ref_package));
        }
    }
    private boolean m_primitive;
    @Override
    public void setPrimitive(boolean m_primitive) throws XtumlException {
        checkLiving();
        if (m_primitive != this.m_primitive) {
            final boolean oldValue = this.m_primitive;
            this.m_primitive = m_primitive;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_primitive", oldValue, this.m_primitive));
        }
    }
    @Override
    public boolean getPrimitive() throws XtumlException {
        checkLiving();
        return m_primitive;
    }
    private boolean m_unique;
    @Override
    public boolean getUnique() throws XtumlException {
        checkLiving();
        return m_unique;
    }
    @Override
    public void setUnique(boolean m_unique) throws XtumlException {
        checkLiving();
        if (m_unique != this.m_unique) {
            final boolean oldValue = this.m_unique;
            this.m_unique = m_unique;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_unique", oldValue, this.m_unique));
        }
    }
    private boolean m_inst;
    @Override
    public void setInst(boolean m_inst) throws XtumlException {
        checkLiving();
        if (m_inst != this.m_inst) {
            final boolean oldValue = this.m_inst;
            this.m_inst = m_inst;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_inst", oldValue, this.m_inst));
        }
    }
    @Override
    public boolean getInst() throws XtumlException {
        checkLiving();
        return m_inst;
    }
    private boolean m_instset;
    @Override
    public boolean getInstset() throws XtumlException {
        checkLiving();
        return m_instset;
    }
    @Override
    public void setInstset(boolean m_instset) throws XtumlException {
        checkLiving();
        if (m_instset != this.m_instset) {
            final boolean oldValue = this.m_instset;
            this.m_instset = m_instset;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "m_instset", oldValue, this.m_instset));
        }
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getName(), getPackage());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations


    // static operations


    // events


    // selections
    private Type R407_is_a_Type_inst;
    @Override
    public void setR407_is_a_Type( Type inst ) {
        R407_is_a_Type_inst = inst;
    }
    @Override
    public Type R407_is_a_Type() throws XtumlException {
        return R407_is_a_Type_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public BuiltInType self() {
        return this;
    }

    @Override
    public BuiltInType oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_BUILTINTYPE;
    }

}

class EmptyBuiltInType extends ModelInstance<BuiltInType,Sql> implements BuiltInType {

    // attributes
    public void setName( String ref_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getName() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getPackage() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPackage( String ref_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setPrimitive( boolean m_primitive ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getPrimitive() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public boolean getUnique() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setUnique( boolean m_unique ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setInst( boolean m_inst ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public boolean getInst() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public boolean getInstset() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setInstset( boolean m_instset ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }


    // operations


    // selections
    @Override
    public Type R407_is_a_Type() {
        return TypeImpl.EMPTY_TYPE;
    }


    @Override
    public String getKeyLetters() {
        return BuiltInTypeImpl.KEY_LETTERS;
    }

    @Override
    public BuiltInType self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public BuiltInType oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return BuiltInTypeImpl.EMPTY_BUILTINTYPE;
    }

}
