package io.ciera.tool.sql.architecture.statement.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.expression.ExpressionSet;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionSetImpl;
import io.ciera.tool.sql.architecture.invocable.CodeBlockSet;
import io.ciera.tool.sql.architecture.invocable.impl.CodeBlockSetImpl;
import io.ciera.tool.sql.architecture.statement.BreakSmtSet;
import io.ciera.tool.sql.architecture.statement.ContinueSmtSet;
import io.ciera.tool.sql.architecture.statement.DeleteSmtSet;
import io.ciera.tool.sql.architecture.statement.ExpressionAsStatementSet;
import io.ciera.tool.sql.architecture.statement.FinalizationSet;
import io.ciera.tool.sql.architecture.statement.ForSmtSet;
import io.ciera.tool.sql.architecture.statement.GenerateSet;
import io.ciera.tool.sql.architecture.statement.HaltSet;
import io.ciera.tool.sql.architecture.statement.IfSmtSet;
import io.ciera.tool.sql.architecture.statement.NullSmtSet;
import io.ciera.tool.sql.architecture.statement.RelateSmtSet;
import io.ciera.tool.sql.architecture.statement.ReturnSmtSet;
import io.ciera.tool.sql.architecture.statement.Statement;
import io.ciera.tool.sql.architecture.statement.StatementSet;
import io.ciera.tool.sql.architecture.statement.UnrelateSmtSet;
import io.ciera.tool.sql.architecture.statement.VariableSet;
import io.ciera.tool.sql.architecture.statement.WhileSmtSet;
import io.ciera.tool.sql.architecture.statement.impl.BreakSmtSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.ContinueSmtSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.DeleteSmtSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.ExpressionAsStatementSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.FinalizationSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.ForSmtSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.GenerateSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.HaltSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.IfSmtSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.NullSmtSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.RelateSmtSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.ReturnSmtSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.StatementSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.UnrelateSmtSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.VariableSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.WhileSmtSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class StatementSetImpl extends InstanceSet<StatementSet,Statement> implements StatementSet {

    public StatementSetImpl() {
    }

    public StatementSetImpl(Comparator<? super Statement> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        for ( Statement statement : this ) statement.setBody_name( ref_body_name );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( Statement statement : this ) statement.setParent_name( ref_parent_name );
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( Statement statement : this ) statement.setParent_package( ref_parent_package );
    }
    @Override
    public void setOal( String m_oal ) throws XtumlException {
        for ( Statement statement : this ) statement.setOal( m_oal );
    }
    @Override
    public void setStatement_number( String m_statement_number ) throws XtumlException {
        for ( Statement statement : this ) statement.setStatement_number( m_statement_number );
    }
    @Override
    public void setPrefix( String m_prefix ) throws XtumlException {
        for ( Statement statement : this ) statement.setPrefix( m_prefix );
    }
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        for ( Statement statement : this ) statement.setBlock_number( ref_block_number );
    }
    @Override
    public void setNext_statement_number( String ref_next_statement_number ) throws XtumlException {
        for ( Statement statement : this ) statement.setNext_statement_number( ref_next_statement_number );
    }


    // selections
    @Override
    public CodeBlockSet R450_is_contained_by_CodeBlock() throws XtumlException {
        CodeBlockSet codeblockset = new CodeBlockSetImpl();
        for ( Statement statement : this ) codeblockset.add( statement.R450_is_contained_by_CodeBlock() );
        return codeblockset;
    }
    @Override
    public BreakSmtSet R451_is_a_BreakSmt() throws XtumlException {
        BreakSmtSet breaksmtset = new BreakSmtSetImpl();
        for ( Statement statement : this ) breaksmtset.add( statement.R451_is_a_BreakSmt() );
        return breaksmtset;
    }
    @Override
    public ContinueSmtSet R451_is_a_ContinueSmt() throws XtumlException {
        ContinueSmtSet continuesmtset = new ContinueSmtSetImpl();
        for ( Statement statement : this ) continuesmtset.add( statement.R451_is_a_ContinueSmt() );
        return continuesmtset;
    }
    @Override
    public DeleteSmtSet R451_is_a_DeleteSmt() throws XtumlException {
        DeleteSmtSet deletesmtset = new DeleteSmtSetImpl();
        for ( Statement statement : this ) deletesmtset.add( statement.R451_is_a_DeleteSmt() );
        return deletesmtset;
    }
    @Override
    public ExpressionAsStatementSet R451_is_a_ExpressionAsStatement() throws XtumlException {
        ExpressionAsStatementSet expressionasstatementset = new ExpressionAsStatementSetImpl();
        for ( Statement statement : this ) expressionasstatementset.add( statement.R451_is_a_ExpressionAsStatement() );
        return expressionasstatementset;
    }
    @Override
    public ForSmtSet R451_is_a_ForSmt() throws XtumlException {
        ForSmtSet forsmtset = new ForSmtSetImpl();
        for ( Statement statement : this ) forsmtset.add( statement.R451_is_a_ForSmt() );
        return forsmtset;
    }
    @Override
    public GenerateSet R451_is_a_Generate() throws XtumlException {
        GenerateSet generateset = new GenerateSetImpl();
        for ( Statement statement : this ) generateset.add( statement.R451_is_a_Generate() );
        return generateset;
    }
    @Override
    public HaltSet R451_is_a_Halt() throws XtumlException {
        HaltSet haltset = new HaltSetImpl();
        for ( Statement statement : this ) haltset.add( statement.R451_is_a_Halt() );
        return haltset;
    }
    @Override
    public IfSmtSet R451_is_a_IfSmt() throws XtumlException {
        IfSmtSet ifsmtset = new IfSmtSetImpl();
        for ( Statement statement : this ) ifsmtset.add( statement.R451_is_a_IfSmt() );
        return ifsmtset;
    }
    @Override
    public NullSmtSet R451_is_a_NullSmt() throws XtumlException {
        NullSmtSet nullsmtset = new NullSmtSetImpl();
        for ( Statement statement : this ) nullsmtset.add( statement.R451_is_a_NullSmt() );
        return nullsmtset;
    }
    @Override
    public RelateSmtSet R451_is_a_RelateSmt() throws XtumlException {
        RelateSmtSet relatesmtset = new RelateSmtSetImpl();
        for ( Statement statement : this ) relatesmtset.add( statement.R451_is_a_RelateSmt() );
        return relatesmtset;
    }
    @Override
    public ReturnSmtSet R451_is_a_ReturnSmt() throws XtumlException {
        ReturnSmtSet returnsmtset = new ReturnSmtSetImpl();
        for ( Statement statement : this ) returnsmtset.add( statement.R451_is_a_ReturnSmt() );
        return returnsmtset;
    }
    @Override
    public UnrelateSmtSet R451_is_a_UnrelateSmt() throws XtumlException {
        UnrelateSmtSet unrelatesmtset = new UnrelateSmtSetImpl();
        for ( Statement statement : this ) unrelatesmtset.add( statement.R451_is_a_UnrelateSmt() );
        return unrelatesmtset;
    }
    @Override
    public WhileSmtSet R451_is_a_WhileSmt() throws XtumlException {
        WhileSmtSet whilesmtset = new WhileSmtSetImpl();
        for ( Statement statement : this ) whilesmtset.add( statement.R451_is_a_WhileSmt() );
        return whilesmtset;
    }
    @Override
    public VariableSet R457_declares_Variable() throws XtumlException {
        VariableSet variableset = new VariableSetImpl();
        for ( Statement statement : this ) variableset.addAll( statement.R457_declares_Variable() );
        return variableset;
    }
    @Override
    public StatementSet R477_executes_after_Statement() throws XtumlException {
        StatementSet statementset = new StatementSetImpl();
        for ( Statement statement : this ) statementset.add( statement.R477_executes_after_Statement() );
        return statementset;
    }
    @Override
    public StatementSet R477_executes_before_Statement() throws XtumlException {
        StatementSet statementset = new StatementSetImpl();
        for ( Statement statement : this ) statementset.add( statement.R477_executes_before_Statement() );
        return statementset;
    }
    @Override
    public FinalizationSet R485_finalizes_Finalization() throws XtumlException {
        FinalizationSet finalizationset = new FinalizationSetImpl();
        for ( Statement statement : this ) finalizationset.addAll( statement.R485_finalizes_Finalization() );
        return finalizationset;
    }
    @Override
    public ExpressionSet R775_may_contain_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( Statement statement : this ) expressionset.addAll( statement.R775_may_contain_Expression() );
        return expressionset;
    }


    @Override
    public Statement nullElement() {
        return StatementImpl.EMPTY_STATEMENT;
    }

    @Override
    public StatementSet emptySet() {
      return new StatementSetImpl();
    }

    @Override
    public StatementSet emptySet(Comparator<? super Statement> comp) {
      return new StatementSetImpl(comp);
    }

    @Override
    public List<Statement> elements() {
        return Arrays.asList(toArray(new Statement[0]));
    }

}
