package io.ciera.tool.sql.architecture.invocable.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.invocable.CodeBlock;
import io.ciera.tool.sql.architecture.invocable.CodeBlockSet;
import io.ciera.tool.sql.architecture.invocable.InvocableObjectSet;
import io.ciera.tool.sql.architecture.invocable.impl.InvocableObjectSetImpl;
import io.ciera.tool.sql.architecture.statement.ForSmtSet;
import io.ciera.tool.sql.architecture.statement.IfSmtSet;
import io.ciera.tool.sql.architecture.statement.StatementSet;
import io.ciera.tool.sql.architecture.statement.VariableInScopeSet;
import io.ciera.tool.sql.architecture.statement.WhileSmtSet;
import io.ciera.tool.sql.architecture.statement.impl.ForSmtSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.IfSmtSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.StatementSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.VariableInScopeSetImpl;
import io.ciera.tool.sql.architecture.statement.impl.WhileSmtSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class CodeBlockSetImpl extends InstanceSet<CodeBlockSet,CodeBlock> implements CodeBlockSet {

    public CodeBlockSetImpl() {
    }

    public CodeBlockSetImpl(Comparator<? super CodeBlock> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        for ( CodeBlock codeblock : this ) codeblock.setBody_name( ref_body_name );
    }
    @Override
    public void setTab_depth( int m_tab_depth ) throws XtumlException {
        for ( CodeBlock codeblock : this ) codeblock.setTab_depth( m_tab_depth );
    }
    @Override
    public void setTop_level( boolean m_top_level ) throws XtumlException {
        for ( CodeBlock codeblock : this ) codeblock.setTop_level( m_top_level );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( CodeBlock codeblock : this ) codeblock.setParent_name( ref_parent_name );
    }
    @Override
    public void setSuffix( String m_suffix ) throws XtumlException {
        for ( CodeBlock codeblock : this ) codeblock.setSuffix( m_suffix );
    }
    @Override
    public void setPrefix( String m_prefix ) throws XtumlException {
        for ( CodeBlock codeblock : this ) codeblock.setPrefix( m_prefix );
    }
    @Override
    public void setBlock_number( String m_block_number ) throws XtumlException {
        for ( CodeBlock codeblock : this ) codeblock.setBlock_number( m_block_number );
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( CodeBlock codeblock : this ) codeblock.setParent_package( ref_parent_package );
    }


    // selections
    @Override
    public InvocableObjectSet R4000_is_invoked_in_InvocableObject() throws XtumlException {
        InvocableObjectSet invocableobjectset = new InvocableObjectSetImpl();
        for ( CodeBlock codeblock : this ) invocableobjectset.add( codeblock.R4000_is_invoked_in_InvocableObject() );
        return invocableobjectset;
    }
    @Override
    public StatementSet R450_is_scope_for_Statement() throws XtumlException {
        StatementSet statementset = new StatementSetImpl();
        for ( CodeBlock codeblock : this ) statementset.addAll( codeblock.R450_is_scope_for_Statement() );
        return statementset;
    }
    @Override
    public IfSmtSet R453_controls_then_for_IfSmt() throws XtumlException {
        IfSmtSet ifsmtset = new IfSmtSetImpl();
        for ( CodeBlock codeblock : this ) ifsmtset.add( codeblock.R453_controls_then_for_IfSmt() );
        return ifsmtset;
    }
    @Override
    public IfSmtSet R454_controls_else_for_IfSmt() throws XtumlException {
        IfSmtSet ifsmtset = new IfSmtSetImpl();
        for ( CodeBlock codeblock : this ) ifsmtset.add( codeblock.R454_controls_else_for_IfSmt() );
        return ifsmtset;
    }
    @Override
    public ForSmtSet R455_controls_ForSmt() throws XtumlException {
        ForSmtSet forsmtset = new ForSmtSetImpl();
        for ( CodeBlock codeblock : this ) forsmtset.add( codeblock.R455_controls_ForSmt() );
        return forsmtset;
    }
    @Override
    public WhileSmtSet R456_controls_WhileSmt() throws XtumlException {
        WhileSmtSet whilesmtset = new WhileSmtSetImpl();
        for ( CodeBlock codeblock : this ) whilesmtset.add( codeblock.R456_controls_WhileSmt() );
        return whilesmtset;
    }
    @Override
    public VariableInScopeSet R458_has_in_scope_VariableInScope() throws XtumlException {
        VariableInScopeSet variableinscopeset = new VariableInScopeSetImpl();
        for ( CodeBlock codeblock : this ) variableinscopeset.addAll( codeblock.R458_has_in_scope_VariableInScope() );
        return variableinscopeset;
    }


    @Override
    public CodeBlock nullElement() {
        return CodeBlockImpl.EMPTY_CODEBLOCK;
    }

    @Override
    public CodeBlockSet emptySet() {
      return new CodeBlockSetImpl();
    }

    @Override
    public CodeBlockSet emptySet(Comparator<? super CodeBlock> comp) {
      return new CodeBlockSetImpl(comp);
    }

    @Override
    public List<CodeBlock> elements() {
        return Arrays.asList(toArray(new CodeBlock[0]));
    }

}
