package io.ciera.tool.sql.architecture.interfaces.impl;


import io.ciera.runtime.instanceloading.AttributeChangedDelta;
import io.ciera.runtime.instanceloading.InstanceCreatedDelta;
import io.ciera.runtime.summit.application.IRunContext;
import io.ciera.runtime.summit.classes.IInstanceIdentifier;
import io.ciera.runtime.summit.classes.InstanceIdentifier;
import io.ciera.runtime.summit.classes.ModelInstance;
import io.ciera.runtime.summit.exceptions.EmptyInstanceException;
import io.ciera.runtime.summit.exceptions.InstancePopulationException;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.IWhere;
import io.ciera.runtime.summit.types.IXtumlType;
import io.ciera.runtime.summit.types.StringUtil;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.Sql;
import io.ciera.tool.sql.architecture.interfaces.Message;
import io.ciera.tool.sql.architecture.interfaces.Port;
import io.ciera.tool.sql.architecture.interfaces.PortMessage;
import io.ciera.tool.sql.architecture.interfaces.impl.MessageImpl;
import io.ciera.tool.sql.architecture.interfaces.impl.PortImpl;
import io.ciera.tool.sql.architecture.invocable.FormalParameter;
import io.ciera.tool.sql.architecture.invocable.InvocableObject;
import io.ciera.tool.sql.architecture.invocable.impl.InvocableObjectImpl;
import io.ciera.tool.sql.architecture.type.TypeReference;


public class PortMessageImpl extends ModelInstance<PortMessage,Sql> implements PortMessage {

    public static final String KEY_LETTERS = "PortMessage";
    public static final PortMessage EMPTY_PORTMESSAGE = new EmptyPortMessage();

    private Sql context;

    // constructors
    private PortMessageImpl( Sql context ) {
        this.context = context;
        ref_port_name = "";
        ref_port_package = "";
        ref_iface_name = "";
        ref_iface_package = "";
        ref_msg_name = "";
        R420_is_implemented_within_Port_inst = PortImpl.EMPTY_PORT;
        R420_provides_implementation_for_Message_inst = MessageImpl.EMPTY_MESSAGE;
        R427_is_a_InvocableObject_inst = InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
    }

    private PortMessageImpl( Sql context, UniqueId instanceId, String ref_port_name, String ref_port_package, String ref_iface_name, String ref_iface_package, String ref_msg_name ) {
        super(instanceId);
        this.context = context;
        this.ref_port_name = ref_port_name;
        this.ref_port_package = ref_port_package;
        this.ref_iface_name = ref_iface_name;
        this.ref_iface_package = ref_iface_package;
        this.ref_msg_name = ref_msg_name;
        R420_is_implemented_within_Port_inst = PortImpl.EMPTY_PORT;
        R420_provides_implementation_for_Message_inst = MessageImpl.EMPTY_MESSAGE;
        R427_is_a_InvocableObject_inst = InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
    }

    public static PortMessage create( Sql context ) throws XtumlException {
        PortMessage newPortMessage = new PortMessageImpl( context );
        if ( context.addInstance( newPortMessage ) ) {
            newPortMessage.getRunContext().addChange(new InstanceCreatedDelta(newPortMessage, KEY_LETTERS));
            return newPortMessage;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }

    public static PortMessage create( Sql context, UniqueId instanceId, String ref_port_name, String ref_port_package, String ref_iface_name, String ref_iface_package, String ref_msg_name ) throws XtumlException {
        PortMessage newPortMessage = new PortMessageImpl( context, instanceId, ref_port_name, ref_port_package, ref_iface_name, ref_iface_package, ref_msg_name );
        if ( context.addInstance( newPortMessage ) ) {
            return newPortMessage;
        }
        else throw new InstancePopulationException( "Instance already exists within this population." );
    }



    // attributes
    private String ref_port_name;
    @Override
    public void setPort_name(String ref_port_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_port_name, this.ref_port_name)) {
            final String oldValue = this.ref_port_name;
            this.ref_port_name = ref_port_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_port_name", oldValue, this.ref_port_name));
        }
    }
    @Override
    public String getPort_name() throws XtumlException {
        checkLiving();
        return ref_port_name;
    }
    private String ref_port_package;
    @Override
    public void setPort_package(String ref_port_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_port_package, this.ref_port_package)) {
            final String oldValue = this.ref_port_package;
            this.ref_port_package = ref_port_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_port_package", oldValue, this.ref_port_package));
        }
    }
    @Override
    public String getPort_package() throws XtumlException {
        checkLiving();
        return ref_port_package;
    }
    private String ref_iface_name;
    @Override
    public String getIface_name() throws XtumlException {
        checkLiving();
        return ref_iface_name;
    }
    @Override
    public void setIface_name(String ref_iface_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_iface_name, this.ref_iface_name)) {
            final String oldValue = this.ref_iface_name;
            this.ref_iface_name = ref_iface_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_iface_name", oldValue, this.ref_iface_name));
        }
    }
    private String ref_iface_package;
    @Override
    public String getIface_package() throws XtumlException {
        checkLiving();
        return ref_iface_package;
    }
    @Override
    public void setIface_package(String ref_iface_package) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_iface_package, this.ref_iface_package)) {
            final String oldValue = this.ref_iface_package;
            this.ref_iface_package = ref_iface_package;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_iface_package", oldValue, this.ref_iface_package));
        }
    }
    private String ref_msg_name;
    @Override
    public void setMsg_name(String ref_msg_name) throws XtumlException {
        checkLiving();
        if (StringUtil.inequality(ref_msg_name, this.ref_msg_name)) {
            final String oldValue = this.ref_msg_name;
            this.ref_msg_name = ref_msg_name;
            getRunContext().addChange(new AttributeChangedDelta(this, KEY_LETTERS, "ref_msg_name", oldValue, this.ref_msg_name));
        }
    }
    @Override
    public String getMsg_name() throws XtumlException {
        checkLiving();
        return ref_msg_name;
    }


    // instance identifiers
    @Override
    public IInstanceIdentifier getId1() {
        try {
            return new InstanceIdentifier(getPort_name(), getPort_package(), getIface_name(), getIface_package(), getMsg_name());
        }
        catch ( XtumlException e ) {
            getRunContext().getLog().error(e);
            System.exit(1);
            return null;
        }
    }

    // operations
    @Override
    public void render() throws XtumlException {
        Port port = self().R420_is_implemented_within_Port();
        Message message = self().R420_provides_implementation_for_Message();
        context().T().push_buffer();
        InvocableObject invocable = self().R427_is_a_InvocableObject();
        String parameter_list = invocable.parameter_list();
        String body = invocable.body();
        context().T().pop_buffer();
        String invocation_parameter_list = "";
        FormalParameter parm = self().R427_is_a_InvocableObject().R429_declares_signature_with_FormalParameter().any();
        FormalParameter prev_parm = parm.R404_follows_FormalParameter();
        while ( !prev_parm.isEmpty() ) {
            parm = prev_parm;
            prev_parm = parm.R404_follows_FormalParameter();
        }
        String sep = "";
        while ( !parm.isEmpty() ) {
            invocation_parameter_list = ( invocation_parameter_list + sep ) + parm.getName();
            sep = ", ";
            parm = parm.R404_precedes_FormalParameter();
        }
        boolean inbound = port.getProvider() && message.getTo_provider() || !port.getProvider() && !message.getTo_provider();
        context().T().include( "interface/t.portmessage.java", body, inbound, invocation_parameter_list, parameter_list, self() );
    }

    @Override
    public void render_deliver() throws XtumlException {
        String message_parameter_list = "";
        FormalParameter msg_parm = self().R427_is_a_InvocableObject().R429_declares_signature_with_FormalParameter().any();
        FormalParameter prev_msg_parm = msg_parm.R404_follows_FormalParameter();
        while ( !prev_msg_parm.isEmpty() ) {
            msg_parm = prev_msg_parm;
            prev_msg_parm = msg_parm.R404_follows_FormalParameter();
        }
        String sep = "";
        int i = 0;
        while ( !msg_parm.isEmpty() ) {
            String accessor = ( "message.get(" + context().STRING().itoa( i ) ) + ")";
            TypeReference parm_dt = msg_parm.R431_is_typed_by_TypeReference();
            if ( StringUtil.equality("boolean", parm_dt.getType_name()) ) {
                message_parameter_list = ( ( ( message_parameter_list + sep ) + "BooleanUtil.deserialize(" ) + accessor ) + ")";
            }
            else if ( StringUtil.equality("int", parm_dt.getType_name()) ) {
                message_parameter_list = ( ( ( message_parameter_list + sep ) + "IntegerUtil.deserialize(" ) + accessor ) + ")";
            }
            else if ( StringUtil.equality("double", parm_dt.getType_name()) ) {
                message_parameter_list = ( ( ( message_parameter_list + sep ) + "RealUtil.deserialize(" ) + accessor ) + ")";
            }
            else if ( StringUtil.equality("String", parm_dt.getType_name()) ) {
                message_parameter_list = ( ( ( message_parameter_list + sep ) + "StringUtil.deserialize(" ) + accessor ) + ")";
            }
            else {
                message_parameter_list = ( ( ( ( message_parameter_list + sep ) + parm_dt.getType_reference_name() ) + ".deserialize(" ) + accessor ) + ")";
            }
            sep = ", ";
            i = i + 1;
            msg_parm = msg_parm.R404_precedes_FormalParameter();
        }
        context().T().include( "interface/t.message.deliver.java", message_parameter_list, self() );
    }



    // static operations


    // events


    // selections
    private Port R420_is_implemented_within_Port_inst;
    @Override
    public void setR420_is_implemented_within_Port( Port inst ) {
        R420_is_implemented_within_Port_inst = inst;
    }
    @Override
    public Port R420_is_implemented_within_Port() throws XtumlException {
        return R420_is_implemented_within_Port_inst;
    }
    private Message R420_provides_implementation_for_Message_inst;
    @Override
    public void setR420_provides_implementation_for_Message( Message inst ) {
        R420_provides_implementation_for_Message_inst = inst;
    }
    @Override
    public Message R420_provides_implementation_for_Message() throws XtumlException {
        return R420_provides_implementation_for_Message_inst;
    }
    private InvocableObject R427_is_a_InvocableObject_inst;
    @Override
    public void setR427_is_a_InvocableObject( InvocableObject inst ) {
        R427_is_a_InvocableObject_inst = inst;
    }
    @Override
    public InvocableObject R427_is_a_InvocableObject() throws XtumlException {
        return R427_is_a_InvocableObject_inst;
    }


    @Override
    public IRunContext getRunContext() {
        return context().getRunContext();
    }

    @Override
    public Sql context() {
        return context;
    }

    @Override
    public String getKeyLetters() {
        return KEY_LETTERS;
    }

    @Override
    public PortMessage self() {
        return this;
    }

    @Override
    public PortMessage oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        if (condition.evaluate(this)) return this;
        else return EMPTY_PORTMESSAGE;
    }

}

class EmptyPortMessage extends ModelInstance<PortMessage,Sql> implements PortMessage {

    // attributes
    public void setPort_name( String ref_port_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getPort_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setPort_package( String ref_port_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getPort_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public String getIface_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIface_name( String ref_iface_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getIface_package() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }
    public void setIface_package( String ref_iface_package ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public void setMsg_name( String ref_msg_name ) throws XtumlException {
        throw new EmptyInstanceException( "Cannot set attribute of empty instance." );
    }
    public String getMsg_name() throws XtumlException {
        throw new EmptyInstanceException( "Cannot get attribute of empty instance." );
    }


    // operations
    public void render() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }
    public void render_deliver() throws XtumlException {
        throw new EmptyInstanceException( "Cannot invoke operation on empty instance." );
    }


    // selections
    @Override
    public Port R420_is_implemented_within_Port() {
        return PortImpl.EMPTY_PORT;
    }
    @Override
    public Message R420_provides_implementation_for_Message() {
        return MessageImpl.EMPTY_MESSAGE;
    }
    @Override
    public InvocableObject R427_is_a_InvocableObject() {
        return InvocableObjectImpl.EMPTY_INVOCABLEOBJECT;
    }


    @Override
    public String getKeyLetters() {
        return PortMessageImpl.KEY_LETTERS;
    }

    @Override
    public PortMessage self() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public PortMessage oneWhere(IWhere<IXtumlType> condition) throws XtumlException {
        if (null == condition) throw new XtumlException("Null condition passed to selection.");
        return PortMessageImpl.EMPTY_PORTMESSAGE;
    }

}
