package io.ciera.tool.sql.architecture.interfaces.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.runtime.summit.types.UniqueId;
import io.ciera.tool.sql.architecture.file.FileSet;
import io.ciera.tool.sql.architecture.file.impl.FileSetImpl;
import io.ciera.tool.sql.architecture.interfaces.Iface;
import io.ciera.tool.sql.architecture.interfaces.IfaceSet;
import io.ciera.tool.sql.architecture.interfaces.MessageSet;
import io.ciera.tool.sql.architecture.interfaces.PortSet;
import io.ciera.tool.sql.architecture.interfaces.impl.MessageSetImpl;
import io.ciera.tool.sql.architecture.interfaces.impl.PortSetImpl;
import io.ciera.tool.sql.ooaofooa.component.C_ISet;
import io.ciera.tool.sql.ooaofooa.component.impl.C_ISetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class IfaceSetImpl extends InstanceSet<IfaceSet,Iface> implements IfaceSet {

    public IfaceSetImpl() {
    }

    public IfaceSetImpl(Comparator<? super Iface> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setPackage( String ref_package ) throws XtumlException {
        for ( Iface iface : this ) iface.setPackage( ref_package );
    }
    @Override
    public void setName( String ref_name ) throws XtumlException {
        for ( Iface iface : this ) iface.setName( ref_name );
    }
    @Override
    public void setIface_Id( UniqueId ref_iface_Id ) throws XtumlException {
        for ( Iface iface : this ) iface.setIface_Id( ref_iface_Id );
    }


    // selections
    @Override
    public FileSet R401_is_a_File() throws XtumlException {
        FileSet fileset = new FileSetImpl();
        for ( Iface iface : this ) fileset.add( iface.R401_is_a_File() );
        return fileset;
    }
    @Override
    public PortSet R418_is_implemented_by_Port() throws XtumlException {
        PortSet portset = new PortSetImpl();
        for ( Iface iface : this ) portset.addAll( iface.R418_is_implemented_by_Port() );
        return portset;
    }
    @Override
    public MessageSet R419_defines_communication_through_Message() throws XtumlException {
        MessageSet messageset = new MessageSetImpl();
        for ( Iface iface : this ) messageset.addAll( iface.R419_defines_communication_through_Message() );
        return messageset;
    }
    @Override
    public C_ISet R421_is_basis_for_C_I() throws XtumlException {
        C_ISet c_iset = new C_ISetImpl();
        for ( Iface iface : this ) c_iset.add( iface.R421_is_basis_for_C_I() );
        return c_iset;
    }


    @Override
    public Iface nullElement() {
        return IfaceImpl.EMPTY_IFACE;
    }

    @Override
    public IfaceSet emptySet() {
      return new IfaceSetImpl();
    }

    @Override
    public IfaceSet emptySet(Comparator<? super Iface> comp) {
      return new IfaceSetImpl(comp);
    }

    @Override
    public List<Iface> elements() {
        Iface[] elements = toArray(new Iface[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
