package io.ciera.tool.sql.architecture.file.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.file.FileSet;
import io.ciera.tool.sql.architecture.file.GeneralFile;
import io.ciera.tool.sql.architecture.file.GeneralFileSet;
import io.ciera.tool.sql.architecture.file.impl.FileSetImpl;
import io.ciera.tool.sql.loader.PopulationLoaderSet;
import io.ciera.tool.sql.loader.impl.PopulationLoaderSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class GeneralFileSetImpl extends InstanceSet<GeneralFileSet,GeneralFile> implements GeneralFileSet {

    public GeneralFileSetImpl() {
    }

    public GeneralFileSetImpl(Comparator<? super GeneralFile> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setContents( String m_contents ) throws XtumlException {
        for ( GeneralFile generalfile : this ) generalfile.setContents( m_contents );
    }
    @Override
    public void setName( String ref_name ) throws XtumlException {
        for ( GeneralFile generalfile : this ) generalfile.setName( ref_name );
    }
    @Override
    public void setPackage( String ref_package ) throws XtumlException {
        for ( GeneralFile generalfile : this ) generalfile.setPackage( ref_package );
    }


    // selections
    @Override
    public PopulationLoaderSet R3009_is_a_PopulationLoader() throws XtumlException {
        PopulationLoaderSet populationloaderset = new PopulationLoaderSetImpl();
        for ( GeneralFile generalfile : this ) populationloaderset.add( generalfile.R3009_is_a_PopulationLoader() );
        return populationloaderset;
    }
    @Override
    public FileSet R401_is_a_File() throws XtumlException {
        FileSet fileset = new FileSetImpl();
        for ( GeneralFile generalfile : this ) fileset.add( generalfile.R401_is_a_File() );
        return fileset;
    }


    @Override
    public GeneralFile nullElement() {
        return GeneralFileImpl.EMPTY_GENERALFILE;
    }

    @Override
    public GeneralFileSet emptySet() {
      return new GeneralFileSetImpl();
    }

    @Override
    public GeneralFileSet emptySet(Comparator<? super GeneralFile> comp) {
      return new GeneralFileSetImpl(comp);
    }

    @Override
    public List<GeneralFile> elements() {
        GeneralFile[] elements = toArray(new GeneralFile[0]);
        Arrays.sort(elements, (a, b) -> {
            try {
                return a.getName().compareTo(b.getName());
            } catch (XtumlException e) { return 0; }
        });
        return Arrays.asList(elements);
    }

}
