package io.ciera.tool.sql.architecture.expression.impl;


import io.ciera.runtime.summit.classes.InstanceSet;
import io.ciera.runtime.summit.exceptions.XtumlException;
import io.ciera.tool.sql.architecture.expression.ExpressionSet;
import io.ciera.tool.sql.architecture.expression.UnaryOperation;
import io.ciera.tool.sql.architecture.expression.UnaryOperationSet;
import io.ciera.tool.sql.architecture.expression.impl.ExpressionSetImpl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;


public class UnaryOperationSetImpl extends InstanceSet<UnaryOperationSet,UnaryOperation> implements UnaryOperationSet {

    public UnaryOperationSetImpl() {
    }

    public UnaryOperationSetImpl(Comparator<? super UnaryOperation> comp) {
        super(comp);
    }

    // attributes
    @Override
    public void setOperator( String m_operator ) throws XtumlException {
        for ( UnaryOperation unaryoperation : this ) unaryoperation.setOperator( m_operator );
    }
    @Override
    public void setBody_name( String ref_body_name ) throws XtumlException {
        for ( UnaryOperation unaryoperation : this ) unaryoperation.setBody_name( ref_body_name );
    }
    @Override
    public void setParent_package( String ref_parent_package ) throws XtumlException {
        for ( UnaryOperation unaryoperation : this ) unaryoperation.setParent_package( ref_parent_package );
    }
    @Override
    public void setExpression_number( String ref_expression_number ) throws XtumlException {
        for ( UnaryOperation unaryoperation : this ) unaryoperation.setExpression_number( ref_expression_number );
    }
    @Override
    public void setOp_expression_number( String ref_op_expression_number ) throws XtumlException {
        for ( UnaryOperation unaryoperation : this ) unaryoperation.setOp_expression_number( ref_op_expression_number );
    }
    @Override
    public void setParent_name( String ref_parent_name ) throws XtumlException {
        for ( UnaryOperation unaryoperation : this ) unaryoperation.setParent_name( ref_parent_name );
    }
    @Override
    public void setInvocation( boolean m_invocation ) throws XtumlException {
        for ( UnaryOperation unaryoperation : this ) unaryoperation.setInvocation( m_invocation );
    }
    @Override
    public void setBlock_number( String ref_block_number ) throws XtumlException {
        for ( UnaryOperation unaryoperation : this ) unaryoperation.setBlock_number( ref_block_number );
    }
    @Override
    public void setStatement_number( String ref_statement_number ) throws XtumlException {
        for ( UnaryOperation unaryoperation : this ) unaryoperation.setStatement_number( ref_statement_number );
    }


    // selections
    @Override
    public ExpressionSet R776_is_a_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( UnaryOperation unaryoperation : this ) expressionset.add( unaryoperation.R776_is_a_Expression() );
        return expressionset;
    }
    @Override
    public ExpressionSet R777_has_single_operand_Expression() throws XtumlException {
        ExpressionSet expressionset = new ExpressionSetImpl();
        for ( UnaryOperation unaryoperation : this ) expressionset.add( unaryoperation.R777_has_single_operand_Expression() );
        return expressionset;
    }


    @Override
    public UnaryOperation nullElement() {
        return UnaryOperationImpl.EMPTY_UNARYOPERATION;
    }

    @Override
    public UnaryOperationSet emptySet() {
      return new UnaryOperationSetImpl();
    }

    @Override
    public UnaryOperationSet emptySet(Comparator<? super UnaryOperation> comp) {
      return new UnaryOperationSetImpl(comp);
    }

    @Override
    public List<UnaryOperation> elements() {
        return Arrays.asList(toArray(new UnaryOperation[0]));
    }

}
